/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.core.nbt.LogicEntry;
import harmonised.pmmo.core.nbt.NBTUtils;
import harmonised.pmmo.util.Functions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public record ObjectData(boolean override, Set<String> tagValues, Map<ReqType, Map<String, Integer>> reqs, Map<ReqType, List<LogicEntry>> nbtReqs, Map<ResourceLocation, Integer> negativeEffects, Map<EventType, Map<String, Long>> xpValues, Map<EventType, Map<String, Map<String, Long>>> damageXpValues, Map<EventType, List<LogicEntry>> nbtXpValues, Map<ModifierDataType, Map<String, Double>> bonuses, Map<ModifierDataType, List<LogicEntry>> nbtBonuses, Map<ResourceLocation, CodecTypes.SalvageData> salvage, VeinData veinData) implements DataSource<ObjectData>
{
    private final Map<ResourceLocation, CodecTypes.SalvageData> salvage;
    public static final Codec<ObjectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("override").forGetter(od -> Optional.of(od.override())), (App)Codec.STRING.listOf().optionalFieldOf("isTagFor").forGetter(od -> Optional.of(new ArrayList<String>(od.tagValues))), (App)Codec.optionalField((String)"requirements", (Codec)Codec.simpleMap(ReqType.CODEC, CodecTypes.INTEGER_CODEC, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])ReqType.values())).codec()).forGetter(od -> Optional.of(od.reqs())), (App)Codec.optionalField((String)"nbt_requirements", (Codec)Codec.simpleMap(ReqType.CODEC, (Codec)Codec.list(LogicEntry.CODEC), (Keyable)StringRepresentable.m_14357_((StringRepresentable[])ReqType.values())).codec()).forGetter(od -> Optional.of(od.nbtReqs())), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.INT).optionalFieldOf("negative_effect").forGetter(od -> Optional.of(od.negativeEffects())), (App)Codec.optionalField((String)"xp_values", (Codec)Codec.simpleMap(EventType.CODEC, CodecTypes.LONG_CODEC, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])EventType.values())).codec()).forGetter(od -> Optional.of(od.xpValues())), (App)Codec.optionalField((String)"nbt_xp_values", (Codec)Codec.simpleMap(EventType.CODEC, (Codec)Codec.list(LogicEntry.CODEC), (Keyable)StringRepresentable.m_14357_((StringRepresentable[])EventType.values())).codec()).forGetter(od -> Optional.of(od.nbtXpValues())), (App)Codec.optionalField((String)"dealt_damage_xp", CodecTypes.DAMAGE_XP_CODEC).forGetter(od -> Optional.of((Map)od.damageXpValues().getOrDefault(EventType.DEAL_DAMAGE, new HashMap()))), (App)Codec.optionalField((String)"received_damage_xp", CodecTypes.DAMAGE_XP_CODEC).forGetter(od -> Optional.of((Map)od.damageXpValues().getOrDefault(EventType.RECEIVE_DAMAGE, new HashMap()))), (App)Codec.optionalField((String)"bonuses", (Codec)Codec.simpleMap(ModifierDataType.CODEC, CodecTypes.DOUBLE_CODEC, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])ModifierDataType.values())).codec()).forGetter(od -> Optional.of(od.bonuses())), (App)Codec.optionalField((String)"nbt_bonuses", (Codec)Codec.simpleMap(ModifierDataType.CODEC, (Codec)Codec.list(LogicEntry.CODEC), (Keyable)StringRepresentable.m_14357_((StringRepresentable[])ModifierDataType.values())).codec()).forGetter(od -> Optional.of(od.nbtBonuses())), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, CodecTypes.SALVAGE_CODEC).optionalFieldOf("salvage").forGetter(od -> Optional.of(od.salvage())), (App)VeinData.VEIN_DATA_CODEC.optionalFieldOf("vein_data").forGetter(od -> Optional.of(od.veinData()))).apply((Applicative)instance, (override, tags, reqs, nbtreqs, effects, xp, nbtXp, dealt, received, bonus, nbtbonus, salvage, vein) -> new ObjectData(override.orElse(false), new HashSet<String>(tags.orElse(List.of())), DataSource.clearEmptyValues(reqs.orElse(new HashMap())), DataSource.clearEmptyValues(nbtreqs.orElse(new HashMap())), DataSource.clearEmptyValues(effects.orElse(new HashMap())), DataSource.clearEmptyValues(xp.orElse(new HashMap())), Map.of(EventType.DEAL_DAMAGE, DataSource.clearEmptyValues(dealt.orElse(new HashMap())), EventType.RECEIVE_DAMAGE, DataSource.clearEmptyValues(received.orElse(new HashMap()))), DataSource.clearEmptyValues(nbtXp.orElse(new HashMap())), DataSource.clearEmptyValues(bonus.orElse(new HashMap())), DataSource.clearEmptyValues(nbtbonus.orElse(new HashMap())), DataSource.clearEmptyValues(salvage.orElse(new HashMap())), vein.orElse(VeinData.EMPTY))));

    public ObjectData() {
        this(false, new HashSet<String>(), new HashMap<ReqType, Map<String, Integer>>(), new HashMap<ReqType, List<LogicEntry>>(), new HashMap<ResourceLocation, Integer>(), new HashMap<EventType, Map<String, Long>>(), new HashMap<EventType, Map<String, Map<String, Long>>>(), new HashMap<EventType, List<LogicEntry>>(), new HashMap<ModifierDataType, Map<String, Double>>(), new HashMap<ModifierDataType, List<LogicEntry>>(), new HashMap<ResourceLocation, CodecTypes.SalvageData>(), VeinData.EMPTY);
    }

    public Map<ResourceLocation, CodecTypes.SalvageData> salvage() {
        return this.salvage.entrySet().stream().filter(entry -> !((Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)entry.getKey())).equals(Items.f_41852_)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<String, Long> getXpValues(EventType type, CompoundTag nbt) {
        if (this.nbtXpValues().get(type) == null) {
            return switch (type) {
                case EventType.RECEIVE_DAMAGE, EventType.DEAL_DAMAGE -> ((Map)this.damageXpValues().getOrDefault(type, new HashMap())).getOrDefault(nbt.m_128461_("damage_type"), new HashMap());
                default -> this.xpValues().getOrDefault(type, new HashMap());
            };
        }
        return NBTUtils.getExperienceAward(this.nbtXpValues().get(type), nbt);
    }

    @Override
    public void setXpValues(EventType type, Map<String, Long> award) {
        this.xpValues().put(type, award);
    }

    @Override
    public Map<String, Double> getBonuses(ModifierDataType type, CompoundTag nbt) {
        return this.nbtBonuses().get(type) == null ? (Map)this.bonuses().getOrDefault(type, new HashMap()) : NBTUtils.getBonuses(this.nbtBonuses().get(type), nbt);
    }

    @Override
    public void setBonuses(ModifierDataType type, Map<String, Double> bonuses) {
        this.bonuses().put(type, bonuses);
    }

    @Override
    public Map<String, Integer> getReqs(ReqType type, CompoundTag nbt) {
        return this.nbtReqs().get(type) == null ? (Map)this.reqs().getOrDefault(type, new HashMap()) : NBTUtils.getRequirement(this.nbtReqs().get(type), nbt);
    }

    @Override
    public void setReqs(ReqType type, Map<String, Integer> reqs) {
        this.reqs().put(type, reqs);
    }

    @Override
    public Map<ResourceLocation, Integer> getNegativeEffect() {
        return this.negativeEffects();
    }

    @Override
    public void setNegativeEffects(Map<ResourceLocation, Integer> neg) {
        this.negativeEffects().clear();
        this.negativeEffects().putAll(neg);
    }

    @Override
    public Set<String> getTagValues() {
        return this.tagValues();
    }

    @Override
    public ObjectData combine(ObjectData two) {
        HashSet<String> tagValues = new HashSet<String>();
        HashMap<EventType, Map<String, Long>> xpValues = new HashMap<EventType, Map<String, Long>>();
        HashMap<EventType, List<LogicEntry>> nbtXp = new HashMap<EventType, List<LogicEntry>>();
        HashMap<EventType, Map<String, Map<String, Long>>> damageXP = new HashMap<EventType, Map<String, Map<String, Long>>>();
        HashMap<ModifierDataType, Map<String, Double>> bonuses = new HashMap<ModifierDataType, Map<String, Double>>();
        HashMap<ModifierDataType, List<LogicEntry>> nbtBonus = new HashMap<ModifierDataType, List<LogicEntry>>();
        HashMap<ReqType, Map<String, Integer>> reqs = new HashMap<ReqType, Map<String, Integer>>();
        HashMap<ReqType, List<LogicEntry>> nbtReq = new HashMap<ReqType, List<LogicEntry>>();
        HashMap<ResourceLocation, Integer> reqEffects = new HashMap<ResourceLocation, Integer>();
        HashMap<ResourceLocation, CodecTypes.SalvageData> salvage = new HashMap<ResourceLocation, CodecTypes.SalvageData>();
        VeinData[] combinedVein = new VeinData[]{this.veinData()};
        BiConsumer<ObjectData, ObjectData> bothOrNeither = (o, t) -> {
            nbtXp.putAll(o.nbtXpValues());
            t.nbtXpValues().forEach((event, logic) -> nbtXp.merge((EventType)event, (List<LogicEntry>)logic, (a, b) -> {
                ArrayList list = new ArrayList(a);
                list.addAll(b);
                return list;
            }));
            nbtBonus.putAll(o.nbtBonuses());
            t.nbtBonuses().forEach((modifier, logic) -> nbtBonus.merge((ModifierDataType)modifier, (List<LogicEntry>)logic, (a, b) -> {
                ArrayList list = new ArrayList(a);
                list.addAll(b);
                return list;
            }));
            nbtReq.putAll(o.nbtReqs());
            t.nbtReqs().forEach((req, logic) -> nbtReq.merge((ReqType)req, (List<LogicEntry>)logic, (a, b) -> {
                ArrayList list = new ArrayList(a);
                list.addAll(b);
                return list;
            }));
            tagValues.addAll(o.tagValues());
            t.tagValues.forEach(rl -> {
                if (!tagValues.contains(rl)) {
                    tagValues.add((String)rl);
                }
            });
            xpValues.putAll(o.xpValues());
            t.xpValues().forEach((event, map) -> xpValues.merge((EventType)event, (Map<String, Long>)map, (oMap, nMap) -> {
                HashMap mergedMap = new HashMap(oMap);
                nMap.forEach((k, v) -> mergedMap.merge(k, v, (o1, n1) -> o1 > n1 ? o1 : n1));
                return mergedMap;
            }));
            damageXP.putAll(o.damageXpValues());
            t.damageXpValues().forEach((event, map) -> map.forEach((dmg, xp) -> damageXP.computeIfAbsent((EventType)event, e -> new HashMap()).merge(dmg, xp, (oMap, nMap) -> {
                HashMap mergedMap = new HashMap(oMap);
                nMap.forEach((k, v) -> mergedMap.merge(k, v, (o1, n1) -> o1 > n1 ? o1 : n1));
                return mergedMap;
            })));
            bonuses.putAll(o.bonuses());
            t.bonuses().forEach((event, map) -> bonuses.merge((ModifierDataType)event, (Map<String, Double>)map, (oMap, nMap) -> {
                HashMap mergedMap = new HashMap(oMap);
                nMap.forEach((k, v) -> mergedMap.merge(k, v, (o1, n1) -> o1 > n1 ? o1 : n1));
                return mergedMap;
            }));
            reqs.putAll(o.reqs());
            t.reqs().forEach((event, map) -> reqs.merge((ReqType)event, (Map<String, Integer>)map, (oMap, nMap) -> {
                HashMap mergedMap = new HashMap(oMap);
                nMap.forEach((k, v) -> mergedMap.merge(k, v, (o1, n1) -> o1 > n1 ? o1 : n1));
                return mergedMap;
            }));
            reqEffects.putAll(o.negativeEffects());
            t.negativeEffects().forEach((skill, level) -> reqEffects.merge((ResourceLocation)skill, (Integer)level, (o1, n1) -> o1 > n1 ? o1 : n1));
            salvage.putAll(o.salvage());
            t.salvage().forEach((rl, data) -> salvage.merge((ResourceLocation)rl, (CodecTypes.SalvageData)data, (oD, nD) -> CodecTypes.SalvageData.combine(oD, nD, o.override(), t.override())));
            combinedVein[0] = combinedVein[0].combine(t.veinData());
        };
        Functions.biPermutation(this, two, this.override(), two.override(), (o, t) -> {
            tagValues.addAll(o.tagValues().isEmpty() ? t.tagValues() : o.tagValues());
            xpValues.putAll(o.xpValues().isEmpty() ? t.xpValues() : o.xpValues());
            nbtXp.putAll(o.nbtXpValues().isEmpty() ? t.nbtXpValues() : o.nbtXpValues());
            damageXP.putAll(o.damageXpValues().isEmpty() ? t.damageXpValues() : o.damageXpValues());
            bonuses.putAll(o.bonuses().isEmpty() ? t.bonuses() : o.bonuses());
            nbtBonus.putAll(o.nbtBonuses().isEmpty() ? t.nbtBonuses() : o.nbtBonuses());
            reqs.putAll(o.reqs().isEmpty() ? t.reqs() : o.reqs());
            nbtReq.putAll(o.nbtReqs().isEmpty() ? t.nbtReqs() : o.nbtReqs());
            reqEffects.putAll(o.negativeEffects().isEmpty() ? t.negativeEffects() : o.negativeEffects());
            salvage.putAll(o.salvage().isEmpty() ? t.salvage() : o.salvage());
            combinedVein[0] = o.veinData().isUnconfigured() ? t.veinData() : o.veinData();
        }, bothOrNeither, bothOrNeither);
        return new ObjectData(this.override() || two.override(), tagValues, reqs, nbtReq, reqEffects, xpValues, damageXP, nbtXp, bonuses, nbtBonus, salvage, combinedVein[0]);
    }

    @Override
    public boolean isUnconfigured() {
        return this.reqs().values().stream().allMatch(Map::isEmpty) && this.nbtReqs().values().stream().allMatch(List::isEmpty) && this.negativeEffects().isEmpty() && this.xpValues().values().stream().allMatch(Map::isEmpty) && this.nbtXpValues().values().stream().allMatch(List::isEmpty) && this.damageXpValues().values().stream().allMatch(Map::isEmpty) && this.bonuses().values().stream().allMatch(Map::isEmpty) && this.nbtBonuses().values().stream().allMatch(List::isEmpty) && this.salvage().keySet().stream().allMatch(rl -> rl.equals((Object)new ResourceLocation("item"))) && this.veinData().isUnconfigured();
    }
}

