/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core.perks;

import harmonised.pmmo.api.perks.Perk;
import harmonised.pmmo.client.utils.DP;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.TagBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class PerksImpl {
    private static Set<ToolAction> DIG_ACTIONS = Set.of(ToolActions.PICKAXE_DIG, ToolActions.AXE_DIG, ToolActions.SHOVEL_DIG, ToolActions.HOE_DIG, ToolActions.SHEARS_DIG, ToolActions.SWORD_DIG);
    private static final CompoundTag NONE = new CompoundTag();
    public static Perk BREAK_SPEED = Perk.begin().addDefaults(PerksImpl.getDefaults()).setStart((player, nbt) -> {
        float speedBonus = PerksImpl.getRatioForTool(player.m_21205_(), nbt);
        if (speedBonus == 0.0f) {
            return NONE;
        }
        float existingSpeedModification = nbt.m_128457_("speed");
        float speedModification = Math.max(0.0f, (float)nbt.m_128451_("level") * speedBonus) + existingSpeedModification;
        return TagBuilder.start().withFloat("speed", speedModification).build();
    }).setDescription(LangProvider.PERK_BREAK_SPEED_DESC.asComponent()).setStatus((player, settings) -> {
        ArrayList lines = new ArrayList();
        int skillLevel = settings.m_128451_("level");
        DIG_ACTIONS.stream().filter(action -> settings.m_128457_(action.name()) > 0.0f).forEach(action -> lines.add(LangProvider.PERK_BREAK_SPEED_STATUS_1.asComponent(action.name(), Float.valueOf(settings.m_128457_(action.name()) * (float)skillLevel))));
        return lines;
    }).build();
    private static final UUID ATTRIBUTE_ID = UUID.fromString("b902b6aa-8393-4bdc-8f0d-b937268ef5af");
    private static final Map<Attribute, Double> ANIMAL_ATTRIBUTES = Map.of(Attributes.f_22288_, 0.005, Attributes.f_22276_, 1.0, Attributes.f_22279_, 0.01, Attributes.f_22284_, 0.01, Attributes.f_22281_, 0.01);
    public static final String ANIMAL_ID = "tamed";
    public static final Perk TAME_BOOST = Perk.begin().addDefaults(TagBuilder.start().withString("skill", "taming").withDouble("per_level", 1.0).build()).setStart((player, nbt) -> {
        if (player.m_9236_() instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)player.m_9236_();
            UUID animalID = nbt.m_128342_(ANIMAL_ID);
            LivingEntity animal = (LivingEntity)world.m_142646_().m_142694_(animalID);
            if (animal == null) {
                return NONE;
            }
            double perLevel = nbt.m_128459_("per_level");
            for (Map.Entry<Attribute, Double> atr : ANIMAL_ATTRIBUTES.entrySet()) {
                AttributeInstance instance = animal.m_21051_(atr.getKey());
                if (instance == null) continue;
                AttributeModifier modifier = new AttributeModifier(ATTRIBUTE_ID, "Taming boost", perLevel * atr.getValue() * (double)nbt.m_128451_("level"), AttributeModifier.Operation.ADDITION);
                instance.m_22125_(modifier);
            }
        }
        return NONE;
    }).setDescription(LangProvider.PERK_TAME_BOOST_DESC.asComponent()).setStatus((player, settings) -> {
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        double perLevel = settings.m_128459_("per_level");
        for (Map.Entry<Attribute, Double> atr : ANIMAL_ATTRIBUTES.entrySet()) {
            lines.add(LangProvider.PERK_TAME_BOOST_STATUS_1.asComponent(Component.m_237115_((String)atr.getKey().m_22087_()), DP.dpCustom(perLevel * atr.getValue(), 4)));
        }
        return lines;
    }).build();

    private static float getRatioForTool(ItemStack tool, CompoundTag nbt) {
        float ratio = 0.0f;
        for (ToolAction action : DIG_ACTIONS) {
            if (!tool.canPerformAction(action)) continue;
            ratio += nbt.m_128457_(action.name());
        }
        return ratio;
    }

    public static CompoundTag getDefaults() {
        TagBuilder builder = TagBuilder.start();
        for (ToolAction action : DIG_ACTIONS) {
            builder.withFloat(action.name(), 0.0f);
        }
        return builder.build();
    }
}

