/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.features.veinmining.VeinMiningLogic;
import harmonised.pmmo.storage.ChunkDataHandler;
import harmonised.pmmo.storage.ChunkDataProvider;
import harmonised.pmmo.storage.IChunkData;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class BreakHandler {
    public static void handle(BlockEvent.BreakEvent event) {
        boolean serverSide;
        Core core = Core.get(event.getPlayer().m_9236_());
        boolean bl = serverSide = !event.getPlayer().m_9236_().f_46443_;
        if (!core.isActionPermitted(ReqType.BREAK, event.getPos(), event.getPlayer())) {
            event.setCanceled(true);
            Messenger.sendDenialMsg(ReqType.BREAK, event.getPlayer(), event.getState().m_60734_().m_49954_());
            return;
        }
        CompoundTag eventHookOutput = new CompoundTag();
        if (serverSide && (eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.BLOCK_BREAK, (Event)event, new CompoundTag())).m_128471_("is_cancelled")) {
            event.setCanceled(true);
            return;
        }
        CompoundTag perkOutput = TagUtils.mergeTags(eventHookOutput, core.getPerkRegistry().executePerk(EventType.BLOCK_BREAK, event.getPlayer(), eventHookOutput));
        if (serverSide) {
            Map<String, Long> xpAward = BreakHandler.calculateXpAward(core, event, perkOutput);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)event.getPlayer());
            core.awardXP(partyMembersInRange, xpAward);
            LevelChunk chunk = (LevelChunk)event.getLevel().m_46865_(event.getPos());
            chunk.getCapability(ChunkDataProvider.CHUNK_CAP).ifPresent(cap -> {
                cap.delPos(event.getPos());
                if (event.getLevel().m_8055_(event.getPos()).m_204336_(Reference.CASCADING_BREAKABLES)) {
                    cap.setBreaker(event.getPos(), event.getPlayer().m_20148_());
                }
            });
            chunk.m_8092_(true);
        }
        if (core.getMarkedPos(event.getPlayer().m_20148_()).equals((Object)event.getPos())) {
            BlockState block = event.getLevel().m_8055_(event.getPos());
            Item tool = event.getPlayer().m_21205_().m_41720_();
            if (!(block.m_60834_() && !tool.m_8096_(block) || ((List)Config.VEIN_BLACKLIST.get()).contains(RegistryUtil.getId(tool).toString()))) {
                VeinMiningLogic.applyVein((ServerPlayer)event.getPlayer(), event.getPos());
            }
        }
    }

    private static Map<String, Long> calculateXpAward(Core core, BlockEvent.BreakEvent event, CompoundTag dataIn) {
        Map<String, Long> outMap = core.getExperienceAwards(EventType.BLOCK_BREAK, event.getPos(), (Level)event.getLevel(), event.getPlayer(), dataIn);
        LevelChunk chunk = (LevelChunk)event.getLevel().m_46865_(event.getPos());
        IChunkData cap = (IChunkData)chunk.getCapability(ChunkDataProvider.CHUNK_CAP).orElseGet(ChunkDataHandler::new);
        if (cap.playerMatchesPos(event.getPlayer(), event.getPos())) {
            BlockState cropState = event.getLevel().m_8055_(event.getPos());
            if (cropState.m_60734_() instanceof CropBlock && ((CropBlock)cropState.m_60734_()).m_52307_(cropState)) {
                return outMap;
            }
            double xpModifier = (Double)Config.REUSE_PENALTY.get();
            if (xpModifier == 0.0) {
                return new HashMap<String, Long>();
            }
            HashMap<String, Long> modifiedOutMap = new HashMap<String, Long>();
            outMap.forEach((k, v) -> modifiedOutMap.put((String)k, (long)((double)v.longValue() * xpModifier)));
            return modifiedOutMap;
        }
        return outMap;
    }
}

