/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Functions;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.Event;

public class DamageDealtHandler {
    public static void handle(LivingAttackEvent event) {
        if (event.getSource().m_7639_() == null) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            LivingEntity target = event.getEntity();
            if (target == null) {
                return;
            }
            Player player = (Player)event.getSource().m_7639_();
            if (target.equals((Object)player)) {
                return;
            }
            Core core = Core.get(player.m_9236_());
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.EVENT, "Attack Type: " + EventType.DEAL_DAMAGE.name() + " | TargetType: " + target.m_6095_().toString(), new Object[0]);
            if (!core.isActionPermitted(ReqType.WEAPON, player.m_21205_(), player)) {
                event.setCanceled(true);
                Messenger.sendDenialMsg(ReqType.WEAPON, player, player.m_21205_().m_41611_());
                return;
            }
            if (!core.isActionPermitted(ReqType.KILL, (Entity)target, player)) {
                event.setCanceled(true);
                Messenger.sendDenialMsg(ReqType.KILL, player, target.m_5446_());
                return;
            }
            boolean serverSide = !player.m_9236_().f_46443_;
            CompoundTag eventHookOutput = new CompoundTag();
            if (serverSide && (eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.DEAL_DAMAGE, (Event)event, new CompoundTag())).m_128471_("is_cancelled")) {
                event.setCanceled(true);
                return;
            }
        }
    }

    public static void handle(LivingDamageEvent event) {
        if (event.getSource().m_7639_() == null) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            LivingEntity target = event.getEntity();
            if (target == null) {
                return;
            }
            Player player = (Player)event.getSource().m_7639_();
            if (target.equals((Object)player)) {
                return;
            }
            Core core = Core.get(player.m_9236_());
            String damageType = RegistryUtil.getId(event.getSource()).toString();
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Source Type: " + damageType + " | Source Raw: " + event.getSource().m_19385_(), new Object[0]);
            CompoundTag dataIn = TagBuilder.start().withFloat("damageIn", event.getAmount()).withString("damage_type", RegistryUtil.getId(event.getSource()).toString()).build();
            CompoundTag perkOutput = core.getPerkRegistry().executePerk(EventType.DEAL_DAMAGE, player, dataIn);
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Pre-Perk Damage:" + event.getAmount(), new Object[0]);
            if (perkOutput.m_128441_("damage")) {
                float damageOut = perkOutput.m_128457_("damage");
                MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Damage Modified from %s to %s".formatted(Float.valueOf(event.getAmount()), Float.valueOf(damageOut)), new Object[0]);
                event.setAmount(damageOut);
            }
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Attack Type: " + damageType + " | Damage Out: " + event.getAmount(), new Object[0]);
            if (!player.m_9236_().f_46443_) {
                perkOutput.m_128359_("damage_type", damageType);
                Map<String, Long> xpAward = DamageDealtHandler.getExperienceAwards(core, target, event.getAmount(), event.getSource(), player, perkOutput);
                List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
                core.awardXP(partyMembersInRange, xpAward);
            }
        }
    }

    private static Map<String, Long> getExperienceAwards(Core core, LivingEntity target, float damage, DamageSource source, Player player, CompoundTag dataIn) {
        HashMap<String, Long> mapOut = new HashMap<String, Long>();
        float ultimateDamage = Math.min(damage, target.m_21223_());
        ItemStack weapon = player.m_21205_();
        Player srcEntity = source.m_7640_() != null ? source.m_7640_() : player;
        Functions.mergeMaps(core.getExperienceAwards(EventType.DEAL_DAMAGE, weapon, player, dataIn), core.getExperienceAwards(EventType.DEAL_DAMAGE, (Entity)srcEntity, player, dataIn), core.getExperienceAwards(EventType.DEAL_DAMAGE, (Entity)target, player, dataIn)).forEach((skill, xp) -> mapOut.put((String)skill, (long)(xp.floatValue() * ultimateDamage)));
        Map<String, Map<String, Long>> config = Config.DEAL_DAMAGE_XP.get();
        List<String> tags = config.keySet().stream().filter(str -> {
            if (!str.contains("#")) {
                return false;
            }
            Registry registry = player.m_9236_().m_9598_().m_175515_(Registries.f_268580_);
            Optional tag = registry.m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation(str.substring(1))));
            return tag.map(type -> type.m_203333_(source.m_269150_())).orElse(false);
        }).toList();
        Map tagXp = tags.stream().map(str -> (Map)config.get(str)).reduce((mapA, mapB) -> Functions.mergeMaps(mapA, mapB)).orElse(new HashMap());
        Functions.mergeMaps((Map)config.getOrDefault(RegistryUtil.getId(source).toString(), new HashMap()), tagXp).forEach((skill, xp) -> mapOut.putIfAbsent((String)skill, (long)(xp.floatValue() * ultimateDamage)));
        return mapOut;
    }
}

