/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.autovalues;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.features.autovalues.AutoBlock;
import harmonised.pmmo.features.autovalues.AutoEntity;
import harmonised.pmmo.features.autovalues.AutoItem;
import harmonised.pmmo.features.autovalues.AutoValueConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.resources.ResourceLocation;

public class AutoValues {
    private static ConcurrentMap<ReqType, Map<ResourceLocation, Map<String, Integer>>> reqValues = new ConcurrentHashMap<ReqType, Map<ResourceLocation, Map<String, Integer>>>();
    private static ConcurrentMap<EventType, Map<ResourceLocation, Map<String, Long>>> xpGainValues = new ConcurrentHashMap<EventType, Map<ResourceLocation, Map<String, Long>>>();

    private static Map<String, Integer> cacheRequirement(ReqType reqType, ResourceLocation objectID, Map<String, Integer> requirementMap) {
        reqValues.computeIfAbsent(reqType, s -> new HashMap()).put(objectID, requirementMap);
        return requirementMap;
    }

    private static Map<String, Long> cacheXpGainValue(EventType eventType, ResourceLocation objectID, Map<String, Long> xpGainMap) {
        xpGainValues.computeIfAbsent(eventType, s -> new HashMap()).put(objectID, xpGainMap);
        return xpGainMap;
    }

    public static void resetCache() {
        reqValues = new ConcurrentHashMap<ReqType, Map<ResourceLocation, Map<String, Integer>>>();
        xpGainValues = new ConcurrentHashMap<EventType, Map<ResourceLocation, Map<String, Long>>>();
    }

    public static Map<String, Integer> getRequirements(ReqType reqType, ResourceLocation objectID, ObjectType autoValueType) {
        if (!AutoValueConfig.isReqEnabled(reqType)) {
            reqValues.computeIfAbsent(reqType, s -> new HashMap()).remove(objectID);
            return new HashMap<String, Integer>();
        }
        HashMap<String, Integer> requirements = new HashMap<String, Integer>();
        if (reqValues.computeIfAbsent(reqType, s -> new HashMap()).containsKey(objectID) && !(requirements = new HashMap((Map)((Map)reqValues.get(reqType)).get(objectID))).isEmpty()) {
            return requirements;
        }
        requirements = switch (autoValueType) {
            case ObjectType.ITEM -> AutoItem.processReqs(reqType, objectID);
            case ObjectType.BLOCK -> AutoBlock.processReqs(reqType, objectID);
            case ObjectType.ENTITY -> AutoEntity.processReqs(reqType, objectID);
            default -> requirements;
        };
        HashMap<String, Integer> finalReqs = new HashMap<String, Integer>();
        requirements.forEach((skill, level) -> {
            if (level > 0) {
                finalReqs.put((String)skill, (Integer)level);
            }
        });
        return AutoValues.cacheRequirement(reqType, objectID, finalReqs);
    }

    public static Map<String, Long> getExperienceAward(EventType eventType, ResourceLocation objectID, ObjectType autoValueType) {
        if (!AutoValueConfig.isXpGainEnabled(eventType)) {
            xpGainValues.computeIfAbsent(eventType, s -> new HashMap()).remove(objectID);
            return new HashMap<String, Long>();
        }
        HashMap<String, Long> awards = new HashMap<String, Long>();
        if (xpGainValues.computeIfAbsent(eventType, s -> new HashMap()).containsKey(objectID) && !(awards = new HashMap((Map)((Map)xpGainValues.get(eventType)).get(objectID))).isEmpty()) {
            return awards;
        }
        awards = switch (autoValueType) {
            case ObjectType.ITEM -> AutoItem.processXpGains(eventType, objectID);
            case ObjectType.BLOCK -> AutoBlock.processXpGains(eventType, objectID);
            case ObjectType.ENTITY -> AutoEntity.processXpGains(eventType, objectID);
            default -> awards;
        };
        HashMap<String, Long> finalAwards = new HashMap<String, Long>();
        awards.forEach((skill, value) -> {
            if (value > 0L) {
                finalAwards.put((String)skill, (Long)value);
            }
        });
        return AutoValues.cacheXpGainValue(eventType, objectID, finalAwards);
    }
}

