/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.mobscaling;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.LocationData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="pmmo", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MobAttributeHandler {
    private static final UUID MODIFIER_ID = UUID.fromString("c95a6e8c-a1c3-4177-9118-1e2cf49b7fcb");
    private static final Map<ResourceLocation, Float> CAPS = Map.of(new ResourceLocation("generic.max_health"), Float.valueOf(1024.0f), new ResourceLocation("generic.movement_speed"), Float.valueOf(1.5f), new ResourceLocation("generic.attack_damage"), Float.valueOf(2048.0f), new ResourceLocation("zombie.spawn_reinforcements"), Float.valueOf(1.0f));

    @SubscribeEvent
    public static void onBossAdd(EntityJoinLevelEvent event) {
        Entity entity;
        if (!((Boolean)Config.MOB_SCALING_ENABLED.get()).booleanValue()) {
            return;
        }
        if (event.getEntity().m_6095_().m_204039_(Tags.EntityTypes.BOSSES) && (entity = event.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity = event.getLevel();
            if (entity instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)entity;
                MobAttributeHandler.handle(entity2, level, new Vec3(entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_()), level.m_46791_().m_19028_());
            }
        }
    }

    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (!((Boolean)Config.MOB_SCALING_ENABLED.get()).booleanValue()) {
            return;
        }
        if (event.getEntity().m_6095_().m_204039_(Reference.MOB_TAG)) {
            MobAttributeHandler.handle((LivingEntity)event.getEntity(), event.getLevel().m_6018_(), new Vec3(event.getX(), event.getY(), event.getZ()), event.getLevel().m_46791_().m_19028_());
        }
    }

    private static void handle(LivingEntity entity, ServerLevel level, Vec3 spawnPos, int diffScale) {
        int range = (Integer)Config.MOB_SCALING_AOE.get();
        TargetingConditions targetCondition = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26883_(Math.pow(range, 2.0) * 3.0);
        List nearbyPlayers = level.m_45955_(targetCondition, entity, AABB.m_165882_((Vec3)spawnPos, (double)range, (double)range, (double)range));
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "NearbyPlayers on Spawn: " + MsLoggy.listToString(nearbyPlayers), new Object[0]);
        Core core = Core.get((Level)level.m_6018_());
        LocationData dimData = core.getLoader().DIMENSION_LOADER.getData(level.m_6018_().m_46472_().m_135782_());
        LocationData bioData = core.getLoader().BIOME_LOADER.getData(RegistryUtil.getId((Holder<Biome>)level.m_204166_(entity.m_20097_())));
        Map dimMods = dimData.mobModifiers().getOrDefault(RegistryUtil.getId((Entity)entity), new HashMap());
        Map bioMods = bioData.mobModifiers().getOrDefault(RegistryUtil.getId((Entity)entity), new HashMap());
        Map<String, Map<String, Double>> multipliers = Config.MOB_SCALING.get();
        float bossMultiplier = entity.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) ? ((Double)Config.BOSS_SCALING_RATIO.get()).floatValue() : 1.0f;
        Set<ResourceLocation> attributeKeys = Stream.of(dimMods.keySet(), bioMods.keySet(), multipliers.keySet()).flatMap(Collection::stream).map(ResourceLocation::new).collect(Collectors.toSet());
        attributeKeys.forEach(attributeID -> {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeID);
            if (attribute == null) {
                return;
            }
            Map config = multipliers.getOrDefault(attributeID.toString(), new HashMap());
            AttributeInstance attributeInstance = entity.m_21051_(attribute);
            if (attributeInstance != null) {
                double base = MobAttributeHandler.baseValue(entity, attributeID, attributeInstance);
                float cap = CAPS.getOrDefault(attributeID, Float.valueOf(Float.MAX_VALUE)).floatValue();
                float bonus = MobAttributeHandler.getBonus(nearbyPlayers, config, diffScale, base, cap);
                bonus += dimMods.getOrDefault(attributeID.toString(), 0.0).floatValue();
                bonus += bioMods.getOrDefault(attributeID.toString(), 0.0).floatValue();
                AttributeModifier modifier = new AttributeModifier(MODIFIER_ID, "Boost to Mob Scaling", (double)(bonus *= bossMultiplier), AttributeModifier.Operation.ADDITION);
                attributeInstance.m_22120_(MODIFIER_ID);
                attributeInstance.m_22125_(modifier);
                MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Entity={} Attribute={} value={}", entity.m_5446_().getString(), attributeID.toString(), Float.valueOf(bonus));
            }
        });
        entity.m_21153_(entity.m_21233_());
    }

    private static double baseValue(LivingEntity entity, ResourceLocation id, AttributeInstance ai) {
        return switch (id.toString()) {
            case "minecraft:generic.attack_damage" -> 1.0;
            case "minecraft:generic.movement_speed" -> entity.m_6113_();
            default -> ai.m_22115_();
        };
    }

    private static float getBonus(List<Player> nearbyPlayers, Map<String, Double> config, int scale, double ogValue, float cap) {
        HashMap totalLevel = new HashMap();
        if (nearbyPlayers.isEmpty()) {
            return 0.0f;
        }
        nearbyPlayers.forEach(player -> config.keySet().stream().collect(Collectors.toMap(str -> str, str -> Core.get(player.m_9236_()).getData().getPlayerSkillLevel((String)str, player.m_20148_()))).forEach((skill, level) -> totalLevel.merge(skill, (Integer)level, Integer::sum)));
        float outValue = 0.0f;
        for (Map.Entry<String, Double> configEntry : config.entrySet()) {
            int averageLevel = totalLevel.getOrDefault(configEntry.getKey(), 0) / nearbyPlayers.size();
            if (averageLevel < (Integer)Config.MOB_SCALING_BASE_LEVEL.get()) continue;
            outValue = (float)((double)outValue + ((Boolean)Config.MOB_USE_EXPONENTIAL_FORMULA.get() != false ? Math.pow((Double)Config.MOB_EXPONENTIAL_POWER_BASE.get(), (Double)Config.MOB_EXPONENTIAL_LEVEL_MOD.get() * (double)(averageLevel - (Integer)Config.MOB_SCALING_BASE_LEVEL.get())) : (double)(averageLevel - (Integer)Config.MOB_SCALING_BASE_LEVEL.get()) * (Double)Config.MOB_LINEAR_PER_LEVEL.get()));
            outValue = (float)((double)outValue * configEntry.getValue());
        }
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Modifier Value: " + outValue * (float)scale, new Object[0]);
        return (double)outValue + ogValue > (double)cap ? cap : (outValue *= (float)scale);
    }
}

