/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network.clientpackets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.config.codecs.EnhancementsData;
import harmonised.pmmo.config.codecs.LocationData;
import harmonised.pmmo.config.codecs.ObjectData;
import harmonised.pmmo.config.codecs.PlayerData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.MsLoggy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public record CP_SyncData(ObjectType type, Map<ResourceLocation, ? extends DataSource<?>> data) {
    private static final Codec<DataSource<?>> CODEC = ExtraCodecs.m_184415_(() -> ObjectType.CODEC.dispatch("type", s -> {
        if (s instanceof ObjectData) {
            return ObjectType.ITEM;
        }
        if (s instanceof LocationData) {
            return ObjectType.BIOME;
        }
        if (s instanceof EnhancementsData) {
            return ObjectType.EFFECT;
        }
        return ObjectType.PLAYER;
    }, x -> switch (x) {
        case ObjectType.ITEM -> ObjectData.CODEC;
        case ObjectType.BIOME -> LocationData.CODEC;
        case ObjectType.EFFECT -> EnhancementsData.CODEC;
        default -> PlayerData.CODEC;
    }));
    private static final Codec<CP_SyncData> MAPPER = RecordCodecBuilder.create(instance -> instance.group((App)ObjectType.CODEC.fieldOf("type").forGetter(CP_SyncData::type), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, CODEC).fieldOf("data").forGetter(pkt -> pkt.data())).apply((Applicative)instance, CP_SyncData::new));

    public static CP_SyncData decode(FriendlyByteBuf buf) {
        return MAPPER.parse((DynamicOps)NbtOps.f_128958_, (Object)buf.m_130081_(NbtAccounter.f_128917_)).result().orElse(new CP_SyncData(ObjectType.ITEM, new HashMap()));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(MAPPER.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().orElse(new CompoundTag()));
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.NETWORK, "Payload for {}/{} is {}", this.getClass().getSimpleName(), this.type().name(), buf.readableBytes());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Map<ResourceLocation, ?> map = Core.get(LogicalSide.CLIENT).getLoader().getLoader(this.type()).getData();
            this.data().forEach((key, value) -> map.put((ResourceLocation)key, value));
        });
        ctx.get().setPacketHandled(true);
    }
}

