/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.registry;

import com.google.common.base.Preconditions;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.perks.Perk;
import harmonised.pmmo.config.PerksConfig;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public class PerkRegistry {
    private final Map<ResourceLocation, Perk> perks = new HashMap<ResourceLocation, Perk>();
    private final List<TickSchedule> tickTracker = new ArrayList<TickSchedule>();
    private final List<PerkCooldown> coolTracker = new ArrayList<PerkCooldown>();

    public void registerPerk(ResourceLocation perkID, Perk perk) {
        Preconditions.checkNotNull((Object)perkID);
        Preconditions.checkNotNull((Object)perk);
        this.perks.put(perkID, perk);
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.API, "Registered Perk: " + perkID.toString(), new Object[0]);
    }

    public void registerClientClone(ResourceLocation perkID, Perk perk) {
        Preconditions.checkNotNull((Object)perkID);
        Preconditions.checkNotNull((Object)perk);
        Perk clientCopy = new Perk(perk.conditions(), perk.propertyDefaults(), (a, b) -> new CompoundTag(), (TriFunction<Player, CompoundTag, Integer, CompoundTag>)((TriFunction)(a, b, c) -> new CompoundTag()), (a, b) -> new CompoundTag(), perk.description(), perk.status());
        this.perks.putIfAbsent(perkID, clientCopy);
    }

    public MutableComponent getDescription(ResourceLocation id) {
        return this.perks.getOrDefault(id, Perk.empty()).description();
    }

    public List<MutableComponent> getStatusLines(ResourceLocation id, Player player, CompoundTag settings) {
        return this.perks.getOrDefault(id, Perk.empty()).status().apply(player, settings);
    }

    public CompoundTag executePerk(EventType cause, Player player, @NotNull CompoundTag dataIn) {
        if (player == null) {
            return new CompoundTag();
        }
        CompoundTag output = new CompoundTag();
        ((List)PerksConfig.PERK_SETTINGS.get().getOrDefault(cause, new ArrayList())).forEach(src -> {
            CompoundTag fullSrc;
            ResourceLocation perkID = new ResourceLocation(src.m_128461_("perk"));
            Perk perk = this.perks.getOrDefault(perkID, Perk.empty());
            fullSrc.m_128405_("level", (fullSrc = perk.propertyDefaults().m_6426_().m_128391_(src.m_6426_().m_128391_(dataIn.m_6426_().m_128391_(output.m_6426_())))).m_128441_("skill") ? Core.get(player.m_9236_()).getData().getPlayerSkillLevel(fullSrc.m_128461_("skill"), player.m_20148_()) : 0);
            if (perk.canActivate(player, fullSrc)) {
                MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Perk Executed: %s".formatted(perkID.toString()), new Object[0]);
                CompoundTag executionOutput = perk.start(player, fullSrc);
                this.tickTracker.add(new TickSchedule(perk, player, fullSrc.m_6426_(), new AtomicInteger(0)));
                if (fullSrc.m_128441_("cooldown") && this.isPerkCooledDown(player, fullSrc)) {
                    this.coolTracker.add(new PerkCooldown(perkID, player, fullSrc, player.m_9236_().m_46467_()));
                }
                output.m_128391_(executionOutput);
            }
        });
        return output;
    }

    public void executePerkTicks(TickEvent.LevelTickEvent event) {
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.PERKS, "Perk Tick Tracker:" + MsLoggy.listToString(this.tickTracker), new Object[0]);
        this.coolTracker.removeIf(tracker -> tracker.cooledDown(event.level));
        new ArrayList<TickSchedule>(this.tickTracker).forEach(schedule -> {
            if (schedule.perk().canActivate(schedule.player(), schedule.src())) {
                if (schedule.shouldTick()) {
                    schedule.tick();
                } else {
                    schedule.perk().stop(schedule.player(), schedule.src());
                    this.tickTracker.remove(schedule);
                }
            } else {
                this.tickTracker.remove(schedule);
            }
        });
    }

    public boolean isPerkCooledDown(Player player, CompoundTag src) {
        ResourceLocation perkID = new ResourceLocation(src.m_128461_("perk"));
        return this.coolTracker.stream().noneMatch(cd -> cd.player().equals((Object)player) && cd.perkID().equals((Object)perkID));
    }

    private record PerkCooldown(ResourceLocation perkID, Player player, CompoundTag src, long lastUse) {
        public boolean cooledDown(Level level) {
            return level.m_46467_() > this.lastUse + (long)this.src.m_128451_("cooldown");
        }
    }

    private record TickSchedule(Perk perk, Player player, CompoundTag src, AtomicInteger ticksElapsed) {
        public boolean shouldTick() {
            return this.src.m_128441_("duration") && this.ticksElapsed.get() <= this.src.m_128451_("duration");
        }

        public void tick() {
            this.ticksElapsed().getAndIncrement();
            this.perk.tick(this.player, this.src, this.ticksElapsed.get());
        }
    }
}

