/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.blocks;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.events.ModEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockBoundary
extends Block {
    public static final BooleanProperty Powered = BooleanProperty.m_61465_((String)"powered");
    public final CreativeModeTab itemGroup = CreativeModeTab.f_40749_;

    public BlockBoundary() {
        super(BlockBehaviour.Properties.m_60939_((Material)Prefab.SeeThroughImmovable).m_60918_(SoundType.f_56742_).m_60978_(0.6f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)Powered, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean canRenderInLayer(RenderType layer) {
        boolean powered = false;
        return layer == RenderType.m_110466_() && !powered || layer == RenderType.m_110451_() && powered;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{Powered});
    }

    public RenderShape m_7514_(BlockState state) {
        boolean powered = (Boolean)state.m_61143_((Property)Powered);
        return powered ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        boolean powered = (Boolean)state.m_61143_((Property)Powered);
        return powered ? Shapes.m_83144_() : Shapes.m_83040_();
    }

    public boolean removedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean returnValue = super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        ModEventHandler.RedstoneAffectedBlockPositions.remove(pos);
        boolean poweredSide = world.m_46753_(pos);
        if (poweredSide) {
            this.setNeighborGlassBlocksPoweredStatus(world, pos, false, 0, new ArrayList<BlockPos>(), false);
        }
        return returnValue;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean poweredSide = context.m_43725_().m_46753_(context.m_8083_());
        if (poweredSide) {
            this.setNeighborGlassBlocksPoweredStatus(context.m_43725_(), context.m_8083_(), true, 0, new ArrayList<BlockPos>(), false);
        }
        return (BlockState)this.m_49966_().m_61124_((Property)Powered, (Comparable)Boolean.valueOf(poweredSide));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_, boolean p_220069_6_) {
        if (!worldIn.f_46443_ && blockIn.m_49966_().m_60803_()) {
            boolean poweredSide = worldIn.m_46753_(pos);
            this.setNeighborGlassBlocksPoweredStatus(worldIn, pos, poweredSide, 0, new ArrayList<BlockPos>(), true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag advanced) {
        super.m_5871_(stack, worldIn, tooltip, advanced);
        boolean advancedKeyDown = Screen.m_96638_();
        if (!advancedKeyDown) {
            tooltip.add((Component)GuiLangKeys.translateToComponent("prefab.gui.tooltip.shift"));
        } else {
            tooltip.add((Component)GuiLangKeys.translateToComponent("prefab.gui.tooltip.boundary_block"));
        }
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        boolean powered = (Boolean)state.m_61143_((Property)Powered);
        if (powered && state.m_60804_(worldIn, pos)) {
            return worldIn.m_7469_();
        }
        return state.m_60631_(worldIn, pos) ? 0 : 1;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        boolean powered = (Boolean)state.m_61143_((Property)Powered);
        return !powered || !Block.m_49916_((VoxelShape)state.m_60808_(reader, pos)) && state.m_60819_().m_76178_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    @Deprecated
    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        if (!((Boolean)state.m_61143_((Property)Powered)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return Shapes.m_83144_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return (Boolean)state.m_61143_((Property)Powered) == false;
    }

    protected void setNeighborGlassBlocksPoweredStatus(Level world, BlockPos pos, boolean isPowered, int cascadeCount, ArrayList<BlockPos> cascadedBlockPos, boolean setCurrentBlock) {
        if (++cascadeCount > 100) {
            return;
        }
        if (setCurrentBlock) {
            BlockState state = world.m_8055_(pos);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)Powered, (Comparable)Boolean.valueOf(isPowered)), 3);
        }
        cascadedBlockPos.add(pos);
        for (Direction facing : Direction.values()) {
            Block neighborBlock = world.m_8055_(pos.m_142300_(facing)).m_60734_();
            if (!(neighborBlock instanceof BlockBoundary) || cascadedBlockPos.contains(pos.m_142300_(facing))) continue;
            ((BlockBoundary)neighborBlock).setNeighborGlassBlocksPoweredStatus(world, pos.m_142300_(facing), isPowered, cascadeCount, cascadedBlockPos, true);
        }
    }
}

