/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.config;

import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class EntityPlayerConfiguration {
    public static final String PLAYER_ENTITY_TAG = "IsPlayerNew";
    private static final String GIVEN_HOUSEBUILDER_TAG = "givenHousebuilder";
    private static final String Built_Starter_house_Tag = "builtStarterHouse";
    private final HashMap<String, StructureConfiguration> clientConfigurations = new HashMap();
    public boolean givenHouseBuilder = false;
    public boolean builtStarterHouse = false;

    public static EntityPlayerConfiguration loadFromEntityData(Player player) {
        EntityPlayerConfiguration config = new EntityPlayerConfiguration();
        CompoundTag compoundTag = config.getModIsPlayerNewTag(player);
        config.loadFromNBTTagCompound(compoundTag);
        return config;
    }

    public void loadFromNBTTagCompound(CompoundTag tag) {
        this.givenHouseBuilder = tag.m_128471_(GIVEN_HOUSEBUILDER_TAG);
        this.builtStarterHouse = tag.m_128471_(Built_Starter_house_Tag);
    }

    public CompoundTag getModIsPlayerNewTag(Player player) {
        CompoundTag newPlayerTag;
        CompoundTag tag = player.getPersistentData();
        if (tag.m_128441_(PLAYER_ENTITY_TAG)) {
            newPlayerTag = tag.m_128469_(PLAYER_ENTITY_TAG);
        } else {
            newPlayerTag = new CompoundTag();
            tag.m_128365_(PLAYER_ENTITY_TAG, (Tag)newPlayerTag);
        }
        return newPlayerTag;
    }

    public void saveToPlayer(Player player) {
        CompoundTag compoundTag = this.getModIsPlayerNewTag(player);
        compoundTag.m_128379_(Built_Starter_house_Tag, this.builtStarterHouse);
        compoundTag.m_128379_(GIVEN_HOUSEBUILDER_TAG, this.givenHouseBuilder);
    }

    public <T extends StructureConfiguration> T getClientConfig(String guiName, Class<T> structureConfiguration) {
        StructureConfiguration config = this.clientConfigurations.get(guiName);
        if (config == null) {
            try {
                config = (StructureConfiguration)structureConfiguration.newInstance();
                this.clientConfigurations.put(guiName, config);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return (T)config;
    }

    public void clearNonPersistedObjects() {
        this.clientConfigurations.clear();
    }
}

