/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.config.ConfigCategory;
import com.wuest.prefab.config.ConfigOption;
import com.wuest.prefab.config.ServerModConfiguration;
import com.wuest.prefab.proxy.CommonProxy;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraftforge.common.ForgeConfigSpec;

public class ModConfiguration {
    private static final String OPTIONS = "general.";
    private static final String ChestContentOptions = "general.chest contents.";
    private static final String RecipeOptions = "general.recipes.";
    private static final String starterHouseOptions = "general.starter house.";
    private static final ArrayList<String> validStartingItems = new ArrayList<String>(Arrays.asList("Starting House", "Moderate House", "Nothing"));
    private static final String compressedStoneKey = "Compressed Stone";
    private static final String compressedGlowStoneKey = "Compressed Glowstone";
    private static final String compressedDirteKey = "Compressed Dirt";
    private static final String compressedChestKey = "Compressed Chest";
    private static final String pileOfBricksKey = "Pile of Bricks";
    private static final String warehouseKey = "Warehouse";
    private static final String warehouseUpgradeKey = "Warehouse Upgrade";
    private static final String advancedWarehouseKey = "Advanced Warehouse";
    private static final String bundleofTimberKey = "Bundle of Timber";
    private static final String netherGateKey = "Nether Gate";
    private static final String machineryTowerKey = "Machinery Tower";
    private static final String defenseBunkerKey = "Defense Bunker";
    private static final String mineshaftEntranceKey = "Mineshaft Entrance";
    private static final String enderGatewayKey = "Ender Gateway";
    private static final String aquaBaseKey = "Aqua Base";
    private static final String grassyPlainsKey = "Grassy Plains";
    private static final String magicTempleKey = "Magic Temple";
    private static final String instantBridgeKey = "Instant Bridge";
    private static final String paperLanternKey = "Paper Lantern";
    private static final String compressedObsidianKey = "Compressed Obsidian";
    private static final String villagerHousesKey = "Villager Houses";
    private static final String phasicBlockKey = "Phasic Block";
    private static final String smartGlassKey = "Smart Glass";
    private static final String greenHouseKey = "Green House";
    private static final String startingHouseKey = "Starting House";
    private static final String glassStairsKey = "Glass Stairs";
    private static final String glassSlabsKey = "Glass Slabs";
    private static final String moderateHouseKey = "Moderate House";
    private static final String watchTowerKey = "Watch Tower";
    private static final String bulldozerKey = "Bulldozer";
    private static final String jailKey = "Jail";
    private static final String saloonKey = "Saloon";
    private static final String skiLodgeKey = "Ski Lodge";
    private static final String windMillKey = "Windmill";
    private static final String townHallKey = "Town Hall";
    private static final String heapOfTimberKey = "Heap of Timber";
    private static final String tonOfTimberKey = "Ton of Timber";
    private static final String workshopKey = "Workshop";
    private static final String modernBuildingsKey = "Modern Buildings";
    public static String SwiftBladeKey = "Swift Blade";
    public static String SickleKey = "Sickle";
    public static String DirtRecipesKey = "Dirt Recipes";
    public static String BunchOfBeetsKey = "Bunch of Beets";
    public static String BunchOfCarrotsKey = "Bunch of Carrots";
    public static String BunchOfPotatoesKey = "Bunch of Potatoes";
    public static String BunchOfEggsKey = "Bunch of Eggs";
    public static String WoodenCrateKey = "Wooden Crate";
    public static String starterFarmKey = "Starter Farm";
    public static String moderateFarmKey = "Moderate Farm";
    public static String advancedFarmKey = "Advanced Farm";
    public static String tagKey = "PrefabConfig";
    static String enableVersionCheckMessageName = "Enable Version Checking";
    static String enableLoftHouseName = "Enable Loft House";
    static String includeSpawnersInMasherName = "Include Spawners in Monster Masher";
    static String enableStructurePreviewName = "Include Structure Previews";
    static String includeMineshaftChestName = "Include Mineshaft Chest";
    static String allowWaterInNonOverworldDimensionsName = "Include Water In Non-Overworld Dimesions";
    static String enableAutomationOptionsFromModerateFarmName = "Enable Automation Options For Moderate Farm";
    static String addSwordName = "Add Sword";
    static String addAxeName = "Add Axe";
    static String addHoeName = "Add Hoe";
    static String addShovelName = "Add Shovel";
    static String addPickAxeName = "Add Pickaxe";
    static String addArmorName = "Add Armor";
    static String addFoodName = "Add Food";
    static String addCropsName = "Add Crops";
    static String addDirtName = "Add Dirt";
    static String addCobbleName = "Add Cobblestone";
    static String addSaplingsName = "Add Saplings";
    static String addTorchesName = "Add Torches";
    static String startingItemName = "Starting Item";
    static String addBedName = "Add Bed";
    static String addCraftingTableName = "Add Crafting Table";
    static String addFurnaceName = "Add Furnace";
    static String addChestsName = "Add Chests";
    static String addChestContentsName = "Add Chest Contents";
    static String addMineshaftName = "Add Mineshaft";
    static String allowBulldozerToCreateDropsName = "Bulldozer Creates Drops";
    static String[] recipeKeys = new String[]{"Compressed Stone", "Compressed Glowstone", "Compressed Dirt", "Compressed Chest", "Pile of Bricks", "Warehouse", "Warehouse Upgrade", "Advanced Warehouse", "Bundle of Timber", "Nether Gate", "Machinery Tower", "Defense Bunker", "Mineshaft Entrance", "Ender Gateway", "Magic Temple", "Instant Bridge", "Paper Lantern", "Compressed Obsidian", "Villager Houses", "Phasic Block", "Smart Glass", "Green House", "Starting House", "Glass Stairs", "Glass Slabs", "Moderate House", "Grassy Plains", "Aqua Base", "Watch Tower", "Bulldozer", "Jail", "Saloon", "Ski Lodge", "Windmill", "Town Hall", "Heap of Timber", "Ton of Timber", "Workshop", "Modern Buildings", SwiftBladeKey, SickleKey, DirtRecipesKey, BunchOfBeetsKey, BunchOfCarrotsKey, BunchOfPotatoesKey, BunchOfEggsKey, WoodenCrateKey, starterFarmKey, moderateFarmKey, advancedFarmKey};
    private static ForgeConfigSpec SPEC;
    private final HashMap<String, ForgeConfigSpec.BooleanValue> recipeConfiguration = new HashMap();
    public ServerModConfiguration serverConfiguration = new ServerModConfiguration();
    public ArrayList<ConfigOption<?>> configOptions = new ArrayList();
    private ForgeConfigSpec.BooleanValue enableLoftHouse;
    private ForgeConfigSpec.BooleanValue includeSpawnersInMasher;
    private ForgeConfigSpec.BooleanValue enableStructurePreview;
    private ForgeConfigSpec.BooleanValue allowBulldozerToCreateDrops;
    private ForgeConfigSpec.BooleanValue allowWaterInNonOverworldDimensions;
    private ForgeConfigSpec.BooleanValue enableAutomationOptionsFromModerateFarm;
    private ForgeConfigSpec.BooleanValue includeMineshaftChest;
    private ForgeConfigSpec.BooleanValue addSword;
    private ForgeConfigSpec.BooleanValue addAxe;
    private ForgeConfigSpec.BooleanValue addHoe;
    private ForgeConfigSpec.BooleanValue addShovel;
    private ForgeConfigSpec.BooleanValue addPickAxe;
    private ForgeConfigSpec.BooleanValue addArmor;
    private ForgeConfigSpec.BooleanValue addFood;
    private ForgeConfigSpec.BooleanValue addCrops;
    private ForgeConfigSpec.BooleanValue addDirt;
    private ForgeConfigSpec.BooleanValue addCobble;
    private ForgeConfigSpec.BooleanValue addSaplings;
    private ForgeConfigSpec.BooleanValue addTorches;
    private ForgeConfigSpec.BooleanValue addBed;
    private ForgeConfigSpec.BooleanValue addCraftingTable;
    private ForgeConfigSpec.BooleanValue addFurnace;
    private ForgeConfigSpec.BooleanValue addChests;
    private ForgeConfigSpec.BooleanValue addChestContents;
    private ForgeConfigSpec.BooleanValue addMineshaft;
    private ForgeConfigSpec.ConfigValue<String> startingItem;

    public ModConfiguration(ForgeConfigSpec.Builder builder) {
        ModConfiguration.buildOptions(this, builder);
    }

    private static void buildOptions(ModConfiguration config, ForgeConfigSpec.Builder builder) {
        CommonProxy.proxyConfiguration = config;
        builder.comment("General");
        CommonProxy.proxyConfiguration.startingItem = builder.comment("Determines which starting item a player gets on first world join. Valid values for this option are: \"Starting House\", \"Moderate House\", \"Nothing\". Server configuration overrides client.").defineInList(OPTIONS + startingItemName, (Object)startingHouseKey, validStartingItems);
        config.configOptions.add(new ConfigOption().setConfigValue(CommonProxy.proxyConfiguration.startingItem).setName(startingItemName).setCategory(ConfigCategory.General).setConfigType("String").setDefaultValue(startingHouseKey).setHoverText("Determines which starting item a player gets on first world join. Valid values for this option are: \"Starting House\", \"Moderate House\", \"Nothing\". Server configuration overrides client.").setValidValues(validStartingItems));
        CommonProxy.proxyConfiguration.enableLoftHouse = builder.comment("Determines if the loft starter house is enabled. This house contains Nether materials in it's construction. Server configuration overrides client.").define(OPTIONS + enableLoftHouseName, false);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.enableLoftHouse).setName(enableLoftHouseName).setConfigType("Boolean").setCategory(ConfigCategory.General).setHoverText("Determines if the loft starter house is enabled. This house contains Nether materials in it's construction. Server configuration overrides client.").setDefaultValue(false));
        CommonProxy.proxyConfiguration.includeSpawnersInMasher = builder.comment("Determines if the spawners for the Monster Masher building are included. Server configuration overrides client.").define(OPTIONS + includeSpawnersInMasherName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.includeSpawnersInMasher).setName(includeSpawnersInMasherName).setConfigType("Boolean").setCategory(ConfigCategory.General).setHoverText("Determines if the spawners for the Monster Masher building are included. Server configuration overrides client.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.enableStructurePreview = builder.comment("Determines if the Preview buttons in structure GUIs and other structure previews functions are enabled. Client side only.").define(OPTIONS + enableStructurePreviewName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.enableStructurePreview).setName(enableStructurePreviewName).setConfigType("Boolean").setCategory(ConfigCategory.General).setHoverText("Determines if the Preview buttons in structure GUIs and other structure previews functions are enabled. Client side only.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.includeMineshaftChest = builder.comment("Determines if the mineshaft chest is included when building mineshafts for various structures.").define(OPTIONS + includeMineshaftChestName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.includeMineshaftChest).setName(includeMineshaftChestName).setConfigType("Boolean").setCategory(ConfigCategory.General).setHoverText("Determines if the mineshaft chest is included when building mineshafts for various structures.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.allowBulldozerToCreateDrops = builder.comment("Determines if the bulldozer item can create drops when it clears an area.").define(OPTIONS + allowBulldozerToCreateDropsName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.allowBulldozerToCreateDrops).setName(allowBulldozerToCreateDropsName).setConfigType("Boolean").setCategory(ConfigCategory.General).setHoverText("Determines if the bulldozer item can create drops when it clears an area.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.allowWaterInNonOverworldDimensions = builder.comment("Determines if water can be generated in structures when the current dimension is not the oveworld. Does not affect Nether").define(OPTIONS + allowWaterInNonOverworldDimensionsName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.allowWaterInNonOverworldDimensions).setName(allowWaterInNonOverworldDimensionsName).setConfigType("Boolean").setCategory(ConfigCategory.General).setHoverText("Determines if water can be generated in structures when the current dimension is not the oveworld. Does not affect Nether").setDefaultValue(true));
        CommonProxy.proxyConfiguration.enableAutomationOptionsFromModerateFarm = builder.comment("Enable Automation Options For Moderate Farm").define(OPTIONS + enableAutomationOptionsFromModerateFarmName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.enableAutomationOptionsFromModerateFarm).setName(enableAutomationOptionsFromModerateFarmName).setConfigType("Boolean").setCategory(ConfigCategory.General).setHoverText("Enable Automation Options For Moderate Farm").setDefaultValue(true));
        builder.comment("Chest Options");
        CommonProxy.proxyConfiguration.addSword = builder.comment("Determines if a Stone Sword is added the the chest when the house is created.").define(ChestContentOptions + addSwordName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addSword).setName(addSwordName).setConfigType("Boolean").setCategory(ConfigCategory.ChestOptions).setHoverText("Determines if a Stone Sword is added the the chest when the house is created.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addAxe = builder.comment("Determines if a Stone Axe is added the the chest when the house is created.").define(ChestContentOptions + addAxeName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addAxe).setName(addAxeName).setConfigType("Boolean").setCategory(ConfigCategory.ChestOptions).setHoverText("Determines if a Stone Axe is added the the chest when the house is created.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addShovel = builder.comment("Determines if a Stone Shovel is added the the chest when the house is created.").define(ChestContentOptions + addShovelName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addShovel).setName(addShovelName).setConfigType("Boolean").setCategory(ConfigCategory.ChestOptions).setHoverText("Determines if a Stone Shovel is added the the chest when the house is created.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addHoe = builder.comment("Determines if a Stone Hoe is added the the chest when the house is created.").define(ChestContentOptions + addHoeName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addHoe).setName(addHoeName).setConfigType("Boolean").setCategory(ConfigCategory.ChestOptions).setHoverText("Determines if a Stone Hoe is added the the chest when the house is created.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addPickAxe = builder.comment("Determines if a Stone Pickaxe is added the the chest when the house is created.").define(ChestContentOptions + addPickAxeName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addPickAxe).setName(addPickAxeName).setConfigType("Boolean").setCategory(ConfigCategory.ChestOptions).setHoverText("Determines if a Stone Pickaxe is added the the chest when the house is created.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addArmor = builder.comment("Determines if Leather Armor is added the the chest when the house is created.").define(ChestContentOptions + addArmorName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addArmor).setName(addArmorName).setConfigType("Boolean").setCategory(ConfigCategory.ChestOptions).setHoverText("Determines if Leather Armor is added the the chest when the house is created.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addFood = builder.comment("Determines if Bread is added the the chest when the house is created.").define(ChestContentOptions + addFoodName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addFood).setName(addFoodName).setConfigType("Boolean").setCategory(ConfigCategory.ChestOptions).setHoverText("Determines if Bread is added the the chest when the house is created.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addCrops = builder.comment("Determines if seeds, potatoes and carrots are added the the chest when the house is created.").define(ChestContentOptions + addCropsName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addCrops).setName(addCropsName).setConfigType("Boolean").setCategory(ConfigCategory.ChestOptions).setHoverText("Determines if seeds, potatoes and carrots are added the the chest when the house is created.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addDirt = builder.comment("Determines if a stack of dirt is added the the chest when the house is created.").define(ChestContentOptions + addDirtName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addDirt).setName(addDirtName).setConfigType("Boolean").setCategory(ConfigCategory.ChestOptions).setHoverText("Determines if a stack of dirt is added the the chest when the house is created.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addCobble = builder.comment("Determines if a stack of cobble is added the the chest when the house is created.").define(ChestContentOptions + addCobbleName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addCobble).setName(addCobbleName).setConfigType("Boolean").setCategory(ConfigCategory.ChestOptions).setHoverText("Determines if a stack of cobble is added the the chest when the house is created.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addSaplings = builder.comment("Determines if a set of oak saplings are added the the chest when the house is created.").define(ChestContentOptions + addSaplingsName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addSaplings).setName(addSaplingsName).setConfigType("Boolean").setCategory(ConfigCategory.ChestOptions).setHoverText("Determines if a set of oak saplings are added the the chest when the house is created.").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addTorches = builder.comment("Determines if a set of torches are added the the chest when the house is created.").define(ChestContentOptions + addTorchesName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addTorches).setName(addTorchesName).setConfigType("Boolean").setCategory(ConfigCategory.ChestOptions).setHoverText("Determines if a set of torches are added the the chest when the house is created.").setDefaultValue(true));
        builder.comment("Starter House Options");
        CommonProxy.proxyConfiguration.addBed = builder.comment("Determines if the bed is included in the starter house. When playing on a server, the server configuration is used").define(starterHouseOptions + addBedName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addBed).setName(addBedName).setConfigType("Boolean").setCategory(ConfigCategory.HouseOptions).setHoverText("Determines if the bed is included in the starter house. When playing on a server, the server configuration is used").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addCraftingTable = builder.comment("Determines if the crafting table is included in the starter house. When playing on a server, the server configuration is used").define(starterHouseOptions + addCraftingTableName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addCraftingTable).setName(addCraftingTableName).setConfigType("Boolean").setCategory(ConfigCategory.HouseOptions).setHoverText("Determines if the crafting table is included in the starter house. When playing on a server, the server configuration is used").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addFurnace = builder.comment("Determines if the furnace is included in the starter house. When playing on a server, the server configuration is used").define(starterHouseOptions + addFurnaceName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addFurnace).setName(addFurnaceName).setConfigType("Boolean").setCategory(ConfigCategory.HouseOptions).setHoverText("Determines if the furnace is included in the starter house. When playing on a server, the server configuration is used").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addChests = builder.comment("Determines if chests are included in the starter house. When playing on a server, the server configuration is used").define(starterHouseOptions + addChestsName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addChests).setName(addChestsName).setConfigType("Boolean").setCategory(ConfigCategory.HouseOptions).setHoverText("Determines if chests are included in the starter house. When playing on a server, the server configuration is used").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addChestContents = builder.comment("Determines if the chest contents is included in the starter house. When playing on a server, the server configuration is used").define(starterHouseOptions + addChestContentsName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addChestContents).setName(addChestContentsName).setConfigType("Boolean").setCategory(ConfigCategory.HouseOptions).setHoverText("Determines if the chest contents is included in the starter house. When playing on a server, the server configuration is used").setDefaultValue(true));
        CommonProxy.proxyConfiguration.addMineshaft = builder.comment("Determines if the mineshaft is included in the starter house. When playing on a server, the server configuration is used").define(starterHouseOptions + addMineshaftName, true);
        config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)CommonProxy.proxyConfiguration.addMineshaft).setName(addMineshaftName).setConfigType("Boolean").setCategory(ConfigCategory.HouseOptions).setHoverText("Determines if the mineshaft is included in the starter house. When playing on a server, the server configuration is used").setDefaultValue(true));
        for (String key : recipeKeys) {
            ForgeConfigSpec.BooleanValue value = builder.comment("Determines if the recipe(s) associated with the " + key + " are enabled.").define(RecipeOptions + key, true);
            config.configOptions.add(new ConfigOption().setConfigValue((ForgeConfigSpec.ConfigValue<?>)value).setName(key).setCategory(ConfigCategory.RecipeOptions).setConfigType("Boolean").setHoverText("Determines if the recipe(s) associated with the " + key + " are enabled.").setDefaultValue(true));
            CommonProxy.proxyConfiguration.recipeConfiguration.put(key, value);
        }
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        Prefab.LOGGER.debug("Loading config file {}", (Object)path);
        SPEC = spec;
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        Prefab.LOGGER.info("Built TOML config for {}", (Object)path.toString());
        configData.load();
        Prefab.LOGGER.info("Loaded TOML config file {}", (Object)path.toString());
        spec.setConfig((CommentedConfig)configData);
        ModConfiguration.UpdateServerConfig();
    }

    public static void UpdateServerConfig() {
        CommonProxy.proxyConfiguration.serverConfiguration.startingItem = (String)CommonProxy.proxyConfiguration.startingItem.get();
        CommonProxy.proxyConfiguration.serverConfiguration.enableLoftHouse = (Boolean)CommonProxy.proxyConfiguration.enableLoftHouse.get();
        CommonProxy.proxyConfiguration.serverConfiguration.includeSpawnersInMasher = (Boolean)CommonProxy.proxyConfiguration.includeSpawnersInMasher.get();
        CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview = (Boolean)CommonProxy.proxyConfiguration.enableStructurePreview.get();
        CommonProxy.proxyConfiguration.serverConfiguration.includeMineshaftChest = (Boolean)CommonProxy.proxyConfiguration.includeMineshaftChest.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addSword = (Boolean)CommonProxy.proxyConfiguration.addSword.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addAxe = (Boolean)CommonProxy.proxyConfiguration.addAxe.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addShovel = (Boolean)CommonProxy.proxyConfiguration.addShovel.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addHoe = (Boolean)CommonProxy.proxyConfiguration.addHoe.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addPickAxe = (Boolean)CommonProxy.proxyConfiguration.addPickAxe.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addArmor = (Boolean)CommonProxy.proxyConfiguration.addArmor.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addFood = (Boolean)CommonProxy.proxyConfiguration.addFood.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addCrops = (Boolean)CommonProxy.proxyConfiguration.addCrops.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addDirt = (Boolean)CommonProxy.proxyConfiguration.addDirt.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addCobble = (Boolean)CommonProxy.proxyConfiguration.addCobble.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addSaplings = (Boolean)CommonProxy.proxyConfiguration.addSaplings.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addTorches = (Boolean)CommonProxy.proxyConfiguration.addTorches.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addBed = (Boolean)CommonProxy.proxyConfiguration.addBed.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addCraftingTable = (Boolean)CommonProxy.proxyConfiguration.addCraftingTable.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addFurnace = (Boolean)CommonProxy.proxyConfiguration.addFurnace.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addChests = (Boolean)CommonProxy.proxyConfiguration.addChests.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addChestContents = (Boolean)CommonProxy.proxyConfiguration.addChestContents.get();
        CommonProxy.proxyConfiguration.serverConfiguration.addMineshaft = (Boolean)CommonProxy.proxyConfiguration.addMineshaft.get();
        CommonProxy.proxyConfiguration.serverConfiguration.allowBulldozerToCreateDrops = (Boolean)CommonProxy.proxyConfiguration.allowBulldozerToCreateDrops.get();
        CommonProxy.proxyConfiguration.serverConfiguration.allowWaterInNonOverworldDimensions = (Boolean)CommonProxy.proxyConfiguration.allowWaterInNonOverworldDimensions.get();
        CommonProxy.proxyConfiguration.serverConfiguration.enableAutomationOptionsFromModerateFarm = (Boolean)CommonProxy.proxyConfiguration.enableAutomationOptionsFromModerateFarm.get();
        for (String key : recipeKeys) {
            Prefab.LOGGER.debug("Setting recipe configuration for key: " + key);
            CommonProxy.proxyConfiguration.serverConfiguration.recipeConfiguration.put(key, (Boolean)CommonProxy.proxyConfiguration.recipeConfiguration.get(key).get());
        }
    }
}

