/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.events;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.proxy.ClientProxy;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.items.ItemBasicStructure;
import com.wuest.prefab.structures.items.StructureItem;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.render.StructureRenderHandler;
import java.util.ArrayList;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="prefab", value={Dist.CLIENT})
public final class ClientEventHandler {
    public static ClientEventHandler instance = new ClientEventHandler();
    public static int ticksInGame;
    public static EntityPlayerConfiguration playerConfig;
    public static ArrayList<KeyMapping> keyBindings;

    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && !mc.f_91074_.m_6047_()) {
            StructureRenderHandler.renderPlayerLook((Player)mc.f_91074_, mc.f_91077_, event.getMatrixStack());
        }
    }

    @SubscribeEvent
    public static void EntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_ && event.getEntity() instanceof Player) {
            ((ClientProxy)Prefab.proxy).serverConfiguration = null;
            playerConfig.clearNonPersistedObjects();
        }
    }

    @SubscribeEvent
    public static void ClientTickEnd(TickEvent.ClientTickEvent event) {
        Screen gui;
        if (!(event.phase != TickEvent.Phase.END || (gui = Minecraft.m_91087_().f_91080_) != null && gui.m_7043_())) {
            if (2147483547 == ticksInGame) {
                ticksInGame = 1;
            }
            ++ticksInGame;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    @OnlyIn(value=Dist.CLIENT)
    public static void KeyInput(InputEvent.KeyInputEvent event) {
        for (KeyMapping binding : keyBindings) {
            if (!binding.m_90857_()) continue;
            if (StructureRenderHandler.currentStructure == null) break;
            ItemStack mainHandStack = Minecraft.m_91087_().f_91074_.m_21205_();
            ItemStack offHandStack = Minecraft.m_91087_().f_91074_.m_21206_();
            boolean foundCorrectStructureItem = false;
            if (mainHandStack != ItemStack.f_41583_ || offHandStack != ItemStack.f_41583_) {
                StructureTagMessage.EnumStructureConfiguration structureConfigurationEnum = StructureTagMessage.EnumStructureConfiguration.getByConfigurationInstance(StructureRenderHandler.currentConfiguration);
                if (mainHandStack != ItemStack.f_41583_ && mainHandStack.m_41720_() instanceof StructureItem) {
                    foundCorrectStructureItem = ClientEventHandler.checkIfStackIsCorrectGui(structureConfigurationEnum, mainHandStack);
                }
                if (!foundCorrectStructureItem && offHandStack != ItemStack.f_41583_ && offHandStack.m_41720_() instanceof StructureItem) {
                    foundCorrectStructureItem = ClientEventHandler.checkIfStackIsCorrectGui(structureConfigurationEnum, offHandStack);
                }
            }
            if (foundCorrectStructureItem) {
                Prefab.network.sendToServer((Object)new StructureTagMessage(StructureRenderHandler.currentConfiguration.WriteToCompoundTag(), StructureTagMessage.EnumStructureConfiguration.getByConfigurationInstance(StructureRenderHandler.currentConfiguration)));
            }
            StructureRenderHandler.currentStructure = null;
            break;
        }
    }

    public static boolean checkIfStackIsCorrectGui(StructureTagMessage.EnumStructureConfiguration currentConfiguration, ItemStack stack) {
        GuiStructure mainHandGui = ClientProxy.ModGuis.get(stack.m_41720_());
        mainHandGui.m_7856_();
        if (currentConfiguration == mainHandGui.structureConfiguration) {
            if (currentConfiguration == StructureTagMessage.EnumStructureConfiguration.Basic) {
                ItemBasicStructure item = (ItemBasicStructure)stack.m_41720_();
                BasicStructureConfiguration.EnumBasicStructureName basicStructureName = ((BasicStructureConfiguration)StructureRenderHandler.currentConfiguration).basicStructureName;
                return item.structureType == basicStructureName;
            }
            return true;
        }
        return false;
    }

    static {
        playerConfig = new EntityPlayerConfiguration();
        keyBindings = new ArrayList();
    }
}

