/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.CustomButton;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.gui.controls.GuiCheckBox;
import com.wuest.prefab.gui.controls.GuiSlider;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.DyeColor;

public abstract class GuiBase
extends Screen {
    private final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/default_background.png");
    private final ResourceLocation narrowPanelTexture = new ResourceLocation("prefab", "textures/gui/custom_background.png");
    private final ResourceLocation leftPanelTexture = new ResourceLocation("prefab", "textures/gui/custom_left_panel.png");
    private final ResourceLocation middlePanelTexture = new ResourceLocation("prefab", "textures/gui/custom_middle_panel.png");
    private final ResourceLocation rightPanelTexture = new ResourceLocation("prefab", "textures/gui/custom_right_panel.png");
    protected int modifiedInitialXAxis = 213;
    protected int modifiedInitialYAxis = 83;
    protected int imagePanelWidth = 0;
    protected int imagePanelHeight = 0;
    protected int shownImageHeight = 0;
    protected int shownImageWidth = 0;
    private boolean pauseGame = true;
    protected int textColor = Color.DARK_GRAY.getRGB();

    public GuiBase(String title) {
        super((Component)Utils.createTextComponent(title));
    }

    public void m_7856_() {
        this.Initialize();
    }

    protected void Initialize() {
        this.modifiedInitialXAxis = 160;
        this.modifiedInitialYAxis = 120;
        this.imagePanelWidth = 325;
        this.imagePanelHeight = 300;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
    }

    protected int getCenteredXAxis() {
        return this.f_96543_ / 2;
    }

    protected int getCenteredYAxis() {
        return this.f_96544_ / 2;
    }

    public boolean m_7043_() {
        return this.pauseGame;
    }

    public void m_6305_(PoseStack matrixStack, int x, int y, float f) {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        this.preButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        this.renderButtons(matrixStack, x, y);
        this.postButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text) {
        return this.createAndAddButton(x, y, width, height, text, true);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text, boolean translate) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, translate ? GuiLangKeys.translateToComponent(text) : Utils.createTextComponent(text), this::buttonClicked);
        this.m_142416_((GuiEventListener)returnValue);
        return returnValue;
    }

    public CustomButton createAndAddCustomButton(int x, int y, int width, int height, String text) {
        return this.createAndAddCustomButton(x, y, width, height, text, true);
    }

    public CustomButton createAndAddCustomButton(int x, int y, int width, int height, String text, boolean translate) {
        CustomButton returnValue = new CustomButton(x, y, width, height, translate ? GuiLangKeys.translateToComponent(text) : Utils.createTextComponent(text), this::buttonClicked);
        return (CustomButton)this.m_142416_((GuiEventListener)returnValue);
    }

    public ExtendedButton createAndAddDyeButton(int x, int y, int width, int height, DyeColor color) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, Utils.createTextComponent(GuiLangKeys.translateDye(color)), this::buttonClicked);
        this.m_142416_((GuiEventListener)returnValue);
        return returnValue;
    }

    public ExtendedButton createAndAddFullDyeButton(int x, int y, int width, int height, FullDyeColor color) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, Utils.createTextComponent(GuiLangKeys.translateFullDye(color)), this::buttonClicked);
        this.m_142416_((GuiEventListener)returnValue);
        return returnValue;
    }

    public GuiCheckBox createAndAddCheckBox(int xPos, int yPos, String displayString, boolean isChecked, GuiCheckBox.IPressable handler) {
        GuiCheckBox checkBox = new GuiCheckBox(xPos, yPos, GuiLangKeys.translateString(displayString), isChecked, handler);
        this.m_142416_((GuiEventListener)checkBox);
        return checkBox;
    }

    public GuiSlider createAndAddSlider(int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, Button.OnPress handler) {
        GuiSlider slider = new GuiSlider(xPos, yPos, width, height, Utils.createTextComponent(prefix), Utils.createTextComponent(suf), minVal, maxVal, currentVal, showDec, drawStr, handler);
        this.m_142416_((GuiEventListener)slider);
        return slider;
    }

    protected void drawControlBackground(PoseStack matrixStack, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.bindAndDrawScaledTexture(this.backgroundTextures, matrixStack, grayBoxX, grayBoxY, width, height, width, height, width, height);
    }

    protected void drawControlLeftPanel(PoseStack matrixStack, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.leftPanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawControlMiddlePanel(PoseStack matrixStack, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.middlePanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawControlRightPanel(PoseStack matrixStack, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.rightPanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawStandardControlBoxAndImage(PoseStack matrixStack, ResourceLocation imageLocation, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        this.drawControlBackground(matrixStack, x, y, this.imagePanelWidth, this.imagePanelHeight);
        if (imageLocation != null) {
            int imagePanelMiddle = this.imagePanelWidth / 2;
            int middleOfImage = this.shownImageWidth / 2;
            int imagePos = x + (imagePanelMiddle - middleOfImage - 5);
            GuiUtils.bindAndDrawTexture(imageLocation, matrixStack, imagePos, y + 10, 1, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight);
        }
    }

    protected void renderButtons(PoseStack matrixStack, int mouseX, int mouseY) {
        for (GuiEventListener widget : this.m_6702_()) {
            GuiEventListener guiEventListener = widget;
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget currentButton = (AbstractWidget)guiEventListener;
            if (!currentButton.f_93624_) continue;
            currentButton.m_6303_(matrixStack, mouseX, mouseY, this.getMinecraft().m_91296_());
        }
    }

    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - this.modifiedInitialXAxis, this.getCenteredYAxis() - this.modifiedInitialYAxis);
    }

    public int drawString(PoseStack matrixStack, String text, float x, float y, int color) {
        return this.getFontRenderer().m_92883_(matrixStack, text, x, y, color);
    }

    public void drawSplitString(String str, int x, int y, int wrapWidth, int textColor) {
        this.getFontRenderer().m_92857_((FormattedText)Utils.createTextComponent(str), x, y, wrapWidth, textColor);
    }

    public List<FormattedCharSequence> getSplitString(String str, int wrapWidth) {
        return this.getFontRenderer().m_92923_((FormattedText)Utils.createTextComponent(str), wrapWidth);
    }

    public List<FormattedCharSequence> getSplitString(FormattedText str, int wrapWidth) {
        return this.getFontRenderer().m_92923_(str, wrapWidth);
    }

    public void closeScreen() {
        this.getMinecraft().m_91152_(null);
    }

    public Minecraft getMinecraft() {
        return this.f_96541_;
    }

    public Font getFontRenderer() {
        return this.getMinecraft().f_91062_;
    }

    public abstract void buttonClicked(AbstractButton var1);

    protected abstract void preButtonRender(PoseStack var1, int var2, int var3, int var4, int var5, float var6);

    protected abstract void postButtonRender(PoseStack var1, int var2, int var3, int var4, int var5, float var6);
}

