/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wuest.prefab.Quadruple;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.config.ConfigCategory;
import com.wuest.prefab.config.ConfigOption;
import com.wuest.prefab.config.ModConfiguration;
import com.wuest.prefab.gui.GuiBase;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.TooltipAccessor;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class GuiPrefab
extends GuiBase {
    private static final int TITLE_HEIGHT = 8;
    private static final int OPTIONS_LIST_TOP_HEIGHT = 55;
    private static final int OPTIONS_LIST_BOTTOM_OFFSET = 32;
    private static final int OPTIONS_LIST_ITEM_HEIGHT = 25;
    private static final int DONE_BUTTON_TOP_OFFSET = 26;
    private final Screen parentScreen;
    private ExtendedButton doneButton;
    private ExtendedButton resetToDefaultsButton;
    private ExtendedButton generalGroupButton;
    private ConfigCategory currentOption = ConfigCategory.General;
    private OptionsList currentRowList;
    private ArrayList<Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory>> optionCollection;
    private OptionsList optionsRowList;
    private OptionsList chestOptionsRowList;
    private OptionsList recipeOptionsRowList;
    private OptionsList starterHouseOptionsRowList;

    public GuiPrefab(Minecraft minecraft, Screen parent) {
        super("Prefab Configuration");
        this.parentScreen = parent;
        this.f_96541_ = minecraft;
    }

    @Nullable
    public static List<FormattedCharSequence> tooltipAt(OptionsList optionsRowList, int mouseX, int mouseY) {
        Optional optional;
        if (optionsRowList.m_5953_((double)mouseX, (double)mouseY) && (optional = optionsRowList.m_94480_((double)mouseX, (double)mouseY)).isPresent() && optional.get() instanceof TooltipAccessor) {
            return ((TooltipAccessor)optional.get()).m_141932_();
        }
        return null;
    }

    @Override
    protected void Initialize() {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int x = adjustedXYValue.getFirst();
        this.optionCollection = new ArrayList();
        this.resetToDefaultsButton = this.createAndAddButton(60, this.f_96544_ - 26, 100, 20, "Reset", false);
        this.doneButton = this.createAndAddButton(this.f_96543_ - 160, this.f_96544_ - 26, 100, 20, "Done", false);
        this.generalGroupButton = this.createAndAddButton(this.f_96543_ / 2, 30, 120, 20, "General", false);
        for (ConfigCategory category : ConfigCategory.values()) {
            OptionsList nextOptions = new OptionsList(this.getMinecraft(), this.f_96543_, this.f_96544_, 55, this.f_96544_ - 32, 25);
            OptionsList currentOptions = null;
            int currentLocation = category.ordinal();
            if (currentLocation == 0) {
                currentOptions = new OptionsList(this.getMinecraft(), this.f_96543_, this.f_96544_, 55, this.f_96544_ - 32, 25);
            } else {
                int currentOptionsIndex = currentLocation - 1;
                if (currentLocation == ConfigCategory.values().length - 1) {
                    nextOptions = this.optionCollection.get(0).getSecond();
                }
                currentOptions = this.optionCollection.get(currentOptionsIndex).getThird();
            }
            ConfigCategory nextCategory = ConfigCategory.getNextCategory(category);
            this.optionCollection.add(new Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory>(category, currentOptions, nextOptions, nextCategory));
        }
        for (ConfigOption configOption : CommonProxy.proxyConfiguration.configOptions) {
            Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory> rowList = this.getOptionsRowList(configOption.getCategory());
            if (rowList == null) continue;
            switch (configOption.getConfigType()) {
                case "Boolean": {
                    this.addBooleanOption(rowList.getSecond(), configOption);
                    break;
                }
                case "String": {
                    this.addStringOption(rowList.getSecond(), configOption);
                    break;
                }
                case "Integer": {
                    this.addIntegerOption(rowList.getSecond(), configOption);
                }
            }
        }
        this.m_7787_((GuiEventListener)this.optionCollection.get(0).getSecond());
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        if (button == this.doneButton) {
            ModConfiguration.UpdateServerConfig();
            this.getMinecraft().m_91152_(this.parentScreen);
        } else if (button == this.generalGroupButton) {
            Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory> option = this.getOptionsRowList(this.currentOption);
            if (option != null) {
                this.m_169411_((GuiEventListener)option.getSecond());
                this.m_7787_((GuiEventListener)option.getThird());
                GuiUtils.setButtonText(this.generalGroupButton, option.getFourth().getName());
                this.currentOption = option.getFourth();
            }
        } else if (button == this.resetToDefaultsButton) {
            for (ConfigOption<?> configOption : CommonProxy.proxyConfiguration.configOptions) {
                configOption.resetToDefault();
            }
            this.m_169413_();
            this.currentOption = ConfigCategory.General;
            this.Initialize();
        }
    }

    @Override
    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(0, 0);
    }

    @Override
    protected void preButtonRender(PoseStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(0);
        Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory> rowList = this.getOptionsRowList(this.currentOption);
        if (rowList != null) {
            rowList.getSecond().m_6305_(matrixStack, x, y, partialTicks);
            List<FormattedCharSequence> list = GuiPrefab.tooltipAt(rowList.getSecond(), mouseX, mouseY);
            if (list != null) {
                int mousePosition = mouseY > this.f_96544_ / 2 ? mouseY - 25 : mouseY + 25;
                this.m_96617_(matrixStack, list, mouseX, mousePosition);
            }
        }
        GuiComponent.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
        GuiComponent.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Category", (int)(this.f_96543_ / 2 - 50), (int)35, (int)0xFFFFFF);
    }

    @Override
    protected void postButtonRender(PoseStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
    }

    private void addBooleanOption(OptionsList rowList, ConfigOption<?> configOption) {
        CycleOption abstractOption = CycleOption.m_167743_((String)configOption.getName(), unused -> (Boolean)configOption.getConfigValueAsBoolean().get(), (unused, originalOption, newValue) -> configOption.getConfigValueAsBoolean().set(newValue));
        if (!configOption.getHoverText().isEmpty()) {
            abstractOption.m_167773_(minecraft -> supplierValue -> this.getSplitString((FormattedText)configOption.getHoverTextComponent(), 250));
        }
        rowList.m_94471_((Option)abstractOption);
    }

    private void addIntegerOption(OptionsList rowList, ConfigOption<?> configOption) {
        ProgressOption abstractOption = new ProgressOption(configOption.getName(), (double)configOption.getMinRange(), (double)configOption.getMaxRange(), 1.0f, unused -> (double)((Integer)configOption.getConfigValueAsInt().get()), (unused, newValue) -> configOption.getConfigValueAsInt().set((Object)newValue.intValue()), (gs, option) -> Utils.createTextComponent(configOption.getName() + ": " + (int)option.m_92221_(gs)), minecraft1 -> {
            if (configOption.getHoverText().isEmpty()) {
                return null;
            }
            return this.getSplitString((FormattedText)configOption.getHoverTextComponent(), 250);
        });
        rowList.m_94471_((Option)abstractOption);
    }

    private void addStringOption(OptionsList rowList, ConfigOption<?> configOption) {
        CycleOption abstractOption = CycleOption.m_167764_((String)configOption.getName(), (Object[])configOption.getValidValues().toArray(), selectedOption -> Utils.createTextComponent(configOption.getName() + ": " + (String)configOption.getConfigValueAsString().get()), gameOption -> Utils.createTextComponent(configOption.getName() + ": " + (String)configOption.getConfigValueAsString().get()), (unused, otherUnused, newValue) -> {
            int nextIndex = configOption.getValidValues().indexOf(configOption.getConfigValueAsString().get()) + 1;
            if (nextIndex >= configOption.getValidValues().size()) {
                nextIndex = 0;
            }
            configOption.getConfigValueAsString().set((Object)configOption.getValidValues().get(nextIndex));
        });
        if (!configOption.getHoverText().isEmpty()) {
            abstractOption.m_167773_(minecraft -> supplierValue -> this.getSplitString((FormattedText)configOption.getHoverTextComponent(), 250));
        }
        rowList.m_94471_((Option)abstractOption);
    }

    private Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory> getOptionsRowList(ConfigCategory listName) {
        for (Quadruple<ConfigCategory, OptionsList, OptionsList, ConfigCategory> option : this.optionCollection) {
            if (option.getFirst() != listName) continue;
            return option;
        }
        return null;
    }
}

