/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui.controls;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wuest.prefab.Utils;
import com.wuest.prefab.gui.GuiUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiCheckBox
extends AbstractButton {
    private static final ResourceLocation buttonTexture = new ResourceLocation("prefab", "textures/gui/prefab_checkbox.png");
    private static final ResourceLocation buttonTexturePressed = new ResourceLocation("prefab", "textures/gui/prefab_checkbox_selected.png");
    private static final ResourceLocation buttonTextureHover = new ResourceLocation("prefab", "textures/gui/prefab_checkbox_hover.png");
    protected int boxWidth = 11;
    protected int boxHeight;
    protected int stringColor;
    protected boolean withShadow;
    protected Minecraft mineCraft = Minecraft.m_91087_();
    protected String displayString;
    protected IPressable handler;
    protected int labelWidth;
    protected boolean isChecked;

    public GuiCheckBox(int xPos, int yPos, String displayString, boolean isChecked, IPressable handler) {
        super(xPos, yPos, 11, 12, (Component)Utils.createTextComponent(displayString));
        this.displayString = displayString;
        this.stringColor = Color.DARK_GRAY.getRGB();
        this.handler = handler;
        this.withShadow = false;
        this.labelWidth = 98;
        this.isChecked = isChecked;
    }

    public int getStringColor() {
        return this.stringColor;
    }

    public GuiCheckBox setStringColor(int color) {
        this.stringColor = color;
        return this;
    }

    public void m_5691_() {
        boolean bl = this.isChecked = !this.isChecked;
        if (this.handler != null) {
            this.handler.onPress(this);
        }
    }

    public boolean getWithShadow() {
        return this.withShadow;
    }

    public GuiCheckBox setWithShadow(boolean value) {
        this.withShadow = value;
        return this;
    }

    public GuiCheckBox setLabelWidth(int value) {
        this.labelWidth = value;
        return this;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setIsChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partial) {
        if (this.f_93624_) {
            ResourceLocation resourceLocation = buttonTexture;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean bl = this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.boxWidth && mouseY < this.f_93621_ + this.f_93619_;
            if (this.isChecked()) {
                resourceLocation = buttonTexturePressed;
            } else if (this.f_93622_) {
                resourceLocation = buttonTextureHover;
            }
            GuiUtils.bindTexture(resourceLocation);
            GuiUtils.drawTexture(matrixStack, this.f_93620_, this.f_93621_, 1, 11, 11, 11, 11);
            int color = this.stringColor;
            if (this.withShadow) {
                GuiCheckBox.m_93236_((PoseStack)matrixStack, (Font)this.mineCraft.f_91062_, (String)this.displayString, (int)(this.f_93620_ + this.boxWidth + 2), (int)(this.f_93621_ + 2), (int)color);
            } else {
                this.mineCraft.f_91062_.m_92857_((FormattedText)Utils.createTextComponent(this.displayString), this.f_93620_ + this.boxWidth + 2, this.f_93621_ + 2, this.labelWidth, color);
            }
        }
    }

    public void m_142291_(NarrationElementOutput builder) {
        builder.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            if (this.m_93696_()) {
                builder.m_169146_(NarratedElementType.USAGE, (Component)new TranslatableComponent("narration.checkbox.usage.focused"));
            } else {
                builder.m_169146_(NarratedElementType.USAGE, (Component)new TranslatableComponent("narration.checkbox.usage.hovered"));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onPress(GuiCheckBox var1);
    }
}

