/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.base;

import com.wuest.prefab.gui.GuiLangKeys;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public enum EnumStructureMaterial {
    Cobblestone("prefab.gui.material.cobble_stone", Blocks.f_50652_.m_49966_(), Blocks.f_50635_.m_49966_(), 0),
    Stone("prefab.gui.material.stone", Blocks.f_50069_.m_49966_(), Blocks.f_50635_.m_49966_(), 1),
    StoneBrick("prefab.gui.material.stone_brick", Blocks.f_50222_.m_49966_(), Blocks.f_50194_.m_49966_(), 2),
    Brick("prefab.gui.material.brick", Blocks.f_50076_.m_49966_(), Blocks.f_50193_.m_49966_(), 3),
    ChiseledStone("prefab.gui.material.chiseled_stone", Blocks.f_50225_.m_49966_(), Blocks.f_50194_.m_49966_(), 4),
    Granite("prefab.gui.material.granite", Blocks.f_50122_.m_49966_(), Blocks.f_50638_.m_49966_(), 5),
    SmoothGranite("prefab.gui.material.smooth_granite", Blocks.f_50175_.m_49966_(), Blocks.f_50629_.m_49966_(), 6),
    Andesite("prefab.gui.material.andesite", Blocks.f_50334_.m_49966_(), Blocks.f_50639_.m_49966_(), 7),
    SmoothAndesite("prefab.gui.material.smooth_andesite", Blocks.f_50387_.m_49966_(), Blocks.f_50641_.m_49966_(), 8),
    Diorite("prefab.gui.material.diorite", Blocks.f_50228_.m_49966_(), Blocks.f_50642_.m_49966_(), 9),
    SmoothDiorite("prefab.gui.material.smooth_diorite", Blocks.f_50281_.m_49966_(), Blocks.f_50632_.m_49966_(), 10),
    Oak("prefab.wall.block.type.oak", Blocks.f_50705_.m_49966_(), Blocks.f_50086_.m_49966_(), 11),
    Spruce("prefab.wall.block.type.spruce", Blocks.f_50741_.m_49966_(), Blocks.f_50269_.m_49966_(), 12),
    Birch("prefab.wall.block.type.birch", Blocks.f_50742_.m_49966_(), Blocks.f_50270_.m_49966_(), 13),
    Jungle("prefab.wall.block.type.jungle", Blocks.f_50743_.m_49966_(), Blocks.f_50271_.m_49966_(), 14),
    Acacia("prefab.wall.block.type.acacia", Blocks.f_50744_.m_49966_(), Blocks.f_50372_.m_49966_(), 15),
    DarkOak("prefab.wall.block.type.darkoak", Blocks.f_50745_.m_49966_(), Blocks.f_50373_.m_49966_(), 16),
    SandStone("prefab.ceiling.block.type.sand", Blocks.f_50062_.m_49966_(), Blocks.f_50263_.m_49966_(), 17),
    RedSandStone("prefab.gui.material.red_sandstone", Blocks.f_50394_.m_49966_(), Blocks.f_50397_.m_49966_(), 18);

    private String name;
    private BlockState blockType;
    private int number;
    private BlockState stairsState;

    private EnumStructureMaterial(String name, BlockState blockType, BlockState stairsState, int number) {
        this.name = name;
        this.blockType = blockType;
        this.number = number;
        this.stairsState = stairsState;
    }

    public static EnumStructureMaterial getMaterialByNumber(int number) {
        for (EnumStructureMaterial material : EnumStructureMaterial.values()) {
            if (material.getNumber() != number) continue;
            return material;
        }
        return Cobblestone;
    }

    public String getName() {
        return this.name;
    }

    public BlockState getBlockType() {
        return this.blockType;
    }

    public int getNumber() {
        return this.number;
    }

    public String getTranslatedName() {
        return GuiLangKeys.translateString(this.name);
    }

    public BlockState getStairsBlock() {
        return this.stairsState;
    }
}

