/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Triple;
import com.wuest.prefab.ZipUtil;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.BuildEntity;
import com.wuest.prefab.structures.base.BuildProperty;
import com.wuest.prefab.structures.base.BuildTileEntity;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.PositionOffset;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.events.StructureEventHandler;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.DeadBushBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Structure {
    public ArrayList<BlockPos> allBlockPositions = new ArrayList();
    public ArrayList<BlockPos> clearedBlockPos = new ArrayList();
    public ArrayList<BuildBlock> priorityOneBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityTwoBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityThreeBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityFourBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityFiveBlocks = new ArrayList();
    public ArrayList<BuildBlock> airBlocks = new ArrayList();
    public StructureConfiguration configuration;
    public ServerLevel world;
    public BlockPos originalPos;
    public Direction assumedNorth;
    public boolean hasAirBlocks = false;
    public boolean entitiesRemoved = false;
    @Expose
    public ArrayList<BuildTileEntity> tileEntities = new ArrayList();
    @Expose
    public ArrayList<BuildEntity> entities = new ArrayList();
    @Expose
    private String name;
    @Expose
    private BuildClear clearSpace;
    @Expose
    private ArrayList<BuildBlock> blocks;

    public Structure() {
        this.Initialize();
    }

    public static <T extends Structure> T CreateInstance(String resourceLocation, Class<? extends Structure> child) {
        Structure structure = null;
        Gson file = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        structure = (Structure)file.fromJson(ZipUtil.decompressResource(resourceLocation), child);
        return (T)structure;
    }

    public static void CreateStructureFile(Structure structure, String fileLocation) {
        try {
            Gson converter = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            StringWriter stringWriter = new StringWriter();
            converter.toJson((Object)structure, (Appendable)stringWriter);
            ZipUtil.zipStringToFile(stringWriter.toString(), fileLocation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ScanStructure(Level world, BlockPos originalPos, BlockPos cornerPos1, BlockPos cornerPos2, String fileLocation, BuildClear clearedSpace, Direction playerFacing, boolean includeAir, boolean excludeWater) {
        Structure scannedStructure = new Structure();
        scannedStructure.setClearSpace(clearedSpace);
        for (BlockPos currentPos : BlockPos.m_121940_((BlockPos)cornerPos1, (BlockPos)cornerPos2)) {
            if (world.m_46859_(currentPos) && !includeAir) continue;
            BlockState currentState = world.m_8055_(currentPos);
            Block currentBlock = currentState.m_60734_();
            if (currentState.m_60767_() == Material.f_76305_ && excludeWater) continue;
            BuildBlock buildBlock = Structure.createBuildBlockFromBlockState(currentState, currentBlock, currentPos, originalPos);
            if (currentBlock instanceof DoorBlock) {
                DoubleBlockHalf blockHalf = (DoubleBlockHalf)currentState.m_61143_((Property)DoorBlock.f_52730_);
                if (blockHalf != DoubleBlockHalf.LOWER) continue;
                BlockState upperHalfState = world.m_8055_(currentPos.m_7494_());
                if (upperHalfState.m_60734_() instanceof DoorBlock) {
                    Block upperBlock = upperHalfState.m_60734_();
                    BuildBlock upperHalf = Structure.createBuildBlockFromBlockState(upperHalfState, upperBlock, currentPos.m_7494_(), originalPos);
                    buildBlock.setSubBlock(upperHalf);
                }
            } else if (currentBlock instanceof BedBlock) {
                BedPart bedPart = (BedPart)currentState.m_61143_((Property)BedBlock.f_49440_);
                if (bedPart != BedPart.HEAD) continue;
                BlockState bedFoot = null;
                boolean foundFoot = false;
                Direction facing = Direction.NORTH;
                while (!foundFoot) {
                    bedFoot = world.m_8055_(currentPos.m_142300_(facing));
                    if (bedFoot.m_60734_() instanceof BedBlock && bedFoot.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT) {
                        foundFoot = true;
                        break;
                    }
                    if ((facing = facing.m_122427_()) != Direction.NORTH) continue;
                }
                if (foundFoot) {
                    Block footBedBlock = bedFoot.m_60734_();
                    BuildBlock bed = Structure.createBuildBlockFromBlockState(bedFoot, footBedBlock, currentPos.m_142300_(facing), originalPos);
                    buildBlock.setSubBlock(bed);
                }
            }
            scannedStructure.getBlocks().add(buildBlock);
            BlockEntity tileEntity = world.m_7702_(currentPos);
            if (tileEntity == null || tileEntity instanceof ChestBlockEntity && ((ChestBlockEntity)tileEntity).m_7983_() || tileEntity instanceof FurnaceBlockEntity && ((FurnaceBlockEntity)tileEntity).m_7983_()) continue;
            ResourceLocation resourceLocation = ForgeRegistries.BLOCK_ENTITIES.getKey((IForgeRegistryEntry)tileEntity.m_58903_());
            CompoundTag tagCompound = new CompoundTag();
            tileEntity.m_6945_(tagCompound);
            BuildTileEntity buildTileEntity = new BuildTileEntity();
            assert (resourceLocation != null);
            buildTileEntity.setEntityDomain(resourceLocation.m_135827_());
            buildTileEntity.setEntityName(resourceLocation.m_135815_());
            buildTileEntity.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(currentPos, originalPos));
            buildTileEntity.setEntityNBTData(tagCompound);
            scannedStructure.tileEntities.add(buildTileEntity);
        }
        int x_radiusRangeBegin = Math.min(cornerPos1.m_123341_(), cornerPos2.m_123341_());
        int x_radiusRangeEnd = Math.max(cornerPos1.m_123341_(), cornerPos2.m_123341_());
        int y_radiusRangeBegin = Math.min(cornerPos1.m_123342_(), cornerPos2.m_123342_());
        int y_radiusRangeEnd = Math.max(cornerPos1.m_123342_(), cornerPos2.m_123342_());
        int z_radiusRangeBegin = Math.min(cornerPos1.m_123343_(), cornerPos2.m_123343_());
        int z_radiusRangeEnd = Math.max(cornerPos1.m_123343_(), cornerPos2.m_123343_());
        AABB axis = new AABB(cornerPos1, cornerPos2);
        for (Entity entity : world.m_45933_(null, axis)) {
            BlockPos entityPos = entity.m_142538_();
            if (entity instanceof HangingEntity) {
                entityPos = ((HangingEntity)entity).m_31748_();
            }
            if (entityPos.m_123341_() < x_radiusRangeBegin || entityPos.m_123341_() > x_radiusRangeEnd || entityPos.m_123343_() < z_radiusRangeBegin || entityPos.m_123343_() > z_radiusRangeEnd || entityPos.m_123342_() < y_radiusRangeBegin || entityPos.m_123342_() > y_radiusRangeEnd) continue;
            BuildEntity buildEntity = new BuildEntity();
            buildEntity.setEntityResourceString(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entity.m_6095_()));
            buildEntity.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(entityPos, originalPos));
            buildEntity.entityXAxisOffset = (double)entityPos.m_123341_() - entity.m_20185_();
            buildEntity.entityYAxisOffset = (double)entityPos.m_123342_() - entity.m_20186_();
            buildEntity.entityZAxisOffset = (double)entityPos.m_123343_() - entity.m_20189_();
            if (entity instanceof ItemFrame) {
                buildEntity.entityYAxisOffset *= -1.0;
            }
            if (entity instanceof HangingEntity) {
                buildEntity.entityFacing = entity.m_6350_();
            }
            CompoundTag entityTagCompound = new CompoundTag();
            entity.m_20086_(entityTagCompound);
            buildEntity.setEntityNBTData(entityTagCompound);
            scannedStructure.entities.add(buildEntity);
        }
        Structure.CreateStructureFile(scannedStructure, fileLocation);
    }

    public static BuildBlock createBuildBlockFromBlockState(BlockState currentState, Block currentBlock, BlockPos currentPos, BlockPos originalPos) {
        BuildBlock buildBlock = new BuildBlock();
        buildBlock.setBlockDomain(currentBlock.getRegistryName().m_135827_());
        buildBlock.setBlockName(currentBlock.getRegistryName().m_135815_());
        buildBlock.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(currentPos, originalPos));
        buildBlock.blockPos = currentPos;
        Collection properties = currentState.m_61147_();
        for (Property entry : properties) {
            BuildProperty property = new BuildProperty();
            property.setName(entry.m_61708_());
            Comparable value = currentState.m_61143_(entry);
            try {
                if (currentBlock instanceof RotatedPillarBlock && property.getName().equals("axis")) {
                    property.setValue(((Direction.Axis)value).m_7912_());
                } else if (currentBlock instanceof CarpetBlock && property.getName().equals("color")) {
                    DyeColor dyeColor = (DyeColor)value;
                    property.setValue(dyeColor.m_7912_());
                } else if (value instanceof StringRepresentable) {
                    StringRepresentable stringSerializable = (StringRepresentable)value;
                    property.setValue(stringSerializable.m_7912_());
                } else {
                    property.setValue(value.toString());
                }
            }
            catch (Exception ex) {
                Prefab.LOGGER.error("Unable to set property [" + property.getName() + "] to value [" + value + "] for Block [" + buildBlock.getBlockDomain() + ":" + buildBlock.getBlockName() + "].");
                throw ex;
            }
            buildBlock.getProperties().add(property);
        }
        return buildBlock;
    }

    public static PositionOffset getStartingPositionFromOriginalAndCurrentPosition(BlockPos currentPos, BlockPos originalPos) {
        PositionOffset positionOffSet = new PositionOffset();
        if (currentPos.m_123341_() > originalPos.m_123341_()) {
            positionOffSet.setEastOffset(currentPos.m_123341_() - originalPos.m_123341_());
        } else {
            positionOffSet.setWestOffset(originalPos.m_123341_() - currentPos.m_123341_());
        }
        if (currentPos.m_123343_() > originalPos.m_123343_()) {
            positionOffSet.setSouthOffset(currentPos.m_123343_() - originalPos.m_123343_());
        } else {
            positionOffSet.setNorthOffset(originalPos.m_123343_() - currentPos.m_123343_());
        }
        positionOffSet.setHeightOffset(currentPos.m_123342_() - originalPos.m_123342_());
        return positionOffSet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public BuildClear getClearSpace() {
        return this.clearSpace;
    }

    public void setClearSpace(BuildClear value) {
        this.clearSpace = value;
    }

    public ArrayList<BuildBlock> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(ArrayList<BuildBlock> value) {
        this.blocks = value;
    }

    public void Initialize() {
        this.name = "";
        this.clearSpace = new BuildClear();
        this.blocks = new ArrayList();
    }

    public boolean BuildStructure(StructureConfiguration configuration, ServerLevel world, BlockPos originalPos, Direction assumedNorth, Player player) {
        BlockPos endBlockPos;
        BlockPos startBlockPos = this.clearSpace.getStartingPosition().getRelativePosition(originalPos, this.clearSpace.getShape().getDirection(), configuration.houseFacing);
        Triple<Boolean, BlockState, BlockPos> checkResult = BuildingMethods.CheckBuildSpaceForAllowedBlockReplacement(world, startBlockPos, endBlockPos = startBlockPos.m_5484_(configuration.houseFacing.m_122428_(), this.clearSpace.getShape().getWidth() - 1).m_5484_(configuration.houseFacing.m_122424_(), this.clearSpace.getShape().getWidth() - 1).m_5484_(Direction.UP, this.clearSpace.getShape().getHeight()), player);
        if (!checkResult.getFirst().booleanValue()) {
            TranslatableComponent message = new TranslatableComponent("prefab.gui.structure.nobuild", new Object[]{checkResult.getSecond().m_60734_().getRegistryName().toString(), checkResult.getThird().m_123341_(), checkResult.getThird().m_123342_(), checkResult.getThird().m_123343_()});
            message.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN));
            player.m_6352_((Component)message, player.m_142081_());
            return false;
        }
        if (!this.BeforeBuilding(configuration, (Level)world, originalPos, assumedNorth, player)) {
            this.ClearSpace(configuration, (Level)world, originalPos, assumedNorth);
            boolean blockPlacedWithCobbleStoneInstead = false;
            for (BuildBlock block : this.getBlocks()) {
                Block foundBlock = (Block)ForgeRegistries.BLOCKS.getValue(block.getResourceLocation());
                if (foundBlock != null) {
                    boolean priorityFiveBlock;
                    BlockState blockState = foundBlock.m_49966_();
                    BuildBlock subBlock = null;
                    if (this.WaterReplacedWithCobbleStone(configuration, block, (Level)world, originalPos, assumedNorth, foundBlock, blockState, player).booleanValue() || this.CustomBlockProcessingHandled(configuration, block, (Level)world, originalPos, assumedNorth, foundBlock, blockState, player).booleanValue()) continue;
                    if ((block = BuildBlock.SetBlockState(configuration, (Level)world, originalPos, assumedNorth, block, foundBlock, blockState, this)).getSubBlock() != null) {
                        foundBlock = (Block)ForgeRegistries.BLOCKS.getValue(block.getSubBlock().getResourceLocation());
                        blockState = foundBlock.m_49966_();
                        subBlock = BuildBlock.SetBlockState(configuration, (Level)world, originalPos, assumedNorth, block.getSubBlock(), foundBlock, blockState, this);
                    }
                    if (subBlock != null) {
                        block.setSubBlock(subBlock);
                    }
                    boolean priorityTwoBlock = foundBlock instanceof HopperBlock || foundBlock instanceof LeverBlock;
                    boolean priorityThreeBlock = foundBlock instanceof TorchBlock || foundBlock instanceof SignBlock || foundBlock instanceof ButtonBlock || foundBlock instanceof BedBlock || foundBlock instanceof CarpetBlock || foundBlock instanceof FlowerPotBlock || foundBlock instanceof SugarCaneBlock || foundBlock instanceof BasePressurePlateBlock || foundBlock instanceof DoorBlock || foundBlock instanceof LadderBlock || foundBlock instanceof VineBlock || foundBlock instanceof RedStoneWireBlock || foundBlock instanceof DiodeBlock || foundBlock instanceof AbstractBannerBlock || foundBlock instanceof LanternBlock || foundBlock instanceof MushroomBlock || foundBlock instanceof BaseRailBlock;
                    boolean priorityFourBlock = foundBlock instanceof SandBlock;
                    boolean bl = priorityFiveBlock = foundBlock instanceof SugarCaneBlock || foundBlock instanceof CactusBlock || foundBlock instanceof DeadBushBlock || foundBlock instanceof CoralBlock || foundBlock instanceof RedstoneTorchBlock;
                    if (!block.getHasFacing()) {
                        if (subBlock != null) {
                            block.setSubBlock(subBlock);
                        }
                        if (priorityFiveBlock) {
                            this.priorityFiveBlocks.add(block);
                            continue;
                        }
                        if (priorityFourBlock) {
                            this.priorityFourBlocks.add(block);
                            continue;
                        }
                        if (priorityThreeBlock) {
                            this.priorityThreeBlocks.add(block);
                            continue;
                        }
                        if (foundBlock instanceof AirBlock) {
                            this.airBlocks.add(block);
                            continue;
                        }
                        if (foundBlock instanceof EntityBlock || priorityTwoBlock) {
                            this.priorityTwoBlocks.add(block);
                            continue;
                        }
                        this.priorityOneBlocks.add(block);
                        continue;
                    }
                    if (priorityThreeBlock) {
                        this.priorityThreeBlocks.add(block);
                        continue;
                    }
                    this.priorityTwoBlocks.add(block);
                    continue;
                }
                String blockTypeNotFound = block.getResourceLocation().toString();
                block = BuildBlock.SetBlockState(configuration, (Level)world, originalPos, assumedNorth, block, Blocks.f_50652_, Blocks.f_50652_.m_49966_(), this);
                this.priorityOneBlocks.add(block);
                if (blockPlacedWithCobbleStoneInstead) continue;
                blockPlacedWithCobbleStoneInstead = true;
                Prefab.LOGGER.warn("A Block was in the structure, but it is not registered. This block was replaced with vanilla cobblestone instead. Block type not found: [" + blockTypeNotFound + "]");
            }
            this.configuration = configuration;
            this.world = world;
            this.assumedNorth = assumedNorth;
            this.originalPos = originalPos;
            if (StructureEventHandler.structuresToBuild.containsKey(player)) {
                StructureEventHandler.structuresToBuild.get(player).add(this);
            } else {
                ArrayList<Structure> structures = new ArrayList<Structure>();
                structures.add(this);
                StructureEventHandler.structuresToBuild.put(player, structures);
            }
        }
        return true;
    }

    public void BeforeClearSpaceBlockReplaced(BlockPos pos) {
    }

    public void BeforeHangingEntityRemoved(HangingEntity hangingEntity) {
    }

    public BlockState getStainedGlassBlock(FullDyeColor color) {
        switch (color) {
            case BLACK: {
                return Blocks.f_50215_.m_49966_();
            }
            case BLUE: {
                return Blocks.f_50211_.m_49966_();
            }
            case BROWN: {
                return Blocks.f_50212_.m_49966_();
            }
            case GRAY: {
                return Blocks.f_50207_.m_49966_();
            }
            case GREEN: {
                return Blocks.f_50213_.m_49966_();
            }
            case LIGHT_BLUE: {
                return Blocks.f_50203_.m_49966_();
            }
            case LIGHT_GRAY: {
                return Blocks.f_50208_.m_49966_();
            }
            case LIME: {
                return Blocks.f_50205_.m_49966_();
            }
            case MAGENTA: {
                return Blocks.f_50202_.m_49966_();
            }
            case ORANGE: {
                return Blocks.f_50148_.m_49966_();
            }
            case PINK: {
                return Blocks.f_50206_.m_49966_();
            }
            case PURPLE: {
                return Blocks.f_50210_.m_49966_();
            }
            case RED: {
                return Blocks.f_50214_.m_49966_();
            }
            case WHITE: {
                return Blocks.f_50147_.m_49966_();
            }
            case YELLOW: {
                return Blocks.f_50204_.m_49966_();
            }
            case CLEAR: {
                return Blocks.f_50058_.m_49966_();
            }
        }
        return Blocks.f_50209_.m_49966_();
    }

    public BlockState getStainedGlassPaneBlock(FullDyeColor color) {
        switch (color) {
            case BLACK: {
                return Blocks.f_50371_.m_49966_();
            }
            case BLUE: {
                return Blocks.f_50367_.m_49966_();
            }
            case BROWN: {
                return Blocks.f_50368_.m_49966_();
            }
            case GRAY: {
                return Blocks.f_50363_.m_49966_();
            }
            case GREEN: {
                return Blocks.f_50369_.m_49966_();
            }
            case LIGHT_BLUE: {
                return Blocks.f_50306_.m_49966_();
            }
            case LIGHT_GRAY: {
                return Blocks.f_50364_.m_49966_();
            }
            case LIME: {
                return Blocks.f_50361_.m_49966_();
            }
            case MAGENTA: {
                return Blocks.f_50305_.m_49966_();
            }
            case ORANGE: {
                return Blocks.f_50304_.m_49966_();
            }
            case PINK: {
                return Blocks.f_50362_.m_49966_();
            }
            case PURPLE: {
                return Blocks.f_50366_.m_49966_();
            }
            case RED: {
                return Blocks.f_50370_.m_49966_();
            }
            case WHITE: {
                return Blocks.f_50303_.m_49966_();
            }
            case YELLOW: {
                return Blocks.f_50307_.m_49966_();
            }
            case CLEAR: {
                return Blocks.f_50185_.m_49966_();
            }
        }
        return Blocks.f_50365_.m_49966_();
    }

    protected boolean BeforeBuilding(StructureConfiguration configuration, Level world, BlockPos originalPos, Direction assumedNorth, Player player) {
        return false;
    }

    public void AfterBuilding(StructureConfiguration configuration, ServerLevel world, BlockPos originalPos, Direction assumedNorth, Player player) {
    }

    protected void ClearSpace(StructureConfiguration configuration, Level world, BlockPos originalPos, Direction assumedNorth) {
        if (this.clearSpace.getShape().getWidth() > 0 && this.clearSpace.getShape().getLength() > 0) {
            BlockPos startBlockPos = this.clearSpace.getStartingPosition().getRelativePosition(originalPos, this.clearSpace.getShape().getDirection(), configuration.houseFacing);
            BlockPos endBlockPos = startBlockPos.m_5484_(configuration.houseFacing.m_122424_().m_122427_(), this.clearSpace.getShape().getWidth() - 1).m_5484_(configuration.houseFacing.m_122424_(), this.clearSpace.getShape().getLength() - 1).m_5484_(Direction.UP, this.clearSpace.getShape().getHeight());
            this.clearedBlockPos = new ArrayList();
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)startBlockPos, (BlockPos)endBlockPos)) {
                if (!this.BlockShouldBeClearedDuringConstruction(configuration, world, originalPos, assumedNorth, pos).booleanValue()) continue;
                this.clearedBlockPos.add(new BlockPos((Vec3i)pos));
                this.allBlockPositions.add(new BlockPos((Vec3i)pos));
            }
        } else {
            this.clearedBlockPos = new ArrayList();
        }
    }

    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, Level world, BlockPos originalPos, Direction assumedNorth, Block foundBlock, BlockState blockState, Player player) {
        return false;
    }

    protected Boolean BlockShouldBeClearedDuringConstruction(StructureConfiguration configuration, Level world, BlockPos originalPos, Direction assumedNorth, BlockPos blockPos) {
        return true;
    }

    protected Boolean WaterReplacedWithCobbleStone(StructureConfiguration configuration, BuildBlock block, Level world, BlockPos originalPos, Direction assumedNorth, Block foundBlock, BlockState blockState, Player player) {
        boolean isOverworld;
        boolean bl = isOverworld = Level.f_46428_.compareTo(world.m_46472_()) == 0;
        if (world.m_6042_().m_63951_() || !isOverworld && Prefab.proxy.getServerConfiguration().allowWaterInNonOverworldDimensions) {
            boolean foundWaterLikeBlock;
            boolean bl2 = foundWaterLikeBlock = foundBlock instanceof LiquidBlock && blockState.m_60767_() == Material.f_76305_ || foundBlock instanceof SeagrassBlock;
            if (!foundWaterLikeBlock) {
                for (BuildProperty property : block.getProperties()) {
                    if (!property.getName().equalsIgnoreCase(BlockStateProperties.f_61362_.m_61708_()) || !property.getValue().equalsIgnoreCase(BlockStateProperties.f_61362_.m_6940_(Boolean.valueOf(true)))) continue;
                    foundWaterLikeBlock = true;
                    break;
                }
            }
            if (foundWaterLikeBlock) {
                ResourceLocation cobbleIdentifier = Registry.f_122824_.m_7981_((Object)Blocks.f_50652_);
                block.setBlockDomain(cobbleIdentifier.m_135827_());
                block.setBlockName(cobbleIdentifier.m_135815_());
                block.setBlockState(Blocks.f_50652_.m_49966_());
                this.priorityThreeBlocks.add(block);
                return true;
            }
        }
        return false;
    }
}

