/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.config.enums.AdvancedAquaBaseOptions;
import com.wuest.prefab.structures.config.enums.AdvancedFarmOptions;
import com.wuest.prefab.structures.config.enums.AdvancedWarehouseOptions;
import com.wuest.prefab.structures.config.enums.AquaBaseOptions;
import com.wuest.prefab.structures.config.enums.BaseOption;
import com.wuest.prefab.structures.config.enums.DefenseBunkerOptions;
import com.wuest.prefab.structures.config.enums.EnderGatewayOptions;
import com.wuest.prefab.structures.config.enums.GrassyPlainOptions;
import com.wuest.prefab.structures.config.enums.JailOptions;
import com.wuest.prefab.structures.config.enums.MachineryTowerOptions;
import com.wuest.prefab.structures.config.enums.MagicTempleOptions;
import com.wuest.prefab.structures.config.enums.MineshaftEntranceOptions;
import com.wuest.prefab.structures.config.enums.ModerateFarmOptions;
import com.wuest.prefab.structures.config.enums.ModernBuildingsOptions;
import com.wuest.prefab.structures.config.enums.NetherGateOptions;
import com.wuest.prefab.structures.config.enums.SaloonOptions;
import com.wuest.prefab.structures.config.enums.SkiLodgeOptions;
import com.wuest.prefab.structures.config.enums.StarterFarmOptions;
import com.wuest.prefab.structures.config.enums.TownHallOptions;
import com.wuest.prefab.structures.config.enums.VillagerHouseOptions;
import com.wuest.prefab.structures.config.enums.WarehouseOptions;
import com.wuest.prefab.structures.config.enums.WatchTowerOptions;
import com.wuest.prefab.structures.config.enums.WelcomeCenterOptions;
import com.wuest.prefab.structures.config.enums.WindMillOptions;
import com.wuest.prefab.structures.config.enums.WorkshopOptions;
import com.wuest.prefab.structures.items.ItemBasicStructure;
import com.wuest.prefab.structures.predefined.StructureBasic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

public class BasicStructureConfiguration
extends StructureConfiguration {
    private static final String structureEnumNameTag = "structureEnumName";
    private static final String structureDisplayNameTag = "structureDisplayName";
    private static final String bedColorTag = "bedColor";
    private static final String glassColorTag = "glassColor";
    private static final String chosenOptionTag = "chosenOption";
    public EnumBasicStructureName basicStructureName;
    public String structureDisplayName;
    public DyeColor bedColor;
    public FullDyeColor glassColor;
    public BaseOption chosenOption;

    public String getDisplayName() {
        if (this.basicStructureName == EnumBasicStructureName.Custom) {
            return this.structureDisplayName;
        }
        return this.basicStructureName.getItemTranslationString();
    }

    public boolean IsCustomStructure() {
        return this.basicStructureName == EnumBasicStructureName.Custom;
    }

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseFacing = Direction.NORTH;
        this.basicStructureName = EnumBasicStructureName.AquaBase;
        this.bedColor = DyeColor.RED;
        this.glassColor = FullDyeColor.CLEAR;
        this.chosenOption = this.basicStructureName.baseOption.getSpecificOptions(false).get(0);
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundTag messageTag, StructureConfiguration config) {
        BasicStructureConfiguration basicConfig = (BasicStructureConfiguration)config;
        if (messageTag.m_128441_(structureEnumNameTag)) {
            basicConfig.basicStructureName = EnumBasicStructureName.valueOf(messageTag.m_128461_(structureEnumNameTag));
        }
        if (messageTag.m_128441_(structureDisplayNameTag)) {
            basicConfig.structureDisplayName = messageTag.m_128461_(structureDisplayNameTag);
        }
        if (messageTag.m_128441_(bedColorTag)) {
            basicConfig.bedColor = DyeColor.valueOf((String)messageTag.m_128461_(bedColorTag));
        }
        if (messageTag.m_128441_(glassColorTag)) {
            basicConfig.glassColor = FullDyeColor.valueOf(messageTag.m_128461_(glassColorTag));
        }
        if (messageTag.m_128441_(chosenOptionTag)) {
            basicConfig.chosenOption = BaseOption.getOptionByTranslationString(messageTag.m_128461_(chosenOptionTag));
        }
    }

    @Override
    protected CompoundTag CustomWriteToCompoundTag(CompoundTag tag) {
        tag.m_128359_(structureEnumNameTag, this.basicStructureName.name());
        if (this.structureDisplayName != null) {
            tag.m_128359_(structureDisplayNameTag, this.structureDisplayName);
        }
        tag.m_128359_(bedColorTag, this.bedColor.m_7912_().toUpperCase());
        tag.m_128359_(glassColorTag, this.glassColor.m_7912_().toUpperCase());
        tag.m_128359_(chosenOptionTag, this.chosenOption.getTranslationString());
        return tag;
    }

    @Override
    public BasicStructureConfiguration ReadFromCompoundTag(CompoundTag messageTag) {
        BasicStructureConfiguration config = new BasicStructureConfiguration();
        return (BasicStructureConfiguration)super.ReadFromCompoundTag(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(Player player, ServerLevel world, BlockPos hitBlockPos) {
        StructureBasic structure;
        String assetLocation = "";
        if (!this.IsCustomStructure()) {
            assetLocation = this.chosenOption.getAssetLocation();
        }
        if ((structure = (StructureBasic)StructureBasic.CreateInstance(assetLocation, StructureBasic.class)).BuildStructure(this, world, hitBlockPos, Direction.NORTH, player)) {
            ItemStack stack = ItemBasicStructure.getBasicStructureItemInHand(player);
            if (!stack.m_41763_()) {
                if (stack.m_41613_() == 1) {
                    player.m_150109_().m_36057_(stack);
                } else {
                    stack.m_41764_(stack.m_41613_() - 1);
                }
                player.f_36096_.m_38946_();
            } else {
                this.DamageHeldItem(player, stack.m_41720_());
            }
        }
    }

    public static enum EnumBasicStructureName {
        Custom("custom", null, null, null),
        MachineryTower("machinery_tower", "item.prefab.item_machinery_tower", "item_machinery_tower", MachineryTowerOptions.Default),
        DefenseBunker("defense_bunker", "item.prefab.item_defense_bunker", "item_defense_bunker", DefenseBunkerOptions.Default),
        MineshaftEntrance("mineshaft_entrance", "item.prefab.item_mineshaft_entrance", "item_mineshaft_entrance", MineshaftEntranceOptions.Default),
        EnderGateway("ender_gateway", "item.prefab.item_ender_gateway", "item_ender_gateway", EnderGatewayOptions.Default),
        AquaBase("aqua_base", "item.prefab.item_aqua_base", "item_aqua_base", AquaBaseOptions.Default),
        GrassyPlain("grassy_plain", "item.prefab.item_grassy_plain", "item_grassy_plain", GrassyPlainOptions.Default),
        MagicTemple("magic_temple", "item.prefab.item_magic_temple", "item_magic_temple", MagicTempleOptions.Default),
        WatchTower("watch_tower", "item.prefab.item_watch_tower", "item_watch_tower", WatchTowerOptions.Default),
        WelcomeCenter("welcome_center", "item.prefab.item_welcome_center", "item_welcome_center", WelcomeCenterOptions.Default),
        Jail("jail", "item.prefab.item_jail", "item_jail", JailOptions.Default),
        Saloon("saloon", "item.prefab.item_saloon", "item_saloon", SaloonOptions.Default),
        SkiLodge("ski_lodge", "item.prefab.item_ski_lodge", "item_ski_lodge", SkiLodgeOptions.Default),
        WindMill("wind_mill", "item.prefab.item_wind_mill", "item_wind_mill", WindMillOptions.Default),
        TownHall("town_hall", "item.prefab.item_town_hall", "item_town_hall", TownHallOptions.Default),
        NetherGate("nether_gate", "item.prefab.item_nether_gate", "item_nether_gate", NetherGateOptions.AncientSkull),
        AdvancedAquaBase("advanced_aqua_base", "item.prefab.item_advanced_aqua_base", "item_advanced_aqua_base", AdvancedAquaBaseOptions.Default),
        WorkShop("workshop", "item.prefab.item_workshop", "item_workshop", WorkshopOptions.Default),
        VillagerHouses("villager_houses", "item.prefab.item_villager_houses", "item_villager_houses", VillagerHouseOptions.FLAT_ROOF),
        AdvancedWarehouse("advanced_warehouse", "item.prefab.item_advanced_warehouse", "item_advanced_warehouse", AdvancedWarehouseOptions.Default),
        Warehouse("warehouse", "item.prefab.item_warehouse", "item_warehouse", WarehouseOptions.Default),
        ModernBuildings("modern_buildings", "item.prefab.item_modern_buildings", "item_modern_buildings", ModernBuildingsOptions.Mall),
        StarterFarm("starter_farm", "item.prefab.item_starter_farm", "item_starter_farm", StarterFarmOptions.ElevatedFarm),
        ModerateFarm("moderate_farm", "item.prefab.item_moderate_farm", "item_moderate_farm", ModerateFarmOptions.AutomatedFarm),
        AdvancedFarm("advanced_farm", "item.prefab.item_advanced_farm", "item_advanced_farm", AdvancedFarmOptions.AutomatedBeeFarm);

        private final String name;
        private final String itemTranslationString;
        private final BaseOption baseOption;
        private ResourceLocation itemTextureLocation;

        private EnumBasicStructureName(String name, String itemTranslationString, String itemTextureLocation, BaseOption baseOption) {
            this.name = name;
            this.itemTranslationString = itemTranslationString;
            if (itemTextureLocation != null) {
                this.itemTextureLocation = new ResourceLocation("prefab", itemTextureLocation);
            }
            this.baseOption = baseOption;
        }

        public String getName() {
            return this.name;
        }

        public String getItemTranslationString() {
            return this.itemTranslationString;
        }

        public ResourceLocation getItemTextureLocation() {
            return this.itemTextureLocation;
        }

        public BaseOption getBaseOption() {
            return this.baseOption;
        }
    }
}

