/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.proxy.messages.PlayerEntityTagMessage;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.items.StructureItem;
import com.wuest.prefab.structures.predefined.StructureAlternateStart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.fmllegacy.network.NetworkDirection;

public class HouseConfiguration
extends StructureConfiguration {
    private static String addTorchesTag = "addTorches";
    private static String addBedTag = "addBed";
    private static String addCraftingTableTag = "addCraftingTable";
    private static String addFurnaceTag = "addFurnace";
    private static String addChestTag = "addChest";
    private static String addChestContentsTag = "addChestContents";
    private static String addMineShaftTag = "addMineShaft";
    private static String hitXTag = "hitX";
    private static String hitYTag = "hitY";
    private static String hitZTag = "hitZ";
    private static String houseFacingTag = "houseFacing";
    private static String houseStyleTag = "houseStyle";
    private static String glassColorTag = "glassColor";
    private static String bedColorTag = "bedColor";
    public boolean addTorches;
    public boolean addBed;
    public boolean addCraftingTable;
    public boolean addFurnace;
    public boolean addChest;
    public boolean addChestContents;
    public boolean addMineShaft;
    public HouseStyle houseStyle;
    public FullDyeColor glassColor;
    public DyeColor bedColor;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.BASIC;
        this.glassColor = FullDyeColor.LIGHT_GRAY;
        this.bedColor = DyeColor.RED;
        this.addTorches = true;
        this.addBed = true;
        this.addCraftingTable = true;
        this.addFurnace = true;
        this.addChest = true;
        this.addChestContents = true;
        this.addMineShaft = true;
    }

    @Override
    public CompoundTag WriteToCompoundTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(addTorchesTag, this.addTorches);
        tag.m_128379_(addBedTag, this.addBed);
        tag.m_128379_(addCraftingTableTag, this.addCraftingTable);
        tag.m_128379_(addFurnaceTag, this.addFurnace);
        tag.m_128379_(addChestTag, this.addChest);
        tag.m_128379_(addChestContentsTag, this.addChestContents);
        tag.m_128379_(addMineShaftTag, this.addMineShaft);
        tag.m_128405_(hitXTag, this.pos.m_123341_());
        tag.m_128405_(hitYTag, this.pos.m_123342_());
        tag.m_128405_(hitZTag, this.pos.m_123343_());
        tag.m_128359_(houseFacingTag, this.houseFacing.m_7912_());
        tag.m_128405_(houseStyleTag, this.houseStyle.value);
        tag.m_128359_(glassColorTag, this.glassColor.m_7912_().toUpperCase());
        tag.m_128359_(bedColorTag, this.bedColor.m_7912_().toUpperCase());
        return tag;
    }

    @Override
    public HouseConfiguration ReadFromCompoundTag(CompoundTag tag) {
        HouseConfiguration config = null;
        if (tag != null) {
            config = new HouseConfiguration();
            if (tag.m_128441_(addTorchesTag)) {
                config.addTorches = tag.m_128471_(addTorchesTag);
            }
            if (tag.m_128441_(addBedTag)) {
                config.addBed = tag.m_128471_(addBedTag);
            }
            if (tag.m_128441_(addCraftingTableTag)) {
                config.addCraftingTable = tag.m_128471_(addCraftingTableTag);
            }
            if (tag.m_128441_(addFurnaceTag)) {
                config.addFurnace = tag.m_128471_(addFurnaceTag);
            }
            if (tag.m_128441_(addChestTag)) {
                config.addChest = tag.m_128471_(addChestTag);
            }
            if (tag.m_128441_(addChestContentsTag)) {
                config.addChestContents = tag.m_128471_(addChestContentsTag);
            }
            if (tag.m_128441_(addMineShaftTag)) {
                config.addMineShaft = tag.m_128471_(addMineShaftTag);
            }
            if (tag.m_128441_(hitXTag)) {
                config.pos = new BlockPos(tag.m_128451_(hitXTag), tag.m_128451_(hitYTag), tag.m_128451_(hitZTag));
            }
            if (tag.m_128441_(houseFacingTag)) {
                config.houseFacing = Direction.m_122402_((String)tag.m_128461_(houseFacingTag));
            }
            if (tag.m_128441_(houseStyleTag)) {
                config.houseStyle = HouseStyle.ValueOf(tag.m_128451_(houseStyleTag));
            }
            if (tag.m_128441_(glassColorTag)) {
                config.glassColor = FullDyeColor.valueOf(tag.m_128461_(glassColorTag));
            }
            if (tag.m_128441_(bedColorTag)) {
                config.bedColor = DyeColor.valueOf((String)tag.m_128461_(bedColorTag));
            }
        }
        return config;
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(Player player, ServerLevel world, BlockPos hitBlockPos) {
        boolean houseBuilt = true;
        StructureAlternateStart structure = (StructureAlternateStart)StructureAlternateStart.CreateInstance(this.houseStyle.getStructureLocation(), StructureAlternateStart.class);
        houseBuilt = structure.BuildStructure(this, world, hitBlockPos, Direction.NORTH, player);
        if (houseBuilt) {
            EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntityData(player);
            playerConfig.builtStarterHouse = true;
            playerConfig.saveToPlayer(player);
            this.RemoveStructureItemFromPlayer(player, (StructureItem)ModRegistry.StartHouse.get());
            Prefab.network.sendTo((Object)new PlayerEntityTagMessage(playerConfig.getModIsPlayerNewTag(player)), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static enum HouseStyle {
        BASIC(0, "prefab.gui.starter.basic.display", new ResourceLocation("prefab", "textures/gui/basic_house.png"), "assets/prefab/structures/basic_house.zip"),
        RANCH(1, "prefab.gui.starter.ranch.display", new ResourceLocation("prefab", "textures/gui/ranch_house.png"), "assets/prefab/structures/ranch_house.zip"),
        LOFT(2, "prefab.gui.starter.loft.display", new ResourceLocation("prefab", "textures/gui/loft_house.png"), "assets/prefab/structures/loft_house.zip"),
        HOBBIT(3, "prefab.gui.starter.hobbit.display", new ResourceLocation("prefab", "textures/gui/hobbit_house.png"), "assets/prefab/structures/hobbit_house.zip"),
        DESERT(4, "prefab.gui.starter.desert.display", new ResourceLocation("prefab", "textures/gui/desert_house.png"), "assets/prefab/structures/desert_house.zip"),
        SNOWY(5, "prefab.gui.starter.snowy.display", new ResourceLocation("prefab", "textures/gui/snowy_house.png"), "assets/prefab/structures/snowy_house.zip"),
        DESERT2(6, "prefab.gui.starter.desert.display2", new ResourceLocation("prefab", "textures/gui/desert_house2.png"), "assets/prefab/structures/desert_house2.zip"),
        SUBAQUATIC(7, "prefab.gui.starter.subaquatic.display", new ResourceLocation("prefab", "textures/gui/subaqua_house.png"), "assets/prefab/structures/subaqua_house.zip"),
        MODERN(8, "prefab.gui.starter.modern.display", new ResourceLocation("prefab", "textures/gui/modern_starting_house.png"), "assets/prefab/structures/modern_starting_house.zip"),
        CAMPSITE(9, "prefab.gui.starter.camping.display", new ResourceLocation("prefab", "textures/gui/campsite_house.png"), "assets/prefab/structures/campsite_house.zip");

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final String structureLocation;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, String structureLocation) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.structureLocation = structureLocation;
        }

        public static HouseStyle ValueOf(int value) {
            HouseStyle returnValue = BASIC;
            for (HouseStyle current : HouseStyle.values()) {
                if (current.value != value) continue;
                returnValue = current;
                break;
            }
            return returnValue;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }
    }
}

