/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.structures.base.EnumStructureMaterial;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.predefined.StructureInstantBridge;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class InstantBridgeConfiguration
extends StructureConfiguration {
    public int bridgeLength;
    public EnumStructureMaterial bridgeMaterial;
    public boolean includeRoof;
    public int interiorHeight;

    @Override
    public void Initialize() {
        super.Initialize();
        this.bridgeLength = 25;
        this.bridgeMaterial = EnumStructureMaterial.Cobblestone;
        this.interiorHeight = 3;
        this.includeRoof = true;
    }

    @Override
    public InstantBridgeConfiguration ReadFromCompoundTag(CompoundTag messageTag) {
        InstantBridgeConfiguration config = new InstantBridgeConfiguration();
        return (InstantBridgeConfiguration)super.ReadFromCompoundTag(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(Player player, ServerLevel world, BlockPos hitBlockPos) {
        StructureInstantBridge structure = StructureInstantBridge.CreateInstance();
        if (structure.BuildStructure(this, world, hitBlockPos, Direction.NORTH, player)) {
            this.DamageHeldItem(player, (Item)ModRegistry.InstantBridge.get());
        }
    }

    @Override
    protected CompoundTag CustomWriteToCompoundTag(CompoundTag tag) {
        tag.m_128405_("bridgeLength", this.bridgeLength);
        tag.m_128405_("bridgeMaterial", this.bridgeMaterial.getNumber());
        tag.m_128379_("includeRoof", this.includeRoof);
        tag.m_128405_("interiorHeight", this.interiorHeight);
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundTag messageTag, StructureConfiguration config) {
        if (messageTag.m_128441_("bridgeLength")) {
            ((InstantBridgeConfiguration)config).bridgeLength = messageTag.m_128451_("bridgeLength");
        }
        if (messageTag.m_128441_("bridgeMaterial")) {
            ((InstantBridgeConfiguration)config).bridgeMaterial = EnumStructureMaterial.getMaterialByNumber(messageTag.m_128451_("bridgeMaterial"));
        }
        if (messageTag.m_128441_("includeRoof")) {
            ((InstantBridgeConfiguration)config).includeRoof = messageTag.m_128471_("includeRoof");
        }
        if (messageTag.m_128441_("interiorHeight")) {
            ((InstantBridgeConfiguration)config).interiorHeight = messageTag.m_128451_("interiorHeight");
        }
    }
}

