/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.items.StructureItem;
import com.wuest.prefab.structures.predefined.StructureModerateHouse;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;

public class ModerateHouseConfiguration
extends StructureConfiguration {
    public static String tagKey = "houseConfig";
    private static String houseStyleTag = "houseStyle";
    private static String addChestTag = "addChests";
    private static String addChestContentsTag = "addChestContents";
    private static String addMineshaftTag = "addMineshaft";
    private static String bedColorTag = "bedColor";
    public HouseStyle houseStyle = HouseStyle.SPRUCE_HOME;
    public boolean addChests = true;
    public boolean addChestContents = true;
    public boolean addMineshaft = true;
    public DyeColor bedColor = DyeColor.RED;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.SPRUCE_HOME;
        this.bedColor = DyeColor.RED;
    }

    @Override
    protected CompoundTag CustomWriteToCompoundTag(CompoundTag tag) {
        tag.m_128405_(houseStyleTag, this.houseStyle.value);
        tag.m_128379_(addChestTag, this.addChests);
        tag.m_128379_(addChestContentsTag, this.addChestContents);
        tag.m_128379_(addMineshaftTag, this.addMineshaft);
        tag.m_128359_(bedColorTag, this.bedColor.m_7912_().toUpperCase());
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundTag messageTag, StructureConfiguration config) {
        ModerateHouseConfiguration houseConfiguration = (ModerateHouseConfiguration)config;
        if (messageTag.m_128441_(houseStyleTag)) {
            houseConfiguration.houseStyle = HouseStyle.ValueOf(messageTag.m_128451_(houseStyleTag));
        }
        if (messageTag.m_128441_(addChestTag)) {
            houseConfiguration.addChests = messageTag.m_128471_(addChestTag);
        }
        if (messageTag.m_128441_(addChestContentsTag)) {
            houseConfiguration.addChestContents = messageTag.m_128471_(addChestContentsTag);
        }
        if (messageTag.m_128441_(addMineshaftTag)) {
            houseConfiguration.addMineshaft = messageTag.m_128471_(addMineshaftTag);
        }
        if (messageTag.m_128441_(bedColorTag)) {
            houseConfiguration.bedColor = DyeColor.valueOf((String)messageTag.m_128461_(bedColorTag));
        }
    }

    @Override
    public ModerateHouseConfiguration ReadFromCompoundTag(CompoundTag messageTag) {
        ModerateHouseConfiguration config = new ModerateHouseConfiguration();
        return (ModerateHouseConfiguration)super.ReadFromCompoundTag(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(Player player, ServerLevel world, BlockPos hitBlockPos) {
        StructureModerateHouse structure = (StructureModerateHouse)StructureModerateHouse.CreateInstance(this.houseStyle.getStructureLocation(), StructureModerateHouse.class);
        if (structure.BuildStructure(this, world, hitBlockPos, Direction.NORTH, player)) {
            this.RemoveStructureItemFromPlayer(player, (StructureItem)ModRegistry.ModerateHouse.get());
        }
    }

    public static enum HouseStyle {
        SPRUCE_HOME(0, "prefab.gui.moderate_house.spruce", new ResourceLocation("prefab", "textures/gui/moderate_house_spruce_topdown.png"), 176, 154, "assets/prefab/structures/moderate_house_spruce.zip", 31, 31, 23, 8, 1),
        ACACIA_HOME(1, "prefab.gui.moderate_house.acacia", new ResourceLocation("prefab", "textures/gui/moderate_house_acacia_topdown.png"), 176, 154, "assets/prefab/structures/moderate_house_acacia.zip", 31, 31, 21, 12, 6),
        EARTHEN_HOME(2, "prefab.gui.moderate_house.earthen", new ResourceLocation("prefab", "textures/gui/moderate_house_earthen_topdown.png"), 174, 146, "assets/prefab/structures/moderate_house_earthen.zip", 16, 16, 16, 8, 6),
        JUNGLE_TREE_HOME(3, "prefab.gui.moderate_house.jungle", new ResourceLocation("prefab", "textures/gui/moderate_house_jungle_topdown.png"), 88, 164, "assets/prefab/structures/moderate_house_jungle.zip", 16, 16, 41, 8, 1),
        NETHER_HOME(4, "prefab.gui.moderate_house.nether", new ResourceLocation("prefab", "textures/gui/moderate_house_nether_topdown.png"), 141, 165, "assets/prefab/structures/moderate_house_nether.zip", 16, 15, 22, 0, 0),
        MOUNTAIN_HOME(5, "prefab.gui.moderate_house.mountain", new ResourceLocation("prefab", "textures/gui/moderate_house_mountain_topdown.png"), 174, 99, "assets/prefab/structures/moderate_house_mountain.zip", 20, 21, 12, 10, 0),
        ACACIA_HOME2(6, "prefab.gui.moderate_house.acacia_2", new ResourceLocation("prefab", "textures/gui/moderate_house_acacia_2_topdown.png"), 174, 99, "assets/prefab/structures/moderate_house_acacia_2.zip", 31, 31, 21, 12, 6);

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final int imageWidth;
        private final int imageHeight;
        private final String structureLocation;
        private final int width;
        private final int length;
        private final int height;
        private final int eastOffSet;
        private final int downOffSet;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, int imageWidth, int imageHeight, String structureLocation, int width, int length, int height, int eastOffSet, int downOffSet) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.structureLocation = structureLocation;
            this.width = width;
            this.length = length;
            this.height = height;
            this.eastOffSet = eastOffSet;
            this.downOffSet = downOffSet;
        }

        public static HouseStyle ValueOf(int value) {
            for (HouseStyle currentValue : HouseStyle.values()) {
                if (currentValue.value != value) continue;
                return currentValue;
            }
            return SPRUCE_HOME;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public int getImageWidth() {
            return this.imageWidth;
        }

        public int getImageHeight() {
            return this.imageHeight;
        }

        public int getWidth() {
            return this.width;
        }

        public int getLength() {
            return this.length;
        }

        public int getHeight() {
            return this.height;
        }

        public int getEastOffSet() {
            return this.eastOffSet;
        }

        public int getDownOffSet() {
            return this.downOffSet;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }
    }
}

