/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.structures.items.StructureItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ForgeEventFactory;

public class StructureConfiguration {
    public static String houseFacingName = "House Facing";
    private static String hitXTag = "hitX";
    private static String hitYTag = "hitY";
    private static String hitZTag = "hitZ";
    private static String houseFacingTag = "wareHouseFacing";
    public Direction houseFacing;
    public BlockPos pos;

    public StructureConfiguration() {
        this.Initialize();
    }

    public void Initialize() {
        this.houseFacing = Direction.NORTH;
    }

    public CompoundTag WriteToCompoundTag() {
        CompoundTag tag = new CompoundTag();
        if (this.pos != null) {
            tag.m_128405_(hitXTag, this.pos.m_123341_());
            tag.m_128405_(hitYTag, this.pos.m_123342_());
            tag.m_128405_(hitZTag, this.pos.m_123343_());
        }
        tag.m_128359_(houseFacingTag, this.houseFacing.m_7912_());
        tag = this.CustomWriteToCompoundTag(tag);
        return tag;
    }

    public StructureConfiguration ReadFromCompoundTag(CompoundTag messageTag) {
        return null;
    }

    public StructureConfiguration ReadFromCompoundTag(CompoundTag messageTag, StructureConfiguration config) {
        if (messageTag != null) {
            if (messageTag.m_128441_(hitXTag)) {
                config.pos = new BlockPos(messageTag.m_128451_(hitXTag), messageTag.m_128451_(hitYTag), messageTag.m_128451_(hitZTag));
            }
            if (messageTag.m_128441_(houseFacingTag)) {
                config.houseFacing = Direction.m_122402_((String)messageTag.m_128461_(houseFacingTag));
            }
            this.CustomReadFromNBTTag(messageTag, config);
        }
        return config;
    }

    public void BuildStructure(Player player, ServerLevel world) {
        BlockPos hitBlockPos = this.pos;
        this.ConfigurationSpecificBuildStructure(player, world, hitBlockPos);
    }

    protected void ConfigurationSpecificBuildStructure(Player player, ServerLevel world, BlockPos hitBlockPos) {
    }

    protected CompoundTag CustomWriteToCompoundTag(CompoundTag tag) {
        return tag;
    }

    protected void CustomReadFromNBTTag(CompoundTag messageTag, StructureConfiguration config) {
    }

    protected void RemoveStructureItemFromPlayer(Player player, StructureItem item) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != item) {
            stack = player.m_21206_();
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                player.m_150109_().f_35976_.set(0, (Object)ItemStack.f_41583_);
            }
        } else {
            int slot = this.getSlotFor(player.m_150109_(), stack);
            if (slot != -1) {
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    player.m_150109_().m_6836_(slot, ItemStack.f_41583_);
                }
            }
        }
        player.f_36096_.m_38946_();
    }

    protected void DamageHeldItem(Player player, Item item) {
        ItemStack stack = player.m_21205_().m_41720_() == item ? player.m_21205_() : player.m_21206_();
        InteractionHand hand = player.m_21205_().m_41720_() == item ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack copy = stack.m_41777_();
        stack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
        if (stack.m_41619_()) {
            ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)hand);
            EquipmentSlot slotType = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            player.m_8061_(slotType, ItemStack.f_41583_);
        }
        player.f_36096_.m_38946_();
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41720_() == stack2.m_41720_() && ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2);
    }

    public int getSlotFor(Inventory playerInventory, ItemStack stack) {
        for (int i = 0; i < playerInventory.f_35974_.size(); ++i) {
            if (((ItemStack)playerInventory.f_35974_.get(i)).m_41619_() || !this.stackEqualExact(stack, (ItemStack)playerInventory.f_35974_.get(i))) continue;
            return i;
        }
        return -1;
    }
}

