/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.events;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.proxy.messages.PlayerEntityTagMessage;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildEntity;
import com.wuest.prefab.structures.base.BuildTileEntity;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.Structure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="prefab")
public final class StructureEventHandler {
    public static HashMap<Player, ArrayList<Structure>> structuresToBuild = new HashMap();
    public static ArrayList<Tuple<Structure, BuildEntity>> entitiesToGenerate = new ArrayList();
    public static int ticksSinceLastEntitiesGenerated = 0;

    @SubscribeEvent
    public static void PlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().f_19853_.m_5776_() && event.getPlayer() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getPlayer();
            EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntityData((Player)player);
            String startingItem = CommonProxy.proxyConfiguration.serverConfiguration.startingItem;
            if (!playerConfig.givenHouseBuilder && startingItem != null) {
                ItemStack stack = ItemStack.f_41583_;
                switch (startingItem.toLowerCase()) {
                    case "starting house": {
                        stack = new ItemStack((ItemLike)ModRegistry.StartHouse.get());
                        break;
                    }
                    case "moderate house": {
                        stack = new ItemStack((ItemLike)ModRegistry.ModerateHouse.get());
                    }
                }
                if (!stack.m_41619_()) {
                    System.out.println(player.m_5446_().getString() + " joined the game for the first time. Giving them starting item.");
                    player.m_150109_().m_36054_(stack);
                    player.f_36096_.m_38946_();
                    playerConfig.givenHouseBuilder = true;
                    playerConfig.saveToPlayer((Player)player);
                }
            }
            Prefab.network.sendTo((Object)new PlayerEntityTagMessage(playerConfig.getModIsPlayerNewTag((Player)player)), ((ServerPlayer)event.getPlayer()).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ArrayList<Player> playersToRemove = new ArrayList<Player>();
            if (++ticksSinceLastEntitiesGenerated > 40) {
                StructureEventHandler.processStructureEntities();
                ticksSinceLastEntitiesGenerated = 0;
            }
            for (Map.Entry<Player, ArrayList<Structure>> entry : structuresToBuild.entrySet()) {
                ArrayList<Structure> structuresToRemove = new ArrayList<Structure>();
                for (Structure structure : entry.getValue()) {
                    if (!structure.entitiesRemoved) {
                        for (BlockPos clearedPos : structure.clearedBlockPos) {
                            AABB axisPos = Shapes.m_83144_().m_83215_().m_82338_(clearedPos);
                            List list = structure.world.m_45933_((Entity)null, axisPos);
                            if (list.isEmpty()) continue;
                            for (Entity entity : list) {
                                if (entity instanceof LivingEntity) continue;
                                if (entity instanceof HangingEntity) {
                                    structure.BeforeHangingEntityRemoved((HangingEntity)entity);
                                }
                                structure.world.removeEntity(entity, false);
                            }
                        }
                        structure.entitiesRemoved = true;
                    }
                    if (structure.airBlocks.size() > 0) {
                        structure.hasAirBlocks = true;
                    }
                    for (int i = 0; i < 100; ++i) {
                        i = StructureEventHandler.setBlock(i, structure, structuresToRemove);
                    }
                    StructureEventHandler.removeWaterLogging(structure);
                }
                StructureEventHandler.removeStructuresFromList(structuresToRemove, entry);
                if (entry.getValue().size() != 0) continue;
                playersToRemove.add(entry.getKey());
            }
            for (Player player : playersToRemove) {
                structuresToBuild.remove(player);
            }
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            CompoundTag originalTag = event.getOriginal().getPersistentData();
            String startingItem = CommonProxy.proxyConfiguration.serverConfiguration.startingItem;
            if (startingItem != null && !startingItem.equalsIgnoreCase("Nothing") && originalTag.m_128441_("IsPlayerNew")) {
                CompoundTag newPlayerTag = event.getPlayer().getPersistentData();
                newPlayerTag.m_128365_("IsPlayerNew", originalTag.m_128423_("IsPlayerNew"));
                Prefab.network.sendTo((Object)new PlayerEntityTagMessage(originalTag.m_128469_("IsPlayerNew")), ((ServerPlayer)event.getPlayer()).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    private static int setBlock(int i, Structure structure, ArrayList<Structure> structuresToRemove) {
        if (structure.clearedBlockPos.size() > 0 && !structure.hasAirBlocks) {
            BlockPos currentPos = structure.clearedBlockPos.get(0);
            structure.clearedBlockPos.remove(0);
            BlockState clearBlockState = structure.world.m_8055_(currentPos);
            if (clearBlockState.m_60767_() != Material.f_76296_) {
                structure.BeforeClearSpaceBlockReplaced(currentPos);
                block0: for (Direction adjacentBlock : Direction.values()) {
                    BlockPos tempPos = currentPos.m_142300_(adjacentBlock);
                    BlockState foundState = structure.world.m_8055_(tempPos);
                    Block foundBlock = foundState.m_60734_();
                    if (!(foundBlock instanceof TorchBlock) && !(foundBlock instanceof SignBlock) && !(foundBlock instanceof LeverBlock) && !(foundBlock instanceof ButtonBlock) && !(foundBlock instanceof BedBlock) && !(foundBlock instanceof CarpetBlock) && !(foundBlock instanceof FlowerPotBlock) && !(foundBlock instanceof SugarCaneBlock) && !(foundBlock instanceof BasePressurePlateBlock) && !(foundBlock instanceof DoorBlock) && !(foundBlock instanceof LadderBlock) && !(foundBlock instanceof VineBlock) && !(foundBlock instanceof RedStoneWireBlock) && !(foundBlock instanceof DiodeBlock) && !(foundBlock instanceof AbstractBannerBlock) && !(foundBlock instanceof LanternBlock) && !(foundBlock instanceof BaseRailBlock)) continue;
                    structure.BeforeClearSpaceBlockReplaced(currentPos);
                    if (!(foundBlock instanceof BedBlock)) {
                        structure.world.m_7471_(tempPos, false);
                        continue;
                    }
                    if (foundBlock instanceof DoorBlock) {
                        DoubleBlockHalf currentHalf = (DoubleBlockHalf)foundState.m_61143_((Property)BlockStateProperties.f_61401_);
                        BlockPos otherHalfPos = currentHalf == DoubleBlockHalf.LOWER ? tempPos.m_7494_() : tempPos.m_7495_();
                        structure.world.m_7731_(tempPos, Blocks.f_50016_.m_49966_(), 35);
                        structure.world.m_7731_(otherHalfPos, Blocks.f_50016_.m_49966_(), 35);
                        continue;
                    }
                    for (Direction currentDirection : Direction.values()) {
                        BlockPos bedPos = tempPos.m_142300_(currentDirection);
                        BlockState bedState = structure.world.m_8055_(bedPos);
                        if (!(bedState.m_60734_() instanceof BedBlock)) continue;
                        structure.world.m_7731_(tempPos, Blocks.f_50016_.m_49966_(), 35);
                        structure.world.m_7731_(bedPos, Blocks.f_50016_.m_49966_(), 35);
                        continue block0;
                    }
                }
                structure.world.m_7471_(currentPos, false);
            } else {
                --i;
            }
            return i;
        }
        BuildBlock currentBlock = null;
        if (structure.priorityOneBlocks.size() > 0) {
            currentBlock = structure.priorityOneBlocks.get(0);
            structure.priorityOneBlocks.remove(0);
        } else if (structure.priorityTwoBlocks.size() > 0) {
            currentBlock = structure.priorityTwoBlocks.get(0);
            structure.priorityTwoBlocks.remove(0);
        } else if (structure.airBlocks.size() > 0) {
            currentBlock = structure.airBlocks.get(0);
            structure.airBlocks.remove(0);
        } else if (structure.priorityThreeBlocks.size() > 0) {
            currentBlock = structure.priorityThreeBlocks.get(0);
            structure.priorityThreeBlocks.remove(0);
        } else if (structure.priorityFourBlocks.size() > 0) {
            currentBlock = structure.priorityFourBlocks.get(0);
            structure.priorityFourBlocks.remove(0);
        } else if (structure.priorityFiveBlocks.size() > 0) {
            currentBlock = structure.priorityFiveBlocks.get(0);
            structure.priorityFiveBlocks.remove(0);
        } else {
            structuresToRemove.add(structure);
            return 999;
        }
        BlockState state = currentBlock.getBlockState();
        BlockPos setBlockPos = currentBlock.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing);
        BuildingMethods.ReplaceBlock((Level)structure.world, setBlockPos, state);
        if (currentBlock.getSubBlock() != null) {
            BuildBlock subBlock = currentBlock.getSubBlock();
            BuildingMethods.ReplaceBlock((Level)structure.world, subBlock.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing), subBlock.getBlockState());
        }
        return i;
    }

    private static void removeStructuresFromList(ArrayList<Structure> structuresToRemove, Map.Entry<Player, ArrayList<Structure>> entry) {
        for (Structure structure : structuresToRemove) {
            for (BuildTileEntity buildTileEntity : structure.tileEntities) {
                BlockPos tileEntityPos = buildTileEntity.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing);
                BlockEntity tileEntity = structure.world.m_7702_(tileEntityPos);
                BlockState tileBlock = structure.world.m_8055_(tileEntityPos);
                if (tileEntity == null) continue;
                structure.world.m_46747_(tileEntityPos);
                tileEntity = BlockEntity.m_155241_((BlockPos)tileEntityPos, (BlockState)tileBlock, (CompoundTag)buildTileEntity.getEntityDataTag());
                structure.world.m_151523_(tileEntity);
                structure.world.m_46745_(tileEntityPos).m_6427_();
                tileEntity.m_6596_();
                ClientboundBlockEntityDataPacket packet = tileEntity.m_7033_();
                if (packet == null) continue;
                structure.world.m_142572_().m_6846_().m_11268_((Packet)packet);
            }
            StructureEventHandler.removeWaterLogging(structure);
            for (BuildEntity buildEntity : structure.entities) {
                Optional entityType = EntityType.m_20632_((String)buildEntity.getEntityResourceString());
                if (!entityType.isPresent()) continue;
                entitiesToGenerate.add(new Tuple<Structure, BuildEntity>(structure, buildEntity));
            }
            structure.AfterBuilding(structure.configuration, structure.world, structure.originalPos, structure.assumedNorth, entry.getKey());
            entry.getValue().remove(structure);
        }
    }

    private static void processStructureEntities() {
        for (Tuple<Structure, BuildEntity> entityRecords : entitiesToGenerate) {
            Entity entity;
            BuildEntity buildEntity = entityRecords.getSecond();
            Structure structure = entityRecords.getFirst();
            Optional entityType = EntityType.m_20632_((String)buildEntity.getEntityResourceString());
            if (!entityType.isPresent() || (entity = ((EntityType)entityType.get()).m_20615_((Level)structure.world)) == null) continue;
            CompoundTag tagCompound = buildEntity.getEntityDataTag();
            BlockPos entityPos = buildEntity.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing);
            if (tagCompound != null) {
                if (tagCompound.m_128403_("UUID")) {
                    tagCompound.m_128362_("UUID", UUID.randomUUID());
                }
                ListTag nbttaglist = new ListTag();
                nbttaglist.add((Object)DoubleTag.m_128500_((double)entityPos.m_123341_()));
                nbttaglist.add((Object)DoubleTag.m_128500_((double)entityPos.m_123342_()));
                nbttaglist.add((Object)DoubleTag.m_128500_((double)entityPos.m_123343_()));
                tagCompound.m_128365_("Pos", (Tag)nbttaglist);
                entity.m_20258_(tagCompound);
            }
            if (entity instanceof ItemFrame) {
                entity = StructureEventHandler.setItemFrameFacingAndRotation((ItemFrame)entity, buildEntity, entityPos, structure);
            } else if (entity instanceof Painting) {
                entity = StructureEventHandler.setPaintingFacingAndRotation((Painting)entity, buildEntity, entityPos, structure);
            } else if (entity instanceof AbstractMinecart) {
                buildEntity.entityYAxisOffset += 0.2;
                entity = StructureEventHandler.setEntityFacingAndRotation(entity, buildEntity, entityPos, structure);
            } else {
                entity = StructureEventHandler.setEntityFacingAndRotation(entity, buildEntity, entityPos, structure);
            }
            structure.world.m_7967_(entity);
        }
        entitiesToGenerate.clear();
    }

    private static void removeWaterLogging(Structure structure) {
        if (structure.hasAirBlocks) {
            for (BlockPos currentPos : structure.allBlockPositions) {
                BlockState currentState = structure.world.m_8055_(currentPos);
                if (currentState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    currentState = (BlockState)currentState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
                    structure.world.m_7731_(currentPos, currentState, 3);
                    continue;
                }
                if (currentState.m_60767_() != Material.f_76305_) continue;
                structure.world.m_7731_(currentPos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    private static Entity setPaintingFacingAndRotation(Painting entity, BuildEntity buildEntity, BlockPos entityPos, Structure structure) {
        float yaw = entity.m_146908_();
        Rotation rotation = Rotation.NONE;
        double x_axis_offset = 0.0;
        double z_axis_offset = 0.0;
        Direction facing = entity.m_6350_();
        double y_axis_offset = buildEntity.entityYAxisOffset * -1.0;
        if (structure.configuration.houseFacing == structure.assumedNorth.m_122424_()) {
            rotation = Rotation.CLOCKWISE_180;
            facing = facing.m_122424_();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.m_122427_()) {
            rotation = Rotation.CLOCKWISE_90;
            if (structure.getClearSpace().getShape().getDirection() == Direction.NORTH) {
                facing = facing.m_122428_();
            } else if (structure.getClearSpace().getShape().getDirection() == Direction.SOUTH) {
                facing = facing.m_122427_();
            }
        } else if (structure.configuration.houseFacing == structure.assumedNorth.m_122428_()) {
            rotation = Rotation.COUNTERCLOCKWISE_90;
            if (structure.getClearSpace().getShape().getDirection() == Direction.NORTH) {
                facing = facing.m_122427_();
            } else if (structure.getClearSpace().getShape().getDirection() == Direction.SOUTH) {
                facing = facing.m_122428_();
            }
        }
        if (entity.f_31902_.m_31901_() > entity.f_31902_.m_31896_() || entity.f_31902_.m_31901_() > 16) {
            y_axis_offset -= 1.0;
        }
        yaw = entity.m_7890_(rotation);
        Painting hangingEntity = entity;
        CompoundTag compound = new CompoundTag();
        hangingEntity.m_7380_(compound);
        compound.m_128344_("Facing", (byte)facing.m_122416_());
        hangingEntity.m_7378_(compound);
        StructureEventHandler.updateEntityHangingBoundingBox((HangingEntity)hangingEntity);
        entity.m_7678_((double)entityPos.m_123341_() + x_axis_offset, (double)entityPos.m_123342_() + y_axis_offset, (double)entityPos.m_123343_() + z_axis_offset, yaw, entity.m_146909_());
        StructureEventHandler.updateEntityHangingBoundingBox((HangingEntity)entity);
        LevelChunk chunk = structure.world.m_46745_(entityPos);
        chunk.m_8092_(true);
        return entity;
    }

    private static Entity setItemFrameFacingAndRotation(ItemFrame frame, BuildEntity buildEntity, BlockPos entityPos, Structure structure) {
        float yaw = frame.m_146908_();
        Rotation rotation = Rotation.NONE;
        double x_axis_offset = buildEntity.entityXAxisOffset;
        double z_axis_offset = buildEntity.entityZAxisOffset;
        Direction facing = frame.m_6350_();
        double y_axis_offset = buildEntity.entityYAxisOffset;
        x_axis_offset *= -1.0;
        z_axis_offset *= -1.0;
        if (facing != Direction.UP && facing != Direction.DOWN) {
            if (structure.configuration.houseFacing == structure.assumedNorth.m_122424_()) {
                rotation = Rotation.CLOCKWISE_180;
                facing = facing.m_122424_();
            } else if (structure.configuration.houseFacing == structure.assumedNorth.m_122427_()) {
                if (structure.getClearSpace().getShape().getDirection() == Direction.NORTH) {
                    rotation = Rotation.CLOCKWISE_90;
                    facing = facing.m_122428_();
                } else if (structure.getClearSpace().getShape().getDirection() == Direction.SOUTH) {
                    facing = facing.m_122427_();
                    rotation = Rotation.COUNTERCLOCKWISE_90;
                }
            } else if (structure.configuration.houseFacing == structure.assumedNorth.m_122428_()) {
                if (structure.getClearSpace().getShape().getDirection() == Direction.NORTH) {
                    rotation = Rotation.COUNTERCLOCKWISE_90;
                    facing = facing.m_122427_();
                } else if (structure.getClearSpace().getShape().getDirection() == Direction.SOUTH) {
                    facing = facing.m_122428_();
                    rotation = Rotation.CLOCKWISE_90;
                }
            } else {
                x_axis_offset = 0.0;
                z_axis_offset = 0.0;
            }
        }
        yaw = frame.m_7890_(rotation);
        ItemFrame hangingEntity = frame;
        CompoundTag compound = new CompoundTag();
        hangingEntity.m_7380_(compound);
        compound.m_128344_("Facing", (byte)facing.m_122411_());
        hangingEntity.m_7378_(compound);
        StructureEventHandler.updateEntityHangingBoundingBox((HangingEntity)hangingEntity);
        frame.m_7678_((double)entityPos.m_123341_() + x_axis_offset, (double)entityPos.m_123342_() + y_axis_offset, (double)entityPos.m_123343_() + z_axis_offset, yaw, frame.m_146909_());
        StructureEventHandler.updateEntityHangingBoundingBox((HangingEntity)frame);
        LevelChunk chunk = structure.world.m_46745_(entityPos);
        chunk.m_8092_(true);
        return frame;
    }

    private static Entity setEntityFacingAndRotation(Entity entity, BuildEntity buildEntity, BlockPos entityPos, Structure structure) {
        float yaw = entity.m_146908_();
        Rotation rotation = Rotation.NONE;
        double x_axis_offset = buildEntity.entityXAxisOffset;
        double z_axis_offset = buildEntity.entityZAxisOffset;
        Direction facing = structure.assumedNorth;
        double y_axis_offset = buildEntity.entityYAxisOffset;
        if (structure.configuration.houseFacing == structure.assumedNorth.m_122424_()) {
            rotation = Rotation.CLOCKWISE_180;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.m_122424_();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.m_122427_()) {
            rotation = Rotation.CLOCKWISE_90;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.m_122427_();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.m_122428_()) {
            rotation = Rotation.COUNTERCLOCKWISE_90;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.m_122428_();
        } else {
            x_axis_offset = 0.0;
            z_axis_offset = 0.0;
        }
        yaw = entity.m_7890_(rotation);
        entity.m_7678_((double)entityPos.m_123341_() + x_axis_offset, (double)entityPos.m_123342_() + y_axis_offset, (double)entityPos.m_123343_() + z_axis_offset, yaw, entity.m_146909_());
        return entity;
    }

    private static void updateEntityHangingBoundingBox(HangingEntity entity) {
        double d0 = (double)entity.m_31748_().m_123341_() + 0.5;
        double d1 = (double)entity.m_31748_().m_123342_() + 0.5;
        double d2 = (double)entity.m_31748_().m_123343_() + 0.5;
        double d3 = 0.46875;
        double d4 = entity.m_7076_() % 32 == 0 ? 0.5 : 0.0;
        double d5 = entity.m_7068_() % 32 == 0 ? 0.5 : 0.0;
        Direction horizontal = entity.m_6350_();
        d0 -= (double)horizontal.m_122429_() * 0.46875;
        d2 -= (double)horizontal.m_122431_() * 0.46875;
        Direction direction = horizontal == Direction.DOWN || horizontal == Direction.UP ? horizontal.m_122424_() : horizontal.m_122428_();
        entity.m_20343_(d0 += d4 * (double)direction.m_122429_(), d1 += d5, d2 += d4 * (double)direction.m_122431_());
        double d6 = entity.m_7076_();
        double d7 = entity.m_7068_();
        double d8 = entity.m_7076_();
        if (horizontal.m_122434_() == Direction.Axis.Z) {
            d8 = 1.0;
        } else {
            d6 = 1.0;
        }
        entity.m_20011_(new AABB(d0 - (d6 /= 32.0), d1 - (d7 /= 32.0), d2 - (d8 /= 32.0), d0 + d6, d1 + d7, d2 + d8));
    }
}

