/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.gui.GuiBase;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.render.StructureRenderHandler;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class GuiStructure
extends GuiBase {
    public BlockPos pos;
    protected Player player;
    protected Button btnCancel;
    protected Button btnBuild;
    protected Button btnVisualize;
    public StructureTagMessage.EnumStructureConfiguration structureConfiguration;
    protected ResourceLocation structureImageLocation;
    private Direction structureFacing;

    public GuiStructure(String title) {
        super(title);
    }

    @Override
    public void m_7856_() {
        this.player = this.getMinecraft().f_91074_;
        this.structureFacing = this.player.m_6350_().m_122424_();
        this.Initialize();
    }

    @Override
    protected void Initialize() {
        super.Initialize();
    }

    protected void InitializeStandardButtons() {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnVisualize = this.createAndAddCustomButton(grayBoxX + 113, grayBoxY + 165, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(grayBoxX + 215, grayBoxY + 165, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(grayBoxX + 10, grayBoxY + 165, 90, 20, "prefab.gui.button.cancel");
    }

    public void checkVisualizationSetting() {
        if (!CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            this.btnVisualize.f_93624_ = false;
        }
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int x, int y, float f) {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        this.preButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        this.renderButtons(matrixStack, x, y);
        this.postButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        if (this.btnVisualize != null) {
            this.checkVisualizationSetting();
        }
    }

    @Override
    protected void preButtonRender(PoseStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawStandardControlBoxAndImage(matrixStack, this.structureImageLocation, x, y, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void postButtonRender(PoseStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
    }

    protected void performCancelOrBuildOrHouseFacing(StructureConfiguration configuration, AbstractButton button) {
        configuration.houseFacing = this.structureFacing;
        if (button == this.btnCancel) {
            this.closeScreen();
        } else if (button == this.btnBuild) {
            Prefab.network.sendToServer((Object)Utils.createStructureMessage(configuration.WriteToCompoundTag(), this.structureConfiguration));
            this.closeScreen();
        }
    }

    protected void performPreview(Structure structure, StructureConfiguration structureConfiguration) {
        StructureRenderHandler.setStructure(structure, Direction.NORTH, structureConfiguration);
        this.closeScreen();
    }
}

