/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.messages;

import com.wuest.prefab.proxy.messages.TagMessage;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.config.BulldozerConfiguration;
import com.wuest.prefab.structures.config.HouseConfiguration;
import com.wuest.prefab.structures.config.InstantBridgeConfiguration;
import com.wuest.prefab.structures.config.ModerateHouseConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class StructureTagMessage
extends TagMessage {
    private EnumStructureConfiguration structureConfig;

    public StructureTagMessage() {
    }

    public StructureTagMessage(CompoundTag tagMessage, EnumStructureConfiguration structureConfig) {
        super(tagMessage);
        this.structureConfig = structureConfig;
    }

    public static StructureTagMessage decode(FriendlyByteBuf buf) {
        CompoundTag tag = buf.m_130260_();
        StructureTagMessage returnValue = new StructureTagMessage();
        returnValue.structureConfig = EnumStructureConfiguration.getFromIdentifier(tag.m_128451_("config"));
        returnValue.tagMessage = tag.m_128469_("dataTag");
        return returnValue;
    }

    public static void encode(StructureTagMessage message, FriendlyByteBuf buf) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("config", message.structureConfig.identifier);
        tag.m_128365_("dataTag", (Tag)message.tagMessage);
        buf.m_130079_(tag);
    }

    EnumStructureConfiguration getStructureConfig() {
        return this.structureConfig;
    }

    public static enum EnumStructureConfiguration {
        Basic(0, new BasicStructureConfiguration()),
        StartHouse(1, new HouseConfiguration()),
        ModerateHouse(2, new ModerateHouseConfiguration()),
        Bulldozer(3, new BulldozerConfiguration()),
        InstantBridge(4, new InstantBridgeConfiguration());

        public int identifier;
        public StructureConfiguration structureConfig;

        private <T extends StructureConfiguration> EnumStructureConfiguration(int identifier, T structureConfig) {
            this.identifier = identifier;
            this.structureConfig = structureConfig;
        }

        public static EnumStructureConfiguration getFromIdentifier(int identifier) {
            for (EnumStructureConfiguration config : EnumStructureConfiguration.values()) {
                if (config.identifier != identifier) continue;
                return config;
            }
            return Basic;
        }

        public static EnumStructureConfiguration getByConfigurationInstance(StructureConfiguration structureConfig) {
            for (EnumStructureConfiguration configuration : EnumStructureConfiguration.values()) {
                if (!configuration.structureConfig.getClass().equals(structureConfig.getClass())) continue;
                return configuration;
            }
            return null;
        }
    }
}

