/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.proxy.messages.PlayerEntityTagMessage;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.BuildShape;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.PositionOffset;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.HouseConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fmllegacy.network.NetworkDirection;

public class StructureAlternateStart
extends Structure {
    private BlockPos chestPosition = null;
    private BlockPos furnacePosition = null;
    private BlockPos trapDoorPosition = null;
    private BlockPos signPosition = null;
    private ArrayList<Tuple<BlockPos, BlockPos>> bedPositions = new ArrayList();

    public static void ScanBasicHouseStructure(Level world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(10);
        clearedSpace.getShape().setLength(12);
        clearedSpace.getShape().setWidth(13);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(5);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        BlockPos corner = originalPos.m_142385_(5).m_142128_().m_7495_();
        BlockPos corner2 = originalPos.m_142386_(8).m_142383_(13).m_6630_(10);
        Structure.ScanStructure(world, originalPos, corner, corner2, "..\\src\\main\\resources\\assets\\prefab\\structures\\basic_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanRanchStructure(Level world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(7);
        clearedSpace.getShape().setLength(21);
        clearedSpace.getShape().setWidth(11);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        Structure.ScanStructure(world, originalPos, originalPos.m_142385_(8).m_142128_().m_7495_(), originalPos.m_142383_(22).m_142386_(3).m_6630_(8), "..\\src\\main\\resources\\assets\\prefab\\structures\\ranch_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanLoftStructure(Level world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(9);
        clearedSpace.getShape().setLength(13);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(7);
        Structure.ScanStructure(world, originalPos, originalPos.m_142385_(7).m_142128_(), originalPos.m_142383_(14).m_142386_(8).m_6630_(9), "..\\src\\main\\resources\\assets\\prefab\\structures\\loft_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanHobbitStructure(Level world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(12);
        clearedSpace.getShape().setLength(16);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-3);
        Structure.ScanStructure(world, originalPos, originalPos.m_142385_(8).m_142128_().m_6625_(3), originalPos.m_142383_(16).m_142386_(8).m_6630_(12), "..\\src\\main\\resources\\assets\\prefab\\structures\\hobbit_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanDesert2Structure(Level world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(10);
        clearedSpace.getShape().setLength(14);
        clearedSpace.getShape().setWidth(11);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        BlockPos corner = originalPos.m_142385_(8).m_142128_().m_7495_();
        BlockPos corner2 = originalPos.m_142386_(6).m_142383_(16).m_6630_(10);
        Structure.ScanStructure(world, originalPos, corner, corner2, "..\\src\\main\\resources\\assets\\prefab\\structures\\desert_house2.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanSubAquaticStructure(Level world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(13);
        clearedSpace.getShape().setLength(9);
        clearedSpace.getShape().setWidth(12);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        BlockPos corner = originalPos.m_142385_(8).m_142128_().m_7495_();
        BlockPos corner2 = originalPos.m_142386_(4).m_142383_(10).m_6630_(12);
        Structure.ScanStructure(world, originalPos, corner, corner2, "..\\src\\main\\resources\\assets\\prefab\\structures\\subaquatic_house.zip", clearedSpace, playerFacing, true, true);
    }

    public static void ScanStructure(Level world, BlockPos originalPos, Direction playerFacing, String structureFileName, boolean includeAir, boolean excludeWater) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(8);
        clearedSpace.getShape().setLength(16);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        BuildShape buildShape = clearedSpace.getShape();
        PositionOffset offset = clearedSpace.getStartingPosition();
        int downOffset = offset.getHeightOffset() < 0 ? Math.abs(offset.getHeightOffset()) : 0;
        BlockPos cornerPos = originalPos.m_142385_(offset.getEastOffset()).m_142383_(offset.getSouthOffset()).m_6625_(downOffset);
        Structure.ScanStructure(world, originalPos, cornerPos, cornerPos.m_142383_(buildShape.getLength()).m_142386_(buildShape.getWidth()).m_6630_(buildShape.getHeight()), "..\\src\\main\\resources\\assets\\prefab\\structures\\" + structureFileName + ".zip", clearedSpace, playerFacing, includeAir, excludeWater);
    }

    public static void ScanModernHouseStructure(Level world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(11);
        clearedSpace.getShape().setLength(18);
        clearedSpace.getShape().setWidth(14);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(4);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        BlockPos corner = originalPos.m_142385_(4).m_142128_().m_7495_();
        BlockPos corner2 = originalPos.m_142386_(9).m_142383_(19).m_6630_(11);
        Structure.ScanStructure(world, originalPos, corner, corner2, "..\\src\\main\\resources\\assets\\prefab\\structures\\modern_starting_house.zip", clearedSpace, playerFacing, false, false);
    }

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, Level world, BlockPos originalPos, Direction assumedNorth, Block foundBlock, BlockState blockState, Player player) {
        HouseConfiguration houseConfig = (HouseConfiguration)configuration;
        if (!houseConfig.addBed && foundBlock instanceof BedBlock || !houseConfig.addChest && foundBlock instanceof ChestBlock || !houseConfig.addTorches && foundBlock instanceof TorchBlock || !houseConfig.addCraftingTable && foundBlock instanceof CraftingTableBlock || !houseConfig.addFurnace && foundBlock instanceof FurnaceBlock || !houseConfig.addChest && foundBlock instanceof BarrelBlock || foundBlock instanceof SeagrassBlock || foundBlock instanceof TallSeagrassBlock) {
            return true;
        }
        if (foundBlock instanceof FurnaceBlock) {
            this.furnacePosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof TrapDoorBlock && houseConfig.addMineShaft && this.trapDoorPosition == null) {
            this.trapDoorPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof ChestBlock && this.chestPosition == null || foundBlock instanceof BarrelBlock && this.chestPosition == null) {
            this.chestPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof StandingSignBlock) {
            this.signPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock == Blocks.f_50056_ && houseConfig.addMineShaft) {
            this.trapDoorPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing).m_7494_();
        } else if (foundBlock instanceof BedBlock && houseConfig.addBed) {
            BlockPos bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            BlockPos bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            this.bedPositions.add(new Tuple<BlockPos, BlockPos>(bedHeadPosition, bedFootPosition));
            return true;
        }
        if (foundBlock.getRegistryName().m_135827_().equals(Blocks.f_50147_.getRegistryName().m_135827_()) && foundBlock.getRegistryName().m_135815_().endsWith("stained_glass")) {
            blockState = this.getStainedGlassBlock(houseConfig.glassColor);
            block.setBlockState(blockState);
            this.priorityOneBlocks.add(block);
            return true;
        }
        if (foundBlock.getRegistryName().m_135827_().equals(Blocks.f_50303_.getRegistryName().m_135827_()) && foundBlock.getRegistryName().m_135815_().endsWith("stained_glass_pane")) {
            blockState = this.getStainedGlassPaneBlock(houseConfig.glassColor);
            BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState, this);
            this.priorityOneBlocks.add(block);
            return true;
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, ServerLevel world, BlockPos originalPos, Direction assumedNorth, Player player) {
        BlockEntity tileEntity;
        HouseConfiguration houseConfig = (HouseConfiguration)configuration;
        EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntityData(player);
        ArrayList<BlockPos> furnacePositions = new ArrayList<BlockPos>();
        if (this.furnacePosition != null) {
            furnacePositions.add(this.furnacePosition);
        }
        BuildingMethods.FillFurnaces((Level)world, furnacePositions);
        if (this.chestPosition != null && houseConfig.addChestContents) {
            BuildingMethods.FillChest((Level)world, this.chestPosition);
        }
        if (this.trapDoorPosition != null && this.trapDoorPosition.m_123342_() > 15 && houseConfig.addMineShaft) {
            BuildingMethods.PlaceMineShaft(world, this.trapDoorPosition.m_7495_(), houseConfig.houseFacing, false);
        }
        if (this.signPosition != null && (tileEntity = world.m_7702_(this.signPosition)) instanceof SignBlockEntity) {
            SignBlockEntity signTile = (SignBlockEntity)tileEntity;
            signTile.m_59732_(0, (Component)Utils.createTextComponent("This is"));
            if (player.m_5446_().getString().length() >= 15) {
                signTile.m_59732_(1, (Component)Utils.createTextComponent(player.m_5446_().getString()));
            } else {
                signTile.m_59732_(1, (Component)Utils.createTextComponent(player.m_5446_().getString() + "'s"));
            }
            signTile.m_59732_(2, (Component)Utils.createTextComponent("house!"));
        }
        if (this.bedPositions.size() > 0 && houseConfig.addBed) {
            for (Tuple<BlockPos, BlockPos> bedPosition : this.bedPositions) {
                BuildingMethods.PlaceColoredBed((Level)world, bedPosition.getFirst(), bedPosition.getSecond(), houseConfig.bedColor);
            }
        }
        playerConfig.builtStarterHouse = true;
        playerConfig.saveToPlayer(player);
        Prefab.network.sendTo((Object)new PlayerEntityTagMessage(playerConfig.getModIsPlayerNewTag(player)), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

