/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.config.enums.BaseOption;
import com.wuest.prefab.structures.config.enums.ModerateFarmOptions;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class StructureBasic
extends Structure {
    private BlockPos customBlockPos = null;
    private ArrayList<Tuple<BlockPos, BlockPos>> bedPositions = new ArrayList();

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, Level world, BlockPos originalPos, Direction assumedNorth, Block foundBlock, BlockState blockState, Player player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        String structureName = config.basicStructureName.getName();
        BaseOption chosenOption = config.chosenOption;
        if (foundBlock instanceof HopperBlock && structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.ModerateFarm.getName()) && chosenOption == ModerateFarmOptions.AutomatedChickenCoop) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof TrapDoorBlock && structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock == Blocks.f_50056_ && structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.WorkShop.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing).m_7494_();
        } else {
            if (foundBlock instanceof BedBlock && chosenOption.getHasBedColor()) {
                BlockPos bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                BlockPos bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                this.bedPositions.add(new Tuple<BlockPos, BlockPos>(bedHeadPosition, bedFootPosition));
                return true;
            }
            if (foundBlock.getRegistryName().m_135827_().equals(Blocks.f_50147_.getRegistryName().m_135827_()) && foundBlock.getRegistryName().m_135815_().endsWith("glass") && config.chosenOption.getHasGlassColor()) {
                blockState = this.getStainedGlassBlock(config.glassColor);
                block.setBlockState(blockState);
                this.priorityOneBlocks.add(block);
                return true;
            }
            if (foundBlock.getRegistryName().m_135827_().equals(Blocks.f_50303_.getRegistryName().m_135827_()) && foundBlock.getRegistryName().m_135815_().endsWith("glass_pane") && config.chosenOption.getHasGlassColor()) {
                blockState = this.getStainedGlassPaneBlock(config.glassColor);
                BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState, this);
                this.priorityOneBlocks.add(block);
                return true;
            }
        }
        return false;
    }

    @Override
    protected Boolean BlockShouldBeClearedDuringConstruction(StructureConfiguration configuration, Level world, BlockPos originalPos, Direction assumedNorth, BlockPos blockPos) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName()) || config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AdvancedAquaBase.getName())) {
            BlockState blockState = world.m_8055_(blockPos);
            return blockState.m_60767_() != Material.f_76305_;
        }
        return true;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, ServerLevel world, BlockPos originalPos, Direction assumedNorth, Player player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        String structureName = config.basicStructureName.getName();
        BaseOption chosenOption = config.chosenOption;
        if (this.customBlockPos != null) {
            if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.ModerateFarm.getName()) && chosenOption == ModerateFarmOptions.AutomatedChickenCoop) {
                for (int i = 0; i < 4; ++i) {
                    Chicken entity = new Chicken(EntityType.f_20555_, (Level)world);
                    entity.m_6034_((double)this.customBlockPos.m_123341_(), (double)this.customBlockPos.m_7494_().m_123342_(), (double)this.customBlockPos.m_123343_());
                    world.m_7967_((Entity)entity);
                }
            } else if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName()) || structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.WorkShop.getName())) {
                BuildingMethods.PlaceMineShaft(world, this.customBlockPos.m_7495_(), configuration.houseFacing, true);
            }
            this.customBlockPos = null;
        }
        if (this.bedPositions.size() > 0) {
            for (Tuple<BlockPos, BlockPos> bedPosition : this.bedPositions) {
                BuildingMethods.PlaceColoredBed((Level)world, bedPosition.getFirst(), bedPosition.getSecond(), config.bedColor);
            }
        }
        if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName()) || structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.AdvancedAquaBase.getName())) {
            BlockPos airPos = originalPos.m_6630_(4).m_5484_(configuration.houseFacing.m_122424_(), 1);
            world.m_7471_(airPos.m_142300_(configuration.houseFacing.m_122427_()), false);
            world.m_7471_(airPos, false);
            world.m_7471_(airPos.m_142300_(configuration.houseFacing.m_122428_()), false);
            airPos = airPos.m_7495_();
            world.m_7471_(airPos.m_142300_(configuration.houseFacing.m_122427_()), false);
            world.m_7471_(airPos, false);
            world.m_7471_(airPos.m_142300_(configuration.houseFacing.m_122428_()), false);
            airPos = airPos.m_7495_();
            world.m_7471_(airPos.m_142300_(configuration.houseFacing.m_122427_()), false);
            world.m_7471_(airPos, false);
            world.m_7471_(airPos.m_142300_(configuration.houseFacing.m_122428_()), false);
            airPos = airPos.m_7495_();
            world.m_7471_(airPos.m_142300_(configuration.houseFacing.m_122427_()), false);
            world.m_7471_(airPos, false);
            world.m_7471_(airPos.m_142300_(configuration.houseFacing.m_122428_()), false);
            airPos = airPos.m_142300_(configuration.houseFacing.m_122424_()).m_7494_();
            world.m_7471_(airPos.m_142300_(configuration.houseFacing.m_122427_()), false);
            world.m_7471_(airPos, false);
            world.m_7471_(airPos.m_142300_(configuration.houseFacing.m_122428_()), false);
            airPos = airPos.m_7494_();
            world.m_7471_(airPos.m_142300_(configuration.houseFacing.m_122427_()), false);
            world.m_7471_(airPos, false);
            world.m_7471_(airPos.m_142300_(configuration.houseFacing.m_122428_()), false);
            airPos = airPos.m_7494_();
            world.m_7471_(airPos, false);
        }
    }
}

