/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.InstantBridgeConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class StructureInstantBridge
extends Structure {
    public static StructureInstantBridge CreateInstance() {
        return new StructureInstantBridge();
    }

    @Override
    public boolean BuildStructure(StructureConfiguration configuration, ServerLevel world, BlockPos originalPos, Direction assumedNorth, Player player) {
        InstantBridgeConfiguration specificConfig = (InstantBridgeConfiguration)configuration;
        this.setupClearSpace(specificConfig);
        this.setupStructure(specificConfig, originalPos);
        return super.BuildStructure(specificConfig, world, originalPos, assumedNorth, player);
    }

    public void setupStructure(InstantBridgeConfiguration configuration, BlockPos originalPos) {
        ArrayList<BuildBlock> buildingBlocks = new ArrayList<BuildBlock>();
        BlockState materialState = configuration.bridgeMaterial.getBlockType();
        Direction facing = Direction.SOUTH;
        BlockState torchState = Blocks.f_50081_.m_49966_();
        BlockState glassState = Blocks.f_50185_.m_49966_();
        int interiorHeightOffSet = configuration.interiorHeight - 3;
        for (int i = 1; i <= configuration.bridgeLength; ++i) {
            BlockPos currentPos = originalPos.m_5484_(facing, i);
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.m_60734_(), currentPos.m_5484_(facing.m_122428_(), 2), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.m_60734_(), currentPos.m_142300_(facing.m_122428_()), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.m_60734_(), currentPos, originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.m_60734_(), currentPos.m_142300_(facing.m_122427_()), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.m_60734_(), currentPos.m_5484_(facing.m_122427_(), 2), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.m_60734_(), currentPos.m_5484_(facing.m_122428_(), 2).m_7494_(), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.m_60734_(), currentPos.m_5484_(facing.m_122427_(), 2).m_7494_(), originalPos));
            if (configuration.includeRoof) {
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.m_60734_(), currentPos.m_5484_(facing.m_122428_(), 2).m_6630_(3 + interiorHeightOffSet), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.m_60734_(), currentPos.m_142300_(facing.m_122428_()).m_6630_(4 + interiorHeightOffSet), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.m_60734_(), currentPos.m_6630_(4 + interiorHeightOffSet), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.m_60734_(), currentPos.m_142300_(facing.m_122427_()).m_6630_(4 + interiorHeightOffSet), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.m_60734_(), currentPos.m_5484_(facing.m_122427_(), 2).m_6630_(3 + interiorHeightOffSet), originalPos));
            }
            for (int j = 0; j <= interiorHeightOffSet; ++j) {
                if ((i == 1 || i % 6 == 0) && j == 0) {
                    buildingBlocks.add(Structure.createBuildBlockFromBlockState(torchState, torchState.m_60734_(), currentPos.m_5484_(facing.m_122428_(), 2).m_6630_(2), originalPos));
                    buildingBlocks.add(Structure.createBuildBlockFromBlockState(torchState, torchState.m_60734_(), currentPos.m_5484_(facing.m_122427_(), 2).m_6630_(2), originalPos));
                    continue;
                }
                if (!configuration.includeRoof) continue;
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(glassState, glassState.m_60734_(), currentPos.m_5484_(facing.m_122428_(), 2).m_6630_(2 + j), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(glassState, glassState.m_60734_(), currentPos.m_5484_(facing.m_122427_(), 2).m_6630_(2 + j), originalPos));
            }
        }
        this.setBlocks(buildingBlocks);
    }

    private void setupClearSpace(InstantBridgeConfiguration configuration) {
        int clearHeight = 3;
        if (configuration.includeRoof) {
            clearHeight = configuration.interiorHeight - clearHeight + clearHeight + 2;
        }
        BuildClear clear = new BuildClear();
        clear.getStartingPosition().setSouthOffset(1);
        clear.getStartingPosition().setEastOffset(2);
        clear.getShape().setDirection(Direction.SOUTH);
        clear.getShape().setHeight(clearHeight - 1);
        clear.getShape().setWidth(5);
        clear.getShape().setLength(configuration.bridgeLength);
        this.setClearSpace(clear);
    }
}

