/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.blocks.BlockStructureScanner;
import com.wuest.prefab.config.StructureScannerConfig;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.render.TranslucentVertexConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class StructureRenderHandler {
    public static StructureConfiguration currentConfiguration;
    public static Structure currentStructure;
    public static Direction assumedNorth;
    public static boolean rendering;
    public static boolean showedMessage;
    private static int dimension;
    private static int overlay;

    public static void setStructure(Structure structure, Direction assumedNorth, StructureConfiguration configuration) {
        currentStructure = structure;
        StructureRenderHandler.assumedNorth = assumedNorth;
        currentConfiguration = configuration;
        showedMessage = false;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            dimension = mc.f_91073_.m_6042_().m_63964_();
        }
    }

    public static void renderPlayerLook(Player player, HitResult src, PoseStack matrixStack) {
        if (currentStructure != null && dimension == player.f_19853_.m_6042_().m_63964_() && currentConfiguration != null && CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            rendering = true;
            MultiBufferSource.BufferSource entityVertexConsumer = Minecraft.m_91087_().m_91269_().m_110104_();
            Frustum frustum = new Frustum(matrixStack.m_85850_().m_85861_(), RenderSystem.m_157192_());
            BlockPos cameraPos = player.m_146901_();
            frustum.m_113002_((double)cameraPos.m_123341_(), (double)cameraPos.m_123342_(), (double)cameraPos.m_123343_());
            for (BuildBlock buildBlock : currentStructure.getBlocks()) {
                BlockPos pos;
                AABB box;
                Block foundBlock = (Block)Registry.f_122824_.m_7745_(buildBlock.getResourceLocation());
                if (foundBlock == null || !frustum.m_113029_(box = new AABB((double)(pos = buildBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing)).m_123341_() - 0.5, (double)pos.m_123342_() - 0.5, (double)pos.m_123343_() - 0.5, (double)pos.m_123341_() + 1.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 1.5))) continue;
                BlockState blockState = foundBlock.m_49966_();
                buildBlock = BuildBlock.SetBlockState(currentConfiguration, player.f_19853_, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock, foundBlock, blockState, currentStructure);
                StructureRenderHandler.renderComponentInWorld(player.f_19853_, buildBlock, entityVertexConsumer, matrixStack, pos);
            }
            entityVertexConsumer.m_109912_(Sheets.m_110791_());
            if (!showedMessage) {
                TranslatableComponent message = new TranslatableComponent("prefab.gui.preview.notice");
                message.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN));
                player.m_6352_((Component)message, player.m_142081_());
                message = new TranslatableComponent("prefab.gui.structure.block.clicked");
                message.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
                player.m_6352_((Component)message, player.m_142081_());
                showedMessage = true;
            }
        }
    }

    private static boolean renderComponentInWorld(Level world, BuildBlock buildBlock, MultiBufferSource.BufferSource entityVertexConsumer, PoseStack matrixStack, BlockPos pos) {
        BlockState targetBlock = world.m_8055_(pos);
        if (targetBlock.m_60767_() != Material.f_76296_ && targetBlock.m_60767_() != Material.f_76305_) {
            return false;
        }
        StructureRenderHandler.doRenderComponent(world, buildBlock, pos, entityVertexConsumer, matrixStack);
        if (buildBlock.getSubBlock() != null) {
            Block foundBlock = (Block)Registry.f_122824_.m_7745_(buildBlock.getSubBlock().getResourceLocation());
            BlockState blockState = foundBlock.m_49966_();
            BuildBlock subBlock = BuildBlock.SetBlockState(currentConfiguration, world, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock.getSubBlock(), foundBlock, blockState, currentStructure);
            BlockPos subBlockPos = subBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
            RenderShape subBlockRenderType = subBlock.getBlockState().m_60799_();
            return StructureRenderHandler.renderComponentInWorld(world, subBlock, entityVertexConsumer, matrixStack, subBlockPos);
        }
        return true;
    }

    private static void doRenderComponent(Level world, BuildBlock buildBlock, BlockPos pos, MultiBufferSource.BufferSource entityVertexConsumer, PoseStack matrixStack) {
        BlockState state = buildBlock.getBlockState();
        StructureRenderHandler.renderBlock(world, matrixStack, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), state, entityVertexConsumer, pos);
    }

    private static void renderBlock(Level world, PoseStack matrixStack, Vec3 pos, BlockState state, MultiBufferSource.BufferSource entityVertexConsumer, BlockPos blockPos) {
        Minecraft minecraft = Minecraft.m_91087_();
        Camera camera = minecraft.m_91290_().f_114358_;
        Vec3 projectedView = camera.m_90583_();
        if (state.m_60799_() != RenderShape.INVISIBLE && state.m_60799_() == RenderShape.MODEL) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(-projectedView.m_7096_(), -projectedView.m_7098_(), -projectedView.m_7094_());
            matrixStack.m_85837_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            BlockRenderDispatcher renderer = minecraft.m_91289_();
            VertexConsumer consumer = entityVertexConsumer.m_6299_(Sheets.m_110791_());
            TranslucentVertexConsumer translucentConsumer = new TranslucentVertexConsumer(consumer, 100);
            int color = minecraft.m_91298_().m_92577_(state, (BlockAndTintGetter)world, blockPos, 50);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            renderer.m_110937_().m_111067_(matrixStack.m_85850_(), (VertexConsumer)translucentConsumer, state, renderer.m_110910_(state), r, g, b, 0xF000F0, OverlayTexture.f_118083_);
            matrixStack.m_85849_();
        }
    }

    public static void renderClickedBlock(Level worldIn, PoseStack matrixStack, double cameraX, double cameraY, double cameraZ) {
        if (currentStructure != null && dimension == Minecraft.m_91087_().f_91074_.f_19853_.m_6042_().m_63964_() && currentConfiguration != null && CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            BlockPos originalPos = StructureRenderHandler.currentConfiguration.pos.m_7494_();
            double blockXOffset = originalPos.m_123341_();
            double blockZOffset = originalPos.m_123343_();
            double blockStartYOffset = originalPos.m_123342_();
            StructureRenderHandler.drawBox(matrixStack, blockXOffset, blockZOffset, blockStartYOffset, cameraX, cameraY, cameraZ, 1, 1, 1);
        }
    }

    private static void drawBox(PoseStack matrixStack, double blockXOffset, double blockZOffset, double blockStartYOffset, double cameraX, double cameraY, double cameraZ, int xLength, int zLength, int height) {
        RenderSystem.m_69482_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.m_69472_();
        RenderSystem.m_69461_();
        double translatedX = blockXOffset - cameraX;
        double translatedY = blockStartYOffset - cameraY + 0.02;
        double translatedYEnd = translatedY + (double)height - 0.02;
        double translatedZ = blockZOffset - cameraZ;
        RenderSystem.m_69832_((float)2.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_(translatedX, translatedY, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX, translatedYEnd, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_(translatedX + (double)xLength, translatedY, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX + (double)xLength, translatedYEnd, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_(translatedX, translatedY, translatedZ + (double)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX, translatedYEnd, translatedZ + (double)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_(translatedX + (double)xLength, translatedY, translatedZ + (double)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX + (double)xLength, translatedYEnd, translatedZ + (double)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_(translatedX, translatedY, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX, translatedY, translatedZ + (double)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX + (double)xLength, translatedY, translatedZ + (double)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX + (double)xLength, translatedY, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX, translatedY, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX + (double)xLength, translatedY, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX + (double)xLength, translatedY, translatedZ + (double)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX, translatedY, translatedZ + (double)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_(translatedX, translatedYEnd, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX, translatedYEnd, translatedZ + (double)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX + (double)xLength, translatedYEnd, translatedZ + (double)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX + (double)xLength, translatedYEnd, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX, translatedYEnd, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX + (double)xLength, translatedYEnd, translatedZ).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX + (double)xLength, translatedYEnd, translatedZ + (double)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(translatedX, translatedYEnd, translatedZ + (double)zLength).m_85950_(1.0f, 1.0f, 0.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69832_((float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69493_();
    }

    public static void renderScanningBoxes(PoseStack matrixStack, double cameraX, double cameraY, double cameraZ) {
        for (int i = 0; i < Prefab.proxy.structureScanners.size(); ++i) {
            StructureScannerConfig config = Prefab.proxy.structureScanners.get(i);
            BlockPos pos = config.blockPos;
            boolean removeConfig = false;
            boolean bl = removeConfig = pos == null;
            if (pos != null) {
                boolean bl2 = removeConfig = !(Minecraft.m_91087_().f_91073_.m_8055_(pos).m_60734_() instanceof BlockStructureScanner);
            }
            if (removeConfig) {
                Prefab.proxy.structureScanners.remove(i);
                --i;
                continue;
            }
            Direction leftDirection = config.direction.m_122428_();
            BlockPos startingPosition = config.blockPos.m_5484_(leftDirection, config.blocksToTheLeft).m_5484_(Direction.DOWN, config.blocksDown).m_5484_(config.direction, config.blocksParallel);
            int xLength = config.blocksWide;
            int zLength = config.blocksLong;
            switch (config.direction) {
                case NORTH: {
                    zLength = -zLength;
                    startingPosition = startingPosition.m_142300_(config.direction.m_122424_());
                    break;
                }
                case EAST: {
                    int tempWidth = xLength;
                    xLength = zLength;
                    zLength = tempWidth;
                    break;
                }
                case SOUTH: {
                    xLength = -xLength;
                    startingPosition = startingPosition.m_142300_(config.direction.m_122428_());
                    break;
                }
                case WEST: {
                    int tempLength = zLength;
                    zLength = -xLength;
                    xLength = -tempLength;
                    startingPosition = startingPosition.m_142300_(config.direction.m_122424_());
                    startingPosition = startingPosition.m_142300_(config.direction.m_122428_());
                    break;
                }
            }
            StructureRenderHandler.drawBox(matrixStack, startingPosition.m_123341_(), startingPosition.m_123343_(), startingPosition.m_123342_(), cameraX, cameraY, cameraZ, xLength, zLength, config.blocksTall);
        }
    }

    static {
        rendering = false;
        showedMessage = false;
        overlay = OverlayTexture.m_118093_((int)5, (int)10);
    }
}

