/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.config;

import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.HashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class EntityPlayerConfiguration {
    public static final String PLAYER_ENTITY_TAG = "IsPlayerNew";
    private static final String GIVEN_HOUSEBUILDER_TAG = "givenHousebuilder";
    private static final String Built_Starter_house_Tag = "builtStarterHouse";
    public boolean givenHouseBuilder = false;
    public boolean builtStarterHouse = false;
    private final HashMap<String, StructureConfiguration> clientConfigurations = new HashMap();

    public static EntityPlayerConfiguration loadFromEntityData(PlayerEntity player) {
        EntityPlayerConfiguration config = new EntityPlayerConfiguration();
        CompoundNBT compoundTag = config.getModIsPlayerNewTag(player);
        config.loadFromNBTTagCompound(compoundTag);
        return config;
    }

    public void loadFromNBTTagCompound(CompoundNBT tag) {
        this.givenHouseBuilder = tag.func_74767_n(GIVEN_HOUSEBUILDER_TAG);
        this.builtStarterHouse = tag.func_74767_n(Built_Starter_house_Tag);
    }

    public CompoundNBT getModIsPlayerNewTag(PlayerEntity player) {
        CompoundNBT newPlayerTag;
        CompoundNBT tag = player.getPersistentData();
        if (tag.func_74764_b(PLAYER_ENTITY_TAG)) {
            newPlayerTag = tag.func_74775_l(PLAYER_ENTITY_TAG);
        } else {
            newPlayerTag = new CompoundNBT();
            tag.func_218657_a(PLAYER_ENTITY_TAG, (INBT)newPlayerTag);
        }
        return newPlayerTag;
    }

    public void saveToPlayer(PlayerEntity player) {
        CompoundNBT compoundTag = this.getModIsPlayerNewTag(player);
        compoundTag.func_74757_a(Built_Starter_house_Tag, this.builtStarterHouse);
        compoundTag.func_74757_a(GIVEN_HOUSEBUILDER_TAG, this.givenHouseBuilder);
    }

    public <T extends StructureConfiguration> T getClientConfig(String guiName, Class<T> structureConfiguration) {
        StructureConfiguration config = this.clientConfigurations.get(guiName);
        if (config == null) {
            try {
                config = (StructureConfiguration)structureConfiguration.newInstance();
                this.clientConfigurations.put(guiName, config);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return (T)config;
    }

    public void clearNonPersistedObjects() {
        this.clientConfigurations.clear();
    }
}

