/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.events;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.proxy.ClientProxy;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.items.ItemBasicStructure;
import com.wuest.prefab.structures.items.StructureItem;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.render.StructureRenderHandler;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="prefab", value={Dist.CLIENT})
public final class ClientEventHandler {
    public static ClientEventHandler instance = new ClientEventHandler();
    public static int ticksInGame;
    public static EntityPlayerConfiguration playerConfig;
    public static ArrayList<KeyBinding> keyBindings;

    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && !mc.field_71439_g.func_213453_ef()) {
            StructureRenderHandler.renderPlayerLook((PlayerEntity)mc.field_71439_g, mc.field_71476_x, event.getMatrixStack());
        }
    }

    @SubscribeEvent
    public static void EntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() instanceof PlayerEntity) {
            ((ClientProxy)Prefab.proxy).serverConfiguration = null;
            playerConfig.clearNonPersistedObjects();
        }
    }

    @SubscribeEvent
    public static void ClientTickEnd(TickEvent.ClientTickEvent event) {
        Screen gui;
        if (!(event.phase != TickEvent.Phase.END || (gui = Minecraft.func_71410_x().field_71462_r) != null && gui.func_231177_au__())) {
            if (2147483547 == ticksInGame) {
                ticksInGame = 1;
            }
            ++ticksInGame;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    @OnlyIn(value=Dist.CLIENT)
    public static void KeyInput(InputEvent.KeyInputEvent event) {
        for (KeyBinding binding : keyBindings) {
            if (!binding.func_151470_d()) continue;
            if (StructureRenderHandler.currentStructure == null) break;
            ItemStack mainHandStack = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
            ItemStack offHandStack = Minecraft.func_71410_x().field_71439_g.func_184592_cb();
            boolean foundCorrectStructureItem = false;
            if (mainHandStack != ItemStack.field_190927_a || offHandStack != ItemStack.field_190927_a) {
                StructureTagMessage.EnumStructureConfiguration structureConfigurationEnum = StructureTagMessage.EnumStructureConfiguration.getByConfigurationInstance(StructureRenderHandler.currentConfiguration);
                if (mainHandStack != ItemStack.field_190927_a && mainHandStack.func_77973_b() instanceof StructureItem) {
                    foundCorrectStructureItem = ClientEventHandler.checkIfStackIsCorrectGui(structureConfigurationEnum, mainHandStack);
                }
                if (!foundCorrectStructureItem && offHandStack != ItemStack.field_190927_a && offHandStack.func_77973_b() instanceof StructureItem) {
                    foundCorrectStructureItem = ClientEventHandler.checkIfStackIsCorrectGui(structureConfigurationEnum, offHandStack);
                }
            }
            if (foundCorrectStructureItem) {
                Prefab.network.sendToServer((Object)new StructureTagMessage(StructureRenderHandler.currentConfiguration.WriteToCompoundNBT(), StructureTagMessage.EnumStructureConfiguration.getByConfigurationInstance(StructureRenderHandler.currentConfiguration)));
            }
            StructureRenderHandler.currentStructure = null;
            break;
        }
    }

    public static boolean checkIfStackIsCorrectGui(StructureTagMessage.EnumStructureConfiguration currentConfiguration, ItemStack stack) {
        GuiStructure mainHandGui = ClientProxy.ModGuis.get(stack.func_77973_b());
        mainHandGui.func_231160_c_();
        if (currentConfiguration == mainHandGui.structureConfiguration) {
            if (currentConfiguration == StructureTagMessage.EnumStructureConfiguration.Basic) {
                ItemBasicStructure item = (ItemBasicStructure)stack.func_77973_b();
                BasicStructureConfiguration.EnumBasicStructureName basicStructureName = ((BasicStructureConfiguration)StructureRenderHandler.currentConfiguration).basicStructureName;
                return item.structureType == basicStructureName;
            }
            return true;
        }
        return false;
    }

    static {
        playerConfig = new EntityPlayerConfiguration();
        keyBindings = new ArrayList();
    }
}

