/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.CustomButton;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.gui.controls.GuiCheckBox;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.DyeColor;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public abstract class GuiBase
extends Screen {
    private final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/default_background.png");
    private final ResourceLocation narrowPanelTexture = new ResourceLocation("prefab", "textures/gui/custom_background.png");
    private final ResourceLocation leftPanelTexture = new ResourceLocation("prefab", "textures/gui/custom_left_panel.png");
    private final ResourceLocation middlePanelTexture = new ResourceLocation("prefab", "textures/gui/custom_middle_panel.png");
    private final ResourceLocation rightPanelTexture = new ResourceLocation("prefab", "textures/gui/custom_right_panel.png");
    protected int modifiedInitialXAxis = 213;
    protected int modifiedInitialYAxis = 83;
    protected int imagePanelWidth = 0;
    protected int imagePanelHeight = 0;
    protected int shownImageHeight = 0;
    protected int shownImageWidth = 0;
    private boolean pauseGame = true;
    protected int textColor = Color.DARK_GRAY.getRGB();

    public GuiBase(String title) {
        super((ITextComponent)Utils.createTextComponent(title));
    }

    public void func_231160_c_() {
        this.Initialize();
    }

    protected void Initialize() {
        this.modifiedInitialXAxis = 160;
        this.modifiedInitialYAxis = 120;
        this.imagePanelWidth = 325;
        this.imagePanelHeight = 300;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
    }

    protected int getCenteredXAxis() {
        return this.field_230708_k_ / 2;
    }

    protected int getCenteredYAxis() {
        return this.field_230709_l_ / 2;
    }

    public boolean func_231177_au__() {
        return this.pauseGame;
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float f) {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        this.preButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        this.renderButtons(matrixStack, x, y);
        this.postButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text) {
        return this.createAndAddButton(x, y, width, height, text, true);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text, boolean translate) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (ITextComponent)(translate ? GuiLangKeys.translateToComponent(text) : Utils.createTextComponent(text)), this::buttonClicked);
        this.func_230480_a_((Widget)returnValue);
        return returnValue;
    }

    public CustomButton createAndAddCustomButton(int x, int y, int width, int height, String text) {
        return this.createAndAddCustomButton(x, y, width, height, text, true);
    }

    public CustomButton createAndAddCustomButton(int x, int y, int width, int height, String text, boolean translate) {
        CustomButton returnValue = new CustomButton(x, y, width, height, (ITextComponent)(translate ? GuiLangKeys.translateToComponent(text) : Utils.createTextComponent(text)), this::buttonClicked);
        return (CustomButton)this.func_230480_a_((Widget)returnValue);
    }

    public ExtendedButton createAndAddDyeButton(int x, int y, int width, int height, DyeColor color) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (ITextComponent)Utils.createTextComponent(GuiLangKeys.translateDye(color)), this::buttonClicked);
        this.func_230480_a_((Widget)returnValue);
        return returnValue;
    }

    public ExtendedButton createAndAddFullDyeButton(int x, int y, int width, int height, FullDyeColor color) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (ITextComponent)Utils.createTextComponent(GuiLangKeys.translateFullDye(color)), this::buttonClicked);
        this.func_230480_a_((Widget)returnValue);
        return returnValue;
    }

    public GuiCheckBox createAndAddCheckBox(int xPos, int yPos, String displayString, boolean isChecked, GuiCheckBox.IPressable handler) {
        GuiCheckBox checkBox = new GuiCheckBox(xPos, yPos, GuiLangKeys.translateString(displayString), isChecked, handler);
        this.func_230480_a_((Widget)checkBox);
        return checkBox;
    }

    public Slider createAndAddSlider(int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, Button.IPressable handler) {
        Slider slider = new Slider(xPos, yPos, width, height, (ITextComponent)Utils.createTextComponent(prefix), (ITextComponent)Utils.createTextComponent(suf), minVal, maxVal, currentVal, showDec, drawStr, handler);
        this.func_230480_a_((Widget)slider);
        return slider;
    }

    protected void drawControlBackground(MatrixStack matrixStack, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.bindAndDrawScaledTexture(this.backgroundTextures, matrixStack, grayBoxX, grayBoxY, width, height, width, height, width, height);
    }

    protected void drawControlLeftPanel(MatrixStack matrixStack, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.leftPanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawControlMiddlePanel(MatrixStack matrixStack, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.middlePanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawControlRightPanel(MatrixStack matrixStack, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.rightPanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawStandardControlBoxAndImage(MatrixStack matrixStack, ResourceLocation imageLocation, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.drawControlBackground(matrixStack, x, y, this.imagePanelWidth, this.imagePanelHeight);
        if (imageLocation != null) {
            int imagePanelMiddle = this.imagePanelWidth / 2;
            int middleOfImage = this.shownImageWidth / 2;
            int imagePos = x + (imagePanelMiddle - middleOfImage - 5);
            GuiUtils.bindAndDrawTexture(imageLocation, matrixStack, imagePos, y + 10, 1, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight);
        }
    }

    protected void renderButtons(MatrixStack matrixStack, int mouseX, int mouseY) {
        for (Widget widget : this.field_230710_m_) {
            if (!widget.field_230694_p_) continue;
            widget.func_230431_b_(matrixStack, mouseX, mouseY, this.getMinecraft().func_184121_ak());
        }
    }

    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - this.modifiedInitialXAxis, this.getCenteredYAxis() - this.modifiedInitialYAxis);
    }

    public int drawString(MatrixStack matrixStack, String text, float x, float y, int color) {
        return this.getFontRenderer().func_238421_b_(matrixStack, text, x, y, color);
    }

    public void drawSplitString(String str, int x, int y, int wrapWidth, int textColor) {
        this.getFontRenderer().func_238418_a_((ITextProperties)Utils.createTextComponent(str), x, y, wrapWidth, textColor);
    }

    public List<IReorderingProcessor> getSplitString(String str, int wrapWidth) {
        return this.getFontRenderer().func_238425_b_((ITextProperties)Utils.createTextComponent(str), wrapWidth);
    }

    public List<IReorderingProcessor> getSplitString(StringTextComponent str, int wrapWidth) {
        return this.getFontRenderer().func_238425_b_((ITextProperties)str, wrapWidth);
    }

    public void closeScreen() {
        this.getMinecraft().func_147108_a(null);
    }

    public Minecraft getMinecraft() {
        return this.field_230706_i_;
    }

    public FontRenderer getFontRenderer() {
        return this.getMinecraft().field_71466_p;
    }

    public abstract void buttonClicked(AbstractButton var1);

    protected abstract void preButtonRender(MatrixStack var1, int var2, int var3, int var4, int var5, float var6);

    protected abstract void postButtonRender(MatrixStack var1, int var2, int var3, int var4, int var5, float var6);
}

