/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Quadruple;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.config.ConfigCategory;
import com.wuest.prefab.config.ConfigOption;
import com.wuest.prefab.config.ModConfiguration;
import com.wuest.prefab.gui.GuiBase;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IBidiTooltip;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.gui.widget.list.OptionsRowList;
import net.minecraft.client.settings.BooleanOption;
import net.minecraft.client.settings.IteratableOption;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.util.IReorderingProcessor;

public class GuiPrefab
extends GuiBase {
    private static final int TITLE_HEIGHT = 8;
    private static final int OPTIONS_LIST_TOP_HEIGHT = 55;
    private static final int OPTIONS_LIST_BOTTOM_OFFSET = 32;
    private static final int OPTIONS_LIST_ITEM_HEIGHT = 25;
    private static final int DONE_BUTTON_TOP_OFFSET = 26;
    private final Screen parentScreen;
    private ExtendedButton doneButton;
    private ExtendedButton resetToDefaultsButton;
    private ExtendedButton generalGroupButton;
    private ConfigCategory currentOption = ConfigCategory.General;
    private OptionsRowList currentRowList;
    private ArrayList<Quadruple<ConfigCategory, OptionsRowList, OptionsRowList, ConfigCategory>> optionCollection;
    private OptionsRowList optionsRowList;
    private OptionsRowList chestOptionsRowList;
    private OptionsRowList recipeOptionsRowList;
    private OptionsRowList starterHouseOptionsRowList;

    public GuiPrefab(Minecraft minecraft, Screen parent) {
        super("Prefab Configuration");
        this.parentScreen = parent;
        this.field_230706_i_ = minecraft;
    }

    @Nullable
    public static List<IReorderingProcessor> tooltipAt(OptionsRowList optionsRowList, int mouseX, int mouseY) {
        Optional optional;
        if (optionsRowList.func_231047_b_((double)mouseX, (double)mouseY) && (optional = optionsRowList.func_238518_c_((double)mouseX, (double)mouseY)).isPresent() && optional.get() instanceof IBidiTooltip) {
            Optional tooltip = ((IBidiTooltip)optional.get()).func_241867_d();
            return tooltip.orElse(null);
        }
        return null;
    }

    @Override
    protected void Initialize() {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int x = adjustedXYValue.getFirst();
        this.optionCollection = new ArrayList();
        this.resetToDefaultsButton = this.createAndAddButton(60, this.field_230709_l_ - 26, 100, 20, "Reset", false);
        this.doneButton = this.createAndAddButton(this.field_230708_k_ - 160, this.field_230709_l_ - 26, 100, 20, "Done", false);
        this.generalGroupButton = this.createAndAddButton(this.field_230708_k_ / 2, 30, 120, 20, "General", false);
        for (ConfigCategory category : ConfigCategory.values()) {
            OptionsRowList nextOptions = new OptionsRowList(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_, 55, this.field_230709_l_ - 32, 25);
            OptionsRowList currentOptions = null;
            int currentLocation = category.ordinal();
            if (currentLocation == 0) {
                currentOptions = new OptionsRowList(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_, 55, this.field_230709_l_ - 32, 25);
            } else {
                int currentOptionsIndex = currentLocation - 1;
                if (currentLocation == ConfigCategory.values().length - 1) {
                    nextOptions = this.optionCollection.get(0).getSecond();
                }
                currentOptions = this.optionCollection.get(currentOptionsIndex).getThird();
            }
            ConfigCategory nextCategory = ConfigCategory.getNextCategory(category);
            this.optionCollection.add(new Quadruple<ConfigCategory, OptionsRowList, OptionsRowList, ConfigCategory>(category, currentOptions, nextOptions, nextCategory));
        }
        for (ConfigOption configOption : CommonProxy.proxyConfiguration.configOptions) {
            Quadruple<ConfigCategory, OptionsRowList, OptionsRowList, ConfigCategory> rowList = this.getOptionsRowList(configOption.getCategory());
            if (rowList == null) continue;
            switch (configOption.getConfigType()) {
                case "Boolean": {
                    this.addBooleanOption(rowList.getSecond(), configOption);
                    break;
                }
                case "String": {
                    this.addStringOption(rowList.getSecond(), configOption);
                    break;
                }
                case "Integer": {
                    this.addIntegerOption(rowList.getSecond(), configOption);
                }
            }
        }
        this.field_230705_e_.add(this.optionCollection.get(0).getSecond());
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        if (button == this.doneButton) {
            ModConfiguration.UpdateServerConfig();
            this.getMinecraft().func_147108_a(this.parentScreen);
        } else if (button == this.generalGroupButton) {
            Quadruple<ConfigCategory, OptionsRowList, OptionsRowList, ConfigCategory> option = this.getOptionsRowList(this.currentOption);
            if (option != null) {
                this.field_230705_e_.remove(option.getSecond());
                this.field_230705_e_.add(option.getThird());
                GuiUtils.setButtonText(this.generalGroupButton, option.getFourth().getName());
                this.currentOption = option.getFourth();
            }
        } else if (button == this.resetToDefaultsButton) {
            for (ConfigOption<?> configOption : CommonProxy.proxyConfiguration.configOptions) {
                configOption.resetToDefault();
            }
            this.field_230710_m_.clear();
            this.field_230705_e_.clear();
            this.currentOption = ConfigCategory.General;
            this.Initialize();
        }
    }

    @Override
    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(0, 0);
    }

    @Override
    protected void preButtonRender(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.func_231165_f_(0);
        Quadruple<ConfigCategory, OptionsRowList, OptionsRowList, ConfigCategory> rowList = this.getOptionsRowList(this.currentOption);
        if (rowList != null) {
            rowList.getSecond().func_230430_a_(matrixStack, x, y, partialTicks);
            List<IReorderingProcessor> list = GuiPrefab.tooltipAt(rowList.getSecond(), mouseX, mouseY);
            if (list != null) {
                int mousePosition = mouseY > this.field_230709_l_ / 2 ? mouseY - 25 : mouseY + 25;
                this.func_238654_b_(matrixStack, list, mouseX, mousePosition);
            }
        }
        AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.field_230704_d_.getString(), (int)(this.field_230708_k_ / 2), (int)8, (int)0xFFFFFF);
        AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"Category", (int)(this.field_230708_k_ / 2 - 50), (int)35, (int)0xFFFFFF);
    }

    @Override
    protected void postButtonRender(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
    }

    private void addBooleanOption(OptionsRowList rowList, ConfigOption<?> configOption) {
        BooleanOption abstractOption = new BooleanOption(configOption.getName(), unused -> (Boolean)configOption.getConfigValueAsBoolean().get(), (unused, newValue) -> configOption.getConfigValueAsBoolean().set(newValue));
        if (!configOption.getHoverText().isEmpty()) {
            abstractOption.func_241567_a_(this.getSplitString(configOption.getHoverTextComponent(), 250));
        }
        rowList.func_214333_a((AbstractOption)abstractOption);
    }

    private void addIntegerOption(OptionsRowList rowList, ConfigOption<?> configOption) {
        SliderPercentageOption abstractOption = new SliderPercentageOption(configOption.getName(), (double)configOption.getMinRange(), (double)configOption.getMaxRange(), 1.0f, unused -> (double)((Integer)configOption.getConfigValueAsInt().get()), (unused, newValue) -> configOption.getConfigValueAsInt().set((Object)newValue.intValue()), (gs, option) -> Utils.createTextComponent(configOption.getName() + ": " + (int)option.func_216729_a(gs)));
        if (!configOption.getHoverText().isEmpty()) {
            abstractOption.func_241567_a_(this.getSplitString(configOption.getHoverTextComponent(), 250));
        }
        rowList.func_214333_a((AbstractOption)abstractOption);
    }

    private void addStringOption(OptionsRowList rowList, ConfigOption<?> configOption) {
        IteratableOption abstractOption = new IteratableOption(configOption.getName(), (unused, newValue) -> {
            int nextIndex = configOption.getValidValues().indexOf(configOption.getConfigValueAsString().get()) + newValue;
            if (nextIndex >= configOption.getValidValues().size()) {
                nextIndex = 0;
            }
            configOption.getConfigValueAsString().set((Object)configOption.getValidValues().get(nextIndex));
        }, (unused, option) -> Utils.createTextComponent(configOption.getName() + ": " + (String)configOption.getConfigValueAsString().get()));
        if (!configOption.getHoverText().isEmpty()) {
            abstractOption.func_241567_a_(this.getSplitString(configOption.getHoverTextComponent(), 250));
        }
        rowList.func_214333_a((AbstractOption)abstractOption);
    }

    private Quadruple<ConfigCategory, OptionsRowList, OptionsRowList, ConfigCategory> getOptionsRowList(ConfigCategory listName) {
        for (Quadruple<ConfigCategory, OptionsRowList, OptionsRowList, ConfigCategory> option : this.optionCollection) {
            if (option.getFirst() != listName) continue;
            return option;
        }
        return null;
    }
}

