/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wuest.prefab.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiUtils {
    public static void bindTexture(ResourceLocation resourceLocation) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
    }

    public static void drawTexture(MatrixStack matrixStack, int x, int y, int z, int width, int height, int textureWidth, int textureHeight) {
        AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)z, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)textureHeight, (int)textureWidth);
    }

    public static void bindAndDrawTexture(ResourceLocation resourceLocation, MatrixStack matrixStack, int x, int y, int z, int width, int height, int textureWidth, int textureHeight) {
        GuiUtils.bindTexture(resourceLocation);
        GuiUtils.drawTexture(matrixStack, x, y, z, width, height, textureWidth, textureHeight);
    }

    public static void drawContinuousTexturedBox(ResourceLocation res, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        GuiUtils.bindTexture(res);
        GuiUtils.drawContinuousTexturedBox(x, y, u, v, width, height, textureWidth, textureHeight, topBorder, bottomBorder, leftBorder, rightBorder, zLevel);
    }

    public static void drawContinuousTexturedBox(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        GuiUtils.drawTexturedModalRect(x, y, u, v, leftBorder, topBorder, zLevel);
        GuiUtils.drawTexturedModalRect(x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        GuiUtils.drawTexturedModalRect(x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        GuiUtils.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            GuiUtils.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            GuiUtils.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                GuiUtils.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            GuiUtils.drawTexturedModalRect(x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            GuiUtils.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_225582_a_((double)x, (double)(y + height), (double)zLevel).func_225583_a_((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).func_181675_d();
        wr.func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).func_181675_d();
        wr.func_225582_a_((double)(x + width), (double)y, (double)zLevel).func_225583_a_((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).func_181675_d();
        wr.func_225582_a_((double)x, (double)y, (double)zLevel).func_225583_a_((float)u * 0.00390625f, (float)v * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexture(MatrixStack matrixStack, int x, int y, int z, int width, int height, float textureWidth, float textureHeight) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        float u = 0.0f;
        float v = 0.0f;
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_225582_a_((double)x, (double)(y + height), (double)z).func_225583_a_(u * f, (v + (float)height) * f1).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + height), (double)z).func_225583_a_((u + (float)width) * f, (v + (float)height) * f1).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)y, (double)z).func_225583_a_((u + (float)width) * f, v * f1).func_181675_d();
        vertexBuffer.func_225582_a_((double)x, (double)y, (double)z).func_225583_a_(u * f, v * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void bindAndDrawModalRectWithCustomSizedTexture(ResourceLocation resourceLocation, MatrixStack matrixStack, int x, int y, int z, int width, int height, float textureWidth, float textureHeight) {
        GuiUtils.bindTexture(resourceLocation);
        GuiUtils.drawTexture(matrixStack, x, y, z, width, height, textureWidth, textureHeight);
    }

    public static void bindAndDrawScaledTexture(ResourceLocation resourceLocation, MatrixStack matrixStack, int x, int y, int width, int height, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        GuiUtils.bindTexture(resourceLocation);
        GuiUtils.drawScaledTexture(matrixStack, x, y, width, height, regionWidth, regionHeight, textureWidth, textureHeight);
    }

    public static void drawScaledTexture(MatrixStack matrixStack, int x, int y, int width, int height, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)width, (int)height, (float)0.0f, (float)0.0f, (int)regionWidth, (int)regionHeight, (int)textureWidth, (int)textureHeight);
    }

    public static void setButtonText(Button button, String message) {
        button.func_238482_a_((ITextComponent)Utils.createTextComponent(message));
    }
}

