/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wuest.prefab.Utils;
import com.wuest.prefab.gui.GuiUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiCheckBox
extends AbstractButton {
    private static final ResourceLocation buttonTexture = new ResourceLocation("prefab", "textures/gui/prefab_checkbox.png");
    private static final ResourceLocation buttonTexturePressed = new ResourceLocation("prefab", "textures/gui/prefab_checkbox_selected.png");
    private static final ResourceLocation buttonTextureHover = new ResourceLocation("prefab", "textures/gui/prefab_checkbox_hover.png");
    protected int boxWidth = 11;
    protected int boxHeight;
    protected int stringColor;
    protected boolean withShadow;
    protected Minecraft mineCraft = Minecraft.func_71410_x();
    protected String displayString;
    protected IPressable handler;
    protected int labelWidth;
    protected boolean isChecked;

    public GuiCheckBox(int xPos, int yPos, String displayString, boolean isChecked, IPressable handler) {
        super(xPos, yPos, 11, 12, (ITextComponent)Utils.createTextComponent(displayString));
        this.displayString = displayString;
        this.stringColor = Color.DARK_GRAY.getRGB();
        this.handler = handler;
        this.withShadow = false;
        this.labelWidth = 98;
        this.isChecked = isChecked;
    }

    public int getStringColor() {
        return this.stringColor;
    }

    public GuiCheckBox setStringColor(int color) {
        this.stringColor = color;
        return this;
    }

    public void func_230930_b_() {
        boolean bl = this.isChecked = !this.isChecked;
        if (this.handler != null) {
            this.handler.onPress(this);
        }
    }

    public boolean getWithShadow() {
        return this.withShadow;
    }

    public GuiCheckBox setWithShadow(boolean value) {
        this.withShadow = value;
        return this;
    }

    public GuiCheckBox setLabelWidth(int value) {
        this.labelWidth = value;
        return this;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setIsChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        if (this.field_230694_p_) {
            ResourceLocation resourceLocation = buttonTexture;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean bl = this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.boxWidth && mouseY < this.field_230691_m_ + this.field_230689_k_;
            if (this.isChecked()) {
                resourceLocation = buttonTexturePressed;
            } else if (this.field_230692_n_) {
                resourceLocation = buttonTextureHover;
            }
            GuiUtils.bindTexture(resourceLocation);
            GuiUtils.drawTexture(matrixStack, this.field_230690_l_, this.field_230691_m_, 1, 11, 11, 11, 11);
            int color = this.stringColor;
            if (this.withShadow) {
                GuiCheckBox.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.mineCraft.field_71466_p, (String)this.displayString, (int)(this.field_230690_l_ + this.boxWidth + 2), (int)(this.field_230691_m_ + 2), (int)color);
            } else {
                this.mineCraft.field_71466_p.func_238418_a_((ITextProperties)Utils.createTextComponent(this.displayString), this.field_230690_l_ + this.boxWidth + 2, this.field_230691_m_ + 2, this.labelWidth, color);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onPress(GuiCheckBox var1);
    }
}

