/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Utils;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.GuiTabTray;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class GuiTab
extends Widget {
    protected static final ResourceLocation TAB_TEXTURES = new ResourceLocation("prefab", "textures/gui/gui_tab.png");
    protected static final ResourceLocation TAB_TEXTURES_hovered = new ResourceLocation("prefab", "textures/gui/gui_tab_hovered.png");
    private GuiTabTray parentTray;
    private boolean selected;
    private String name;

    public GuiTab(GuiTabTray parent, String name, int x, int y) {
        super(x, y, 50, 20, (ITextComponent)Utils.createTextComponent(name));
        this.Initialize(parent, name);
    }

    protected void Initialize(GuiTabTray parent, String name) {
        this.parentTray = parent;
        this.selected = false;
        this.name = name;
        this.field_230689_k_ = 20;
        this.field_230688_j_ = 50;
        this.field_230694_p_ = true;
    }

    public GuiTabTray getParent() {
        return this.parentTray;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) throws Exception {
        if (this.parentTray.DoesTabNameExist(value)) {
            throw new Exception("A tab with the name of [" + value + "] already exists.");
        }
        this.name = value;
    }

    public boolean getIsSelected() {
        return this.selected;
    }

    public void setIsSelected(boolean value) {
        this.selected = value;
        this.parentTray.SetSelectedTab(this.selected ? this : null);
    }

    protected void InternalSetSelected(boolean value) {
        this.selected = value;
    }

    public void drawTab(Minecraft mc, MatrixStack matrixStack, int mouseX, int mouseY) {
        if (!this.field_230694_p_) {
            return;
        }
        FontRenderer fontrenderer = mc.field_71466_p;
        boolean bl = this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
        if (this.selected || this.field_230692_n_) {
            GuiUtils.bindTexture(TAB_TEXTURES_hovered);
        } else {
            GuiUtils.bindTexture(TAB_TEXTURES);
        }
        GuiUtils.drawTexture(matrixStack, this.field_230690_l_, this.field_230691_m_, 0, this.field_230688_j_, this.field_230689_k_, this.field_230688_j_, this.field_230689_k_);
        int j = Color.LIGHT_GRAY.getRGB();
        String buttonText = this.name;
        int strWidth = fontrenderer.func_78256_a(this.name);
        int ellipsisWidth = fontrenderer.func_78256_a("...");
        if (strWidth > this.field_230688_j_ - 6 && strWidth > ellipsisWidth) {
            buttonText = mc.field_71466_p.func_238417_a_((ITextProperties)Utils.createTextComponent(buttonText), this.field_230688_j_ - 6 - ellipsisWidth).getString() + "...";
        }
        int stringXPosition = this.field_230690_l_ + this.field_230688_j_ / 2 - fontrenderer.func_78256_a(buttonText) / 2;
        fontrenderer.func_238421_b_(matrixStack, buttonText, (float)stringXPosition, (float)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), j);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int buttonClicked) {
        boolean value;
        boolean bl = value = mouseX >= (double)this.field_230690_l_ && mouseY >= (double)this.field_230691_m_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_) && this.func_230987_a_(buttonClicked);
        if (value && !this.selected) {
            this.setIsSelected(true);
        }
        return value;
    }

    public void func_230988_a_(SoundHandler soundHandlerIn) {
        soundHandlerIn.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }
}

