/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Utils;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.GuiTab;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiTabTray
extends Widget {
    private static final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/default_background.png");
    private ArrayList<GuiTab> tabs;

    public GuiTabTray() {
        super(0, 0, 50, 35, (ITextComponent)Utils.createTextComponent("Tab Tray"));
        this.Initialize();
    }

    protected void Initialize() {
        this.tabs = new ArrayList();
        this.field_230689_k_ = 35;
        this.field_230688_j_ = 50;
    }

    public GuiTab AddTab(GuiTab tab) {
        if (this.tabs.size() == 0) {
            tab.InternalSetSelected(true);
        }
        this.tabs.add(tab);
        return tab;
    }

    public void RemoveTab(GuiTab tab) {
        this.tabs.remove((Object)tab);
    }

    public int TabCount() {
        return this.tabs.size();
    }

    public GuiTab GetSelectedTab() {
        if (this.tabs.size() > 0) {
            for (GuiTab tab : this.tabs) {
                if (!tab.getIsSelected()) continue;
                return tab;
            }
        }
        return null;
    }

    public void SetSelectedTab(GuiTab tab) {
        GuiTab firstTab = null;
        for (GuiTab guiTab : this.tabs) {
            if (firstTab == null) {
                firstTab = guiTab;
            }
            guiTab.InternalSetSelected(false);
        }
        if (tab != null) {
            tab.InternalSetSelected(true);
        } else {
            assert (firstTab != null);
            firstTab.InternalSetSelected(true);
        }
    }

    public boolean DoesTabNameExist(String name) {
        for (GuiTab tab : this.tabs) {
            if (!tab.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void DrawTabs(Minecraft mc, MatrixStack matrixStack, int mouseX, int mouseY) {
        GuiUtils.bindAndDrawTexture(backgroundTextures, matrixStack, this.field_230690_l_, this.field_230691_m_, 0, this.field_230688_j_, this.field_230689_k_, this.field_230688_j_, 35);
        for (GuiTab tab : this.tabs) {
            tab.drawTab(mc, matrixStack, mouseX, mouseY);
        }
    }

    public ArrayList<GuiTab> GetTabs() {
        return this.tabs;
    }
}

