/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.blocks.BlockStructureScanner;
import com.wuest.prefab.config.StructureScannerConfig;
import com.wuest.prefab.gui.GuiBase;
import com.wuest.prefab.gui.controls.CustomButton;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.gui.controls.GuiTextBox;
import com.wuest.prefab.structures.messages.StructureScannerActionMessage;
import com.wuest.prefab.structures.messages.StructureScannerSyncMessage;
import java.awt.Color;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class GuiStructureScanner
extends GuiBase {
    private final BlockPos blockPos;
    private final World world;
    private StructureScannerConfig config;
    private ExtendedButton btnStartingPositionMoveLeft;
    private ExtendedButton btnStartingPositionMoveRight;
    private ExtendedButton btnStartingPositionMoveDown;
    private ExtendedButton btnStartingPositionMoveUp;
    private ExtendedButton btnWidthGrow;
    private ExtendedButton btnWidthShrink;
    private ExtendedButton btnLengthGrow;
    private ExtendedButton btnLengthShrink;
    private ExtendedButton btnHeightGrow;
    private ExtendedButton btnHeightShrink;
    private GuiTextBox txtZipName;
    private CustomButton btnScan;
    private ExtendedButton btnSet;

    public GuiStructureScanner(BlockPos blockPos, World world, StructureScannerConfig config) {
        super("Structure Scanner");
        this.blockPos = blockPos;
        this.world = world;
        this.config = config;
        this.config.blockPos = this.blockPos;
    }

    @Override
    protected void Initialize() {
        super.Initialize();
        this.config.direction = (Direction)this.world.func_180495_p(this.blockPos).func_177229_b((Property)BlockStructureScanner.FACING);
        Tuple<Integer, Integer> adjustedXYValues = this.getAdjustedXYValue();
        int adjustedX = adjustedXYValues.getFirst();
        int adjustedY = adjustedXYValues.getSecond();
        this.btnStartingPositionMoveDown = this.createAndAddButton(adjustedX + 33, adjustedY + 50, 25, 20, "^");
        this.btnStartingPositionMoveDown.fontScale = 2.0f;
        this.btnStartingPositionMoveLeft = this.createAndAddButton(adjustedX + 20, adjustedY + 75, 25, 20, "<");
        this.btnStartingPositionMoveLeft.fontScale = 2.0f;
        this.btnStartingPositionMoveRight = this.createAndAddButton(adjustedX + 47, adjustedY + 75, 25, 20, ">");
        this.btnStartingPositionMoveRight.fontScale = 2.0f;
        this.btnStartingPositionMoveUp = this.createAndAddButton(adjustedX + 33, adjustedY + 100, 25, 20, "v");
        this.btnLengthShrink = this.createAndAddButton(adjustedX + 120, adjustedY + 30, 25, 20, "v");
        this.btnLengthGrow = this.createAndAddButton(adjustedX + 147, adjustedY + 30, 25, 20, "^");
        this.btnLengthGrow.fontScale = 2.0f;
        this.btnWidthShrink = this.createAndAddButton(adjustedX + 200, adjustedY + 30, 25, 20, "v");
        this.btnWidthGrow = this.createAndAddButton(adjustedX + 227, adjustedY + 30, 25, 20, "^");
        this.btnWidthGrow.fontScale = 2.0f;
        this.btnHeightShrink = this.createAndAddButton(adjustedX + 270, adjustedY + 30, 25, 20, "v");
        this.btnHeightGrow = this.createAndAddButton(adjustedX + 297, adjustedY + 30, 25, 20, "^");
        this.btnHeightGrow.fontScale = 2.0f;
        this.txtZipName = new GuiTextBox(this.getMinecraft().field_71466_p, adjustedX + 120, adjustedY + 75, 150, 20, (ITextComponent)new StringTextComponent(""));
        if (this.config.structureZipName == null || this.config.structureZipName.trim().equals("")) {
            this.txtZipName.setValue("Structure Name Here");
        } else {
            this.txtZipName.setValue(this.config.structureZipName);
        }
        this.txtZipName.setMaxLength(128);
        this.txtZipName.setBordered(true);
        this.txtZipName.backgroundColor = Color.WHITE.getRGB();
        this.txtZipName.setTextColor(Color.DARK_GRAY.getRGB());
        this.txtZipName.drawsTextShadow = false;
        this.func_230480_a_(this.txtZipName);
        this.btnSet = this.createAndAddButton(adjustedX + 25, adjustedY + 140, 90, 20, "Set And Close");
        this.btnScan = this.createAndAddCustomButton(adjustedX + 200, adjustedY + 140, 90, 20, "Scan");
    }

    @Override
    protected void preButtonRender(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawControlBackground(matrixStack, x, y + 15, 350, 250);
    }

    @Override
    protected void postButtonRender(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawString(matrixStack, "Starting Position", x + 15, y + 20, this.textColor);
        this.drawString(matrixStack, "Left: " + this.config.blocksToTheLeft + " Down: " + -this.config.blocksDown, x + 15, y + 35, this.textColor);
        this.drawString(matrixStack, "Length: " + this.config.blocksLong, x + 120, y + 20, this.textColor);
        this.drawString(matrixStack, "Width: " + this.config.blocksWide, x + 200, y + 20, this.textColor);
        this.drawString(matrixStack, "Height: " + this.config.blocksTall, x + 270, y + 20, this.textColor);
        this.drawString(matrixStack, "Name", x + 120, y + 60, this.textColor);
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.config.structureZipName = this.txtZipName.getValue();
        if (this.config.structureZipName.trim().equals("")) {
            this.config.structureZipName = "Structure Name Here";
        }
        this.config.structureZipName = this.config.structureZipName.toLowerCase().trim().replace(' ', '_');
        if (button == this.btnScan) {
            this.sendScanPacket();
            this.closeScreen();
        } else if (button == this.btnSet) {
            boolean foundExistingConfig = false;
            for (StructureScannerConfig config : Prefab.proxy.structureScanners) {
                if (config.blockPos.func_177958_n() != this.config.blockPos.func_177958_n() || config.blockPos.func_177952_p() != this.config.blockPos.func_177952_p() || config.blockPos.func_177956_o() != this.config.blockPos.func_177956_o()) continue;
                foundExistingConfig = true;
                break;
            }
            if (!foundExistingConfig) {
                Prefab.proxy.structureScanners.add(this.config);
            }
            this.closeScreen();
        } else {
            if (button == this.btnStartingPositionMoveLeft) {
                ++this.config.blocksToTheLeft;
            }
            if (button == this.btnStartingPositionMoveRight) {
                --this.config.blocksToTheLeft;
            }
            if (button == this.btnStartingPositionMoveDown) {
                --this.config.blocksDown;
            }
            if (button == this.btnStartingPositionMoveUp) {
                ++this.config.blocksDown;
            }
            if (button == this.btnWidthGrow) {
                ++this.config.blocksWide;
            }
            if (button == this.btnWidthShrink) {
                --this.config.blocksWide;
            }
            if (button == this.btnLengthGrow) {
                ++this.config.blocksLong;
            }
            if (button == this.btnLengthShrink) {
                --this.config.blocksLong;
            }
            if (button == this.btnHeightGrow) {
                ++this.config.blocksTall;
            }
            if (button == this.btnHeightShrink) {
                --this.config.blocksTall;
            }
            this.sendUpdatePacket();
        }
    }

    private void sendUpdatePacket() {
        StructureScannerSyncMessage messagePacket = Utils.createGenericMessage(this.config.GetCompoundNBT(), StructureScannerSyncMessage.class);
        Prefab.network.sendToServer((Object)messagePacket);
    }

    private void sendScanPacket() {
        StructureScannerActionMessage messagePacket = Utils.createGenericMessage(this.config.GetCompoundNBT(), StructureScannerActionMessage.class);
        Prefab.network.sendToServer((Object)messagePacket);
    }
}

