/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.proxy;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.base.BaseConfig;
import com.wuest.prefab.blocks.BlockBoundary;
import com.wuest.prefab.blocks.BlockCustomWall;
import com.wuest.prefab.blocks.BlockGrassSlab;
import com.wuest.prefab.blocks.BlockGrassStairs;
import com.wuest.prefab.config.ServerModConfiguration;
import com.wuest.prefab.config.StructureScannerConfig;
import com.wuest.prefab.events.ClientEventHandler;
import com.wuest.prefab.gui.GuiPrefab;
import com.wuest.prefab.gui.screens.GuiStructureScanner;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.items.StructureItem;
import com.wuest.prefab.structures.render.ShaderHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class ClientProxy
extends CommonProxy {
    public static HashMap<StructureItem, GuiStructure> ModGuis = new HashMap();
    public ServerModConfiguration serverConfiguration = null;

    public ClientProxy() {
        this.isClient = true;
    }

    public static void AddGuis() {
    }

    @Override
    public void preInit(FMLCommonSetupEvent event) {
        super.preInit(event);
        ClientProxy.AddGuis();
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        super.init(event);
        Prefab.proxy.registerRenderers();
        ClientProxy.RegisterBlockRenderer();
    }

    @Override
    public void postinit(FMLCommonSetupEvent event) {
        super.postinit(event);
    }

    @Override
    public void RegisterEventHandler() {
        Optional modContainer = ModList.get().getModContainerById("prefab");
        if (modContainer != null && modContainer.isPresent()) {
            Supplier<BiFunction> prefabGui = () -> GuiPrefab::new;
            ((ModContainer)modContainer.get()).registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, prefabGui);
        }
    }

    @Override
    public void registerRenderers() {
        ShaderHelper.Initialize();
    }

    @Override
    public ServerModConfiguration getServerConfiguration() {
        if (this.serverConfiguration == null) {
            return CommonProxy.proxyConfiguration.serverConfiguration;
        }
        return this.serverConfiguration;
    }

    @Override
    public void openGuiForItem(ItemUseContext itemUseContext) {
        for (Map.Entry<StructureItem, GuiStructure> entry : ModGuis.entrySet()) {
            if (entry.getKey() != itemUseContext.func_195996_i().func_77973_b()) continue;
            GuiStructure screen = entry.getValue();
            screen.pos = itemUseContext.func_195995_a();
            Minecraft.func_71410_x().func_147108_a((Screen)screen);
        }
    }

    @Override
    public void openGuiForBlock(BlockPos blockPos, World world, BaseConfig config) {
        GuiStructureScanner screen = null;
        if (config instanceof StructureScannerConfig) {
            screen = new GuiStructureScanner(blockPos, world, (StructureScannerConfig)config);
        }
        if (screen != null) {
            Minecraft.func_71410_x().func_147108_a(screen);
        }
    }

    @Override
    public void clientSetup(FMLClientSetupEvent clientSetupEvent) {
        this.registerKeyBindings(clientSetupEvent);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModRegistry.BlockBoundary.get()), BlockBoundary::canRenderInLayer);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModRegistry.GlassSlab.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModRegistry.GlassStairs.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModRegistry.PaperLantern.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModRegistry.BlockPhasing.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModRegistry.DirtWall.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModRegistry.GrassWall.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModRegistry.GrassStairs.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModRegistry.DirtStairs.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModRegistry.DirtSlab.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModRegistry.GrassSlab.get()), (RenderType)RenderType.func_228641_d_());
    }

    private void registerKeyBindings(FMLClientSetupEvent clientSetupEvent) {
        clientSetupEvent.enqueueWork(() -> {
            KeyBinding binding = new KeyBinding("Build Current Structure", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputMappings.Type.KEYSYM, 66, "Prefab - Structure Preview");
            ClientEventHandler.keyBindings.add(binding);
            ClientRegistry.registerKeyBinding((KeyBinding)binding);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void RegisterBlockRenderer() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColors.func_228358_a_((IBlockDisplayReader)worldIn, (BlockPos)pos) : GrassColors.func_77480_a((double)0.5, (double)1.0), new Block[]{(Block)ModRegistry.GrassWall.get(), (Block)ModRegistry.GrassSlab.get(), (Block)ModRegistry.GrassStairs.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> {
            Item item = stack.func_77973_b();
            if (item instanceof BlockItem) {
                BlockItem itemBlock = (BlockItem)item;
                boolean paintBlock = false;
                if (itemBlock.func_179223_d() instanceof BlockCustomWall) {
                    BlockCustomWall customWall = (BlockCustomWall)itemBlock.func_179223_d();
                    if (customWall.BlockVariant == BlockCustomWall.EnumType.GRASS) {
                        paintBlock = true;
                    }
                } else if (itemBlock.func_179223_d() instanceof BlockGrassSlab) {
                    paintBlock = true;
                } else if (itemBlock.func_179223_d() instanceof BlockGrassStairs) {
                    paintBlock = true;
                }
                if (paintBlock) {
                    BlockPos pos = Minecraft.func_71410_x().field_71439_g.func_233580_cy_();
                    ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                    return BiomeColors.func_228358_a_((IBlockDisplayReader)world, (BlockPos)pos);
                }
            }
            return -1;
        }, (IItemProvider[])new Block[]{(Block)ModRegistry.GrassWall.get(), (Block)ModRegistry.GrassSlab.get(), (Block)ModRegistry.GrassStairs.get()});
    }
}

