/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.config.enums.AdvancedAquaBaseOptions;
import com.wuest.prefab.structures.config.enums.AdvancedFarmOptions;
import com.wuest.prefab.structures.config.enums.AdvancedWarehouseOptions;
import com.wuest.prefab.structures.config.enums.AquaBaseOptions;
import com.wuest.prefab.structures.config.enums.BaseOption;
import com.wuest.prefab.structures.config.enums.DefenseBunkerOptions;
import com.wuest.prefab.structures.config.enums.EnderGatewayOptions;
import com.wuest.prefab.structures.config.enums.GrassyPlainOptions;
import com.wuest.prefab.structures.config.enums.JailOptions;
import com.wuest.prefab.structures.config.enums.MachineryTowerOptions;
import com.wuest.prefab.structures.config.enums.MagicTempleOptions;
import com.wuest.prefab.structures.config.enums.MineshaftEntranceOptions;
import com.wuest.prefab.structures.config.enums.ModerateFarmOptions;
import com.wuest.prefab.structures.config.enums.ModernBuildingsOptions;
import com.wuest.prefab.structures.config.enums.NetherGateOptions;
import com.wuest.prefab.structures.config.enums.SaloonOptions;
import com.wuest.prefab.structures.config.enums.SkiLodgeOptions;
import com.wuest.prefab.structures.config.enums.StarterFarmOptions;
import com.wuest.prefab.structures.config.enums.TownHallOptions;
import com.wuest.prefab.structures.config.enums.VillagerHouseOptions;
import com.wuest.prefab.structures.config.enums.WarehouseOptions;
import com.wuest.prefab.structures.config.enums.WatchTowerOptions;
import com.wuest.prefab.structures.config.enums.WelcomeCenterOptions;
import com.wuest.prefab.structures.config.enums.WindMillOptions;
import com.wuest.prefab.structures.config.enums.WorkshopOptions;
import com.wuest.prefab.structures.items.ItemBasicStructure;
import com.wuest.prefab.structures.predefined.StructureBasic;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class BasicStructureConfiguration
extends StructureConfiguration {
    private static final String structureEnumNameTag = "structureEnumName";
    private static final String structureDisplayNameTag = "structureDisplayName";
    private static final String bedColorTag = "bedColor";
    private static final String glassColorTag = "glassColor";
    private static final String chosenOptionTag = "chosenOption";
    public EnumBasicStructureName basicStructureName;
    public String structureDisplayName;
    public DyeColor bedColor;
    public FullDyeColor glassColor;
    public BaseOption chosenOption;

    public String getDisplayName() {
        if (this.basicStructureName == EnumBasicStructureName.Custom) {
            return this.structureDisplayName;
        }
        return this.basicStructureName.getItemTranslationString();
    }

    public boolean IsCustomStructure() {
        return this.basicStructureName == EnumBasicStructureName.Custom;
    }

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseFacing = Direction.NORTH;
        this.basicStructureName = EnumBasicStructureName.AquaBase;
        this.bedColor = DyeColor.RED;
        this.glassColor = FullDyeColor.CLEAR;
        this.chosenOption = this.basicStructureName.baseOption.getSpecificOptions(false).get(0);
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundNBT messageTag, StructureConfiguration config) {
        BasicStructureConfiguration basicConfig = (BasicStructureConfiguration)config;
        if (messageTag.func_74764_b(structureEnumNameTag)) {
            basicConfig.basicStructureName = EnumBasicStructureName.valueOf(messageTag.func_74779_i(structureEnumNameTag));
        }
        if (messageTag.func_74764_b(structureDisplayNameTag)) {
            basicConfig.structureDisplayName = messageTag.func_74779_i(structureDisplayNameTag);
        }
        if (messageTag.func_74764_b(bedColorTag)) {
            basicConfig.bedColor = DyeColor.valueOf((String)messageTag.func_74779_i(bedColorTag));
        }
        if (messageTag.func_74764_b(glassColorTag)) {
            basicConfig.glassColor = FullDyeColor.valueOf(messageTag.func_74779_i(glassColorTag));
        }
        if (messageTag.func_74764_b(chosenOptionTag)) {
            basicConfig.chosenOption = BaseOption.getOptionByTranslationString(messageTag.func_74779_i(chosenOptionTag));
        }
    }

    @Override
    protected CompoundNBT CustomWriteToCompoundNBT(CompoundNBT tag) {
        tag.func_74778_a(structureEnumNameTag, this.basicStructureName.name());
        if (this.structureDisplayName != null) {
            tag.func_74778_a(structureDisplayNameTag, this.structureDisplayName);
        }
        tag.func_74778_a(bedColorTag, this.bedColor.func_176610_l().toUpperCase());
        tag.func_74778_a(glassColorTag, this.glassColor.func_176610_l().toUpperCase());
        tag.func_74778_a(chosenOptionTag, this.chosenOption.getTranslationString());
        return tag;
    }

    @Override
    public BasicStructureConfiguration ReadFromCompoundNBT(CompoundNBT messageTag) {
        BasicStructureConfiguration config = new BasicStructureConfiguration();
        return (BasicStructureConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(PlayerEntity player, ServerWorld world, BlockPos hitBlockPos) {
        StructureBasic structure;
        String assetLocation = "";
        if (!this.IsCustomStructure()) {
            assetLocation = this.chosenOption.getAssetLocation();
        }
        if ((structure = (StructureBasic)StructureBasic.CreateInstance(assetLocation, StructureBasic.class)).BuildStructure(this, world, hitBlockPos, Direction.NORTH, player)) {
            ItemStack stack = ItemBasicStructure.getBasicStructureItemInHand(player);
            if (!stack.func_77984_f()) {
                if (stack.func_190916_E() == 1) {
                    player.field_71071_by.func_184437_d(stack);
                } else {
                    stack.func_190920_e(stack.func_190916_E() - 1);
                }
                player.field_71070_bA.func_75142_b();
            } else {
                this.DamageHeldItem(player, stack.func_77973_b());
            }
        }
    }

    public static enum EnumBasicStructureName {
        Custom("custom", null, null, null),
        MachineryTower("machinery_tower", "item.prefab.item_machinery_tower", "item_machinery_tower", MachineryTowerOptions.Default),
        DefenseBunker("defense_bunker", "item.prefab.item_defense_bunker", "item_defense_bunker", DefenseBunkerOptions.Default),
        MineshaftEntrance("mineshaft_entrance", "item.prefab.item_mineshaft_entrance", "item_mineshaft_entrance", MineshaftEntranceOptions.Default),
        EnderGateway("ender_gateway", "item.prefab.item_ender_gateway", "item_ender_gateway", EnderGatewayOptions.Default),
        AquaBase("aqua_base", "item.prefab.item_aqua_base", "item_aqua_base", AquaBaseOptions.Default),
        GrassyPlain("grassy_plain", "item.prefab.item_grassy_plain", "item_grassy_plain", GrassyPlainOptions.Default),
        MagicTemple("magic_temple", "item.prefab.item_magic_temple", "item_magic_temple", MagicTempleOptions.Default),
        WatchTower("watch_tower", "item.prefab.item_watch_tower", "item_watch_tower", WatchTowerOptions.Default),
        WelcomeCenter("welcome_center", "item.prefab.item_welcome_center", "item_welcome_center", WelcomeCenterOptions.Default),
        Jail("jail", "item.prefab.item_jail", "item_jail", JailOptions.Default),
        Saloon("saloon", "item.prefab.item_saloon", "item_saloon", SaloonOptions.Default),
        SkiLodge("ski_lodge", "item.prefab.item_ski_lodge", "item_ski_lodge", SkiLodgeOptions.Default),
        WindMill("wind_mill", "item.prefab.item_wind_mill", "item_wind_mill", WindMillOptions.Default),
        TownHall("town_hall", "item.prefab.item_town_hall", "item_town_hall", TownHallOptions.Default),
        NetherGate("nether_gate", "item.prefab.item_nether_gate", "item_nether_gate", NetherGateOptions.AncientSkull),
        AdvancedAquaBase("advanced_aqua_base", "item.prefab.item_advanced_aqua_base", "item_advanced_aqua_base", AdvancedAquaBaseOptions.Default),
        WorkShop("workshop", "item.prefab.item_workshop", "item_workshop", WorkshopOptions.Default),
        VillagerHouses("villager_houses", "item.prefab.item_villager_houses", "item_villager_houses", VillagerHouseOptions.FLAT_ROOF),
        AdvancedWarehouse("advanced_warehouse", "item.prefab.item_advanced_warehouse", "item_advanced_warehouse", AdvancedWarehouseOptions.Default),
        Warehouse("warehouse", "item.prefab.item_warehouse", "item_warehouse", WarehouseOptions.Default),
        ModernBuildings("modern_buildings", "item.prefab.item_modern_buildings", "item_modern_buildings", ModernBuildingsOptions.Mall),
        StarterFarm("starter_farm", "item.prefab.item_starter_farm", "item_starter_farm", StarterFarmOptions.ElevatedFarm),
        ModerateFarm("moderate_farm", "item.prefab.item_moderate_farm", "item_moderate_farm", ModerateFarmOptions.AutomatedFarm),
        AdvancedFarm("advanced_farm", "item.prefab.item_advanced_farm", "item_advanced_farm", AdvancedFarmOptions.AutomatedBeeFarm);

        private final String name;
        private final String itemTranslationString;
        private final BaseOption baseOption;
        private ResourceLocation itemTextureLocation;

        private EnumBasicStructureName(String name, String itemTranslationString, String itemTextureLocation, BaseOption baseOption) {
            this.name = name;
            this.itemTranslationString = itemTranslationString;
            if (itemTextureLocation != null) {
                this.itemTextureLocation = new ResourceLocation("prefab", itemTextureLocation);
            }
            this.baseOption = baseOption;
        }

        public String getName() {
            return this.name;
        }

        public String getItemTranslationString() {
            return this.itemTranslationString;
        }

        public ResourceLocation getItemTextureLocation() {
            return this.itemTextureLocation;
        }

        public BaseOption getBaseOption() {
            return this.baseOption;
        }
    }
}

