/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.proxy.messages.PlayerEntityTagMessage;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.items.StructureItem;
import com.wuest.prefab.structures.predefined.StructureAlternateStart;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;

public class HouseConfiguration
extends StructureConfiguration {
    private static String addTorchesTag = "addTorches";
    private static String addBedTag = "addBed";
    private static String addCraftingTableTag = "addCraftingTable";
    private static String addFurnaceTag = "addFurnace";
    private static String addChestTag = "addChest";
    private static String addChestContentsTag = "addChestContents";
    private static String addMineShaftTag = "addMineShaft";
    private static String hitXTag = "hitX";
    private static String hitYTag = "hitY";
    private static String hitZTag = "hitZ";
    private static String houseFacingTag = "houseFacing";
    private static String houseStyleTag = "houseStyle";
    private static String glassColorTag = "glassColor";
    private static String bedColorTag = "bedColor";
    public boolean addTorches;
    public boolean addBed;
    public boolean addCraftingTable;
    public boolean addFurnace;
    public boolean addChest;
    public boolean addChestContents;
    public boolean addMineShaft;
    public HouseStyle houseStyle;
    public FullDyeColor glassColor;
    public DyeColor bedColor;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.BASIC;
        this.glassColor = FullDyeColor.LIGHT_GRAY;
        this.bedColor = DyeColor.RED;
        this.addTorches = true;
        this.addBed = true;
        this.addCraftingTable = true;
        this.addFurnace = true;
        this.addChest = true;
        this.addChestContents = true;
        this.addMineShaft = true;
    }

    @Override
    public CompoundNBT WriteToCompoundNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a(addTorchesTag, this.addTorches);
        tag.func_74757_a(addBedTag, this.addBed);
        tag.func_74757_a(addCraftingTableTag, this.addCraftingTable);
        tag.func_74757_a(addFurnaceTag, this.addFurnace);
        tag.func_74757_a(addChestTag, this.addChest);
        tag.func_74757_a(addChestContentsTag, this.addChestContents);
        tag.func_74757_a(addMineShaftTag, this.addMineShaft);
        tag.func_74768_a(hitXTag, this.pos.func_177958_n());
        tag.func_74768_a(hitYTag, this.pos.func_177956_o());
        tag.func_74768_a(hitZTag, this.pos.func_177952_p());
        tag.func_74778_a(houseFacingTag, this.houseFacing.func_176610_l());
        tag.func_74768_a(houseStyleTag, this.houseStyle.value);
        tag.func_74778_a(glassColorTag, this.glassColor.func_176610_l().toUpperCase());
        tag.func_74778_a(bedColorTag, this.bedColor.func_176610_l().toUpperCase());
        return tag;
    }

    @Override
    public HouseConfiguration ReadFromCompoundNBT(CompoundNBT tag) {
        HouseConfiguration config = null;
        if (tag != null) {
            config = new HouseConfiguration();
            if (tag.func_74764_b(addTorchesTag)) {
                config.addTorches = tag.func_74767_n(addTorchesTag);
            }
            if (tag.func_74764_b(addBedTag)) {
                config.addBed = tag.func_74767_n(addBedTag);
            }
            if (tag.func_74764_b(addCraftingTableTag)) {
                config.addCraftingTable = tag.func_74767_n(addCraftingTableTag);
            }
            if (tag.func_74764_b(addFurnaceTag)) {
                config.addFurnace = tag.func_74767_n(addFurnaceTag);
            }
            if (tag.func_74764_b(addChestTag)) {
                config.addChest = tag.func_74767_n(addChestTag);
            }
            if (tag.func_74764_b(addChestContentsTag)) {
                config.addChestContents = tag.func_74767_n(addChestContentsTag);
            }
            if (tag.func_74764_b(addMineShaftTag)) {
                config.addMineShaft = tag.func_74767_n(addMineShaftTag);
            }
            if (tag.func_74764_b(hitXTag)) {
                config.pos = new BlockPos(tag.func_74762_e(hitXTag), tag.func_74762_e(hitYTag), tag.func_74762_e(hitZTag));
            }
            if (tag.func_74764_b(houseFacingTag)) {
                config.houseFacing = Direction.func_176739_a((String)tag.func_74779_i(houseFacingTag));
            }
            if (tag.func_74764_b(houseStyleTag)) {
                config.houseStyle = HouseStyle.ValueOf(tag.func_74762_e(houseStyleTag));
            }
            if (tag.func_74764_b(glassColorTag)) {
                config.glassColor = FullDyeColor.valueOf(tag.func_74779_i(glassColorTag));
            }
            if (tag.func_74764_b(bedColorTag)) {
                config.bedColor = DyeColor.valueOf((String)tag.func_74779_i(bedColorTag));
            }
        }
        return config;
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(PlayerEntity player, ServerWorld world, BlockPos hitBlockPos) {
        boolean houseBuilt = true;
        StructureAlternateStart structure = (StructureAlternateStart)StructureAlternateStart.CreateInstance(this.houseStyle.getStructureLocation(), StructureAlternateStart.class);
        houseBuilt = structure.BuildStructure(this, world, hitBlockPos, Direction.NORTH, player);
        if (houseBuilt) {
            EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntityData(player);
            playerConfig.builtStarterHouse = true;
            playerConfig.saveToPlayer(player);
            this.RemoveStructureItemFromPlayer(player, (StructureItem)ModRegistry.StartHouse.get());
            Prefab.network.sendTo((Object)new PlayerEntityTagMessage(playerConfig.getModIsPlayerNewTag(player)), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static enum HouseStyle {
        BASIC(0, "prefab.gui.starter.basic.display", new ResourceLocation("prefab", "textures/gui/basic_house.png"), "assets/prefab/structures/basic_house.zip"),
        RANCH(1, "prefab.gui.starter.ranch.display", new ResourceLocation("prefab", "textures/gui/ranch_house.png"), "assets/prefab/structures/ranch_house.zip"),
        LOFT(2, "prefab.gui.starter.loft.display", new ResourceLocation("prefab", "textures/gui/loft_house.png"), "assets/prefab/structures/loft_house.zip"),
        HOBBIT(3, "prefab.gui.starter.hobbit.display", new ResourceLocation("prefab", "textures/gui/hobbit_house.png"), "assets/prefab/structures/hobbit_house.zip"),
        DESERT(4, "prefab.gui.starter.desert.display", new ResourceLocation("prefab", "textures/gui/desert_house.png"), "assets/prefab/structures/desert_house.zip"),
        SNOWY(5, "prefab.gui.starter.snowy.display", new ResourceLocation("prefab", "textures/gui/snowy_house.png"), "assets/prefab/structures/snowy_house.zip"),
        DESERT2(6, "prefab.gui.starter.desert.display2", new ResourceLocation("prefab", "textures/gui/desert_house2.png"), "assets/prefab/structures/desert_house2.zip"),
        SUBAQUATIC(7, "prefab.gui.starter.subaquatic.display", new ResourceLocation("prefab", "textures/gui/subaqua_house.png"), "assets/prefab/structures/subaqua_house.zip"),
        MODERN(8, "prefab.gui.starter.modern.display", new ResourceLocation("prefab", "textures/gui/modern_starting_house.png"), "assets/prefab/structures/modern_starting_house.zip"),
        CAMPSITE(9, "prefab.gui.starter.camping.display", new ResourceLocation("prefab", "textures/gui/campsite_house.png"), "assets/prefab/structures/campsite_house.zip");

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final String structureLocation;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, String structureLocation) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.structureLocation = structureLocation;
        }

        public static HouseStyle ValueOf(int value) {
            HouseStyle returnValue = BASIC;
            for (HouseStyle current : HouseStyle.values()) {
                if (current.value != value) continue;
                returnValue = current;
                break;
            }
            return returnValue;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }
    }
}

