/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.structures.base.EnumStructureMaterial;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.predefined.StructureInstantBridge;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class InstantBridgeConfiguration
extends StructureConfiguration {
    public int bridgeLength;
    public EnumStructureMaterial bridgeMaterial;
    public boolean includeRoof;
    public int interiorHeight;

    @Override
    public void Initialize() {
        super.Initialize();
        this.bridgeLength = 25;
        this.bridgeMaterial = EnumStructureMaterial.Cobblestone;
        this.interiorHeight = 3;
        this.includeRoof = true;
    }

    @Override
    public InstantBridgeConfiguration ReadFromCompoundNBT(CompoundNBT messageTag) {
        InstantBridgeConfiguration config = new InstantBridgeConfiguration();
        return (InstantBridgeConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(PlayerEntity player, ServerWorld world, BlockPos hitBlockPos) {
        StructureInstantBridge structure = StructureInstantBridge.CreateInstance();
        if (structure.BuildStructure(this, world, hitBlockPos, Direction.NORTH, player)) {
            this.DamageHeldItem(player, (Item)ModRegistry.InstantBridge.get());
        }
    }

    @Override
    protected CompoundNBT CustomWriteToCompoundNBT(CompoundNBT tag) {
        tag.func_74768_a("bridgeLength", this.bridgeLength);
        tag.func_74768_a("bridgeMaterial", this.bridgeMaterial.getNumber());
        tag.func_74757_a("includeRoof", this.includeRoof);
        tag.func_74768_a("interiorHeight", this.interiorHeight);
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundNBT messageTag, StructureConfiguration config) {
        if (messageTag.func_74764_b("bridgeLength")) {
            ((InstantBridgeConfiguration)config).bridgeLength = messageTag.func_74762_e("bridgeLength");
        }
        if (messageTag.func_74764_b("bridgeMaterial")) {
            ((InstantBridgeConfiguration)config).bridgeMaterial = EnumStructureMaterial.getMaterialByNumber(messageTag.func_74762_e("bridgeMaterial"));
        }
        if (messageTag.func_74764_b("includeRoof")) {
            ((InstantBridgeConfiguration)config).includeRoof = messageTag.func_74767_n("includeRoof");
        }
        if (messageTag.func_74764_b("interiorHeight")) {
            ((InstantBridgeConfiguration)config).interiorHeight = messageTag.func_74762_e("interiorHeight");
        }
    }
}

