/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.structures.items.StructureItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class StructureConfiguration {
    public static String houseFacingName = "House Facing";
    private static String hitXTag = "hitX";
    private static String hitYTag = "hitY";
    private static String hitZTag = "hitZ";
    private static String houseFacingTag = "wareHouseFacing";
    public Direction houseFacing;
    public BlockPos pos;

    public StructureConfiguration() {
        this.Initialize();
    }

    public void Initialize() {
        this.houseFacing = Direction.NORTH;
    }

    public CompoundNBT WriteToCompoundNBT() {
        CompoundNBT tag = new CompoundNBT();
        if (this.pos != null) {
            tag.func_74768_a(hitXTag, this.pos.func_177958_n());
            tag.func_74768_a(hitYTag, this.pos.func_177956_o());
            tag.func_74768_a(hitZTag, this.pos.func_177952_p());
        }
        tag.func_74778_a(houseFacingTag, this.houseFacing.func_176610_l());
        tag = this.CustomWriteToCompoundNBT(tag);
        return tag;
    }

    public StructureConfiguration ReadFromCompoundNBT(CompoundNBT messageTag) {
        return null;
    }

    public StructureConfiguration ReadFromCompoundNBT(CompoundNBT messageTag, StructureConfiguration config) {
        if (messageTag != null) {
            if (messageTag.func_74764_b(hitXTag)) {
                config.pos = new BlockPos(messageTag.func_74762_e(hitXTag), messageTag.func_74762_e(hitYTag), messageTag.func_74762_e(hitZTag));
            }
            if (messageTag.func_74764_b(houseFacingTag)) {
                config.houseFacing = Direction.func_176739_a((String)messageTag.func_74779_i(houseFacingTag));
            }
            this.CustomReadFromNBTTag(messageTag, config);
        }
        return config;
    }

    public void BuildStructure(PlayerEntity player, ServerWorld world) {
        BlockPos hitBlockPos = this.pos;
        this.ConfigurationSpecificBuildStructure(player, world, hitBlockPos);
    }

    protected void ConfigurationSpecificBuildStructure(PlayerEntity player, ServerWorld world, BlockPos hitBlockPos) {
    }

    protected CompoundNBT CustomWriteToCompoundNBT(CompoundNBT tag) {
        return tag;
    }

    protected void CustomReadFromNBTTag(CompoundNBT messageTag, StructureConfiguration config) {
    }

    protected void RemoveStructureItemFromPlayer(PlayerEntity player, StructureItem item) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() != item) {
            stack = player.func_184592_cb();
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.field_184439_c.set(0, (Object)ItemStack.field_190927_a);
            }
        } else {
            int slot = this.getSlotFor(player.field_71071_by, stack);
            if (slot != -1) {
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.field_71071_by.func_70299_a(slot, ItemStack.field_190927_a);
                }
            }
        }
        player.field_71070_bA.func_75142_b();
    }

    protected void DamageHeldItem(PlayerEntity player, Item item) {
        ItemStack stack = player.func_184614_ca().func_77973_b() == item ? player.func_184614_ca() : player.func_184592_cb();
        Hand hand = player.func_184614_ca().func_77973_b() == item ? Hand.MAIN_HAND : Hand.OFF_HAND;
        ItemStack copy = stack.func_77946_l();
        stack.func_222118_a(1, (LivingEntity)player, player1 -> player1.func_213334_d(hand));
        if (stack.func_190926_b()) {
            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)copy, (Hand)hand);
            EquipmentSlotType slotType = hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
            player.func_184201_a(slotType, ItemStack.field_190927_a);
        }
        player.field_71070_bA.func_75142_b();
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public int getSlotFor(PlayerInventory playerInventory, ItemStack stack) {
        for (int i = 0; i < playerInventory.field_70462_a.size(); ++i) {
            if (((ItemStack)playerInventory.field_70462_a.get(i)).func_190926_b() || !this.stackEqualExact(stack, (ItemStack)playerInventory.field_70462_a.get(i))) continue;
            return i;
        }
        return -1;
    }
}

