/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.events.ClientEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.gui.controls.GuiCheckBox;
import com.wuest.prefab.structures.base.EnumStructureMaterial;
import com.wuest.prefab.structures.config.InstantBridgeConfiguration;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.predefined.StructureInstantBridge;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class GuiInstantBridge
extends GuiStructure {
    private static final ResourceLocation structureTopDown = new ResourceLocation("prefab", "textures/gui/instant_bridge_top_down.png");
    protected InstantBridgeConfiguration configuration;
    private ExtendedButton btnMaterialType;
    private Slider sldrBridgeLength;
    private GuiCheckBox chckIncludeRoof;
    private Slider sldrInteriorHeight;

    public GuiInstantBridge() {
        super("Instant Bridge");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.InstantBridge;
    }

    @Override
    protected void Initialize() {
        this.modifiedInitialXAxis = 212;
        this.modifiedInitialYAxis = 117;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("InstantBridge", InstantBridgeConfiguration.class);
        this.configuration.pos = this.pos;
        this.structureImageLocation = structureTopDown;
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnMaterialType = this.createAndAddButton(grayBoxX + 15, grayBoxY + 45, 90, 20, this.configuration.bridgeMaterial.getName());
        this.sldrBridgeLength = this.createAndAddSlider(grayBoxX + 15, grayBoxY + 85, 90, 20, "", "", 25.0, 75.0, this.configuration.bridgeLength, false, true, this::buttonClicked);
        this.chckIncludeRoof = this.createAndAddCheckBox(grayBoxX + 15, grayBoxY + 112, "prefab.gui.bridge_include_roof", this.configuration.includeRoof, this::buttonClicked);
        this.sldrInteriorHeight = this.createAndAddSlider(grayBoxX + 15, grayBoxY + 140, 90, 20, "", "", 3.0, 8.0, this.configuration.interiorHeight, false, true, this::buttonClicked);
        this.sldrInteriorHeight.field_230694_p_ = this.chckIncludeRoof.isChecked();
        this.btnVisualize = this.createAndAddCustomButton(grayBoxX + 25, grayBoxY + 175, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(grayBoxX + 310, grayBoxY + 175, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(grayBoxX + 150, grayBoxY + 175, 90, 20, "prefab.gui.button.cancel");
    }

    @Override
    protected void preButtonRender(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int imagePanelUpperLeft = x + 132;
        int imagePanelWidth = 285;
        int imagePanelMiddle = imagePanelWidth / 2;
        this.func_230446_a_(matrixStack);
        this.drawControlLeftPanel(matrixStack, x + 10, y + 10, 125, 190);
        this.drawControlRightPanel(matrixStack, imagePanelUpperLeft, y + 10, imagePanelWidth, 190);
        int middleOfImage = this.shownImageWidth / 2;
        int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
        GuiUtils.bindAndDrawScaledTexture(this.structureImageLocation, matrixStack, imageLocation, y + 15, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight);
    }

    @Override
    protected void postButtonRender(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawSplitString(GuiLangKeys.translateString("item.prefab.item_instant_bridge"), x + 15, y + 17, 100, this.textColor);
        this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.bridge_material"), x + 15, y + 35, this.textColor);
        this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.bridge_length"), x + 15, y + 75, this.textColor);
        if (this.chckIncludeRoof.isChecked()) {
            this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.bridge_interior_height"), x + 15, y + 130, this.textColor);
        }
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        int sliderValue = this.sldrBridgeLength.getValueInt();
        if (sliderValue > 75) {
            sliderValue = 75;
        } else if (sliderValue < 25) {
            sliderValue = 25;
        }
        this.configuration.bridgeLength = sliderValue;
        sliderValue = this.sldrInteriorHeight.getValueInt();
        if (sliderValue > 8) {
            sliderValue = 8;
        } else if (sliderValue < 3) {
            sliderValue = 3;
        }
        this.configuration.interiorHeight = sliderValue;
        this.configuration.includeRoof = this.chckIncludeRoof.isChecked();
        this.configuration.houseFacing = this.player.func_174811_aO().func_176734_d();
        this.configuration.pos = this.pos;
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.chckIncludeRoof) {
            this.sldrInteriorHeight.field_230694_p_ = this.configuration.includeRoof = this.chckIncludeRoof.isChecked();
        }
        if (button == this.btnMaterialType) {
            this.configuration.bridgeMaterial = EnumStructureMaterial.getMaterialByNumber(this.configuration.bridgeMaterial.getNumber() + 1);
            GuiUtils.setButtonText(this.btnMaterialType, this.configuration.bridgeMaterial.getTranslatedName());
        } else if (button == this.btnVisualize) {
            StructureInstantBridge structure = new StructureInstantBridge();
            structure.getClearSpace().getShape().setDirection(Direction.SOUTH);
            structure.setupStructure(this.configuration, this.pos);
            this.performPreview(structure, this.configuration);
        }
    }
}

