/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.items;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.structures.gui.GuiBulldozer;
import com.wuest.prefab.structures.items.StructureItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBulldozer
extends StructureItem {
    private boolean creativePowered = false;

    public ItemBulldozer() {
        super(new Item.Properties().func_200916_a(ModRegistry.PREFAB_GROUP).func_200918_c(4));
    }

    public ItemBulldozer(boolean creativePowered) {
        super(new Item.Properties().func_200916_a(ModRegistry.PREFAB_GROUP));
        this.creativePowered = creativePowered;
    }

    @Override
    protected void Initialize() {
        if (Prefab.proxy.isClient) {
            this.RegisterGui(GuiBulldozer.class);
        }
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().func_201670_d() && context.func_196000_l() == Direction.UP && this.getPoweredValue(context.func_195999_j(), context.func_221531_n())) {
            Prefab.proxy.openGuiForItem(context);
            return ActionResultType.PASS;
        }
        return ActionResultType.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        boolean advancedKeyDown = Screen.func_231173_s_();
        if (!advancedKeyDown) {
            tooltip.add((ITextComponent)GuiLangKeys.translateToComponent("prefab.gui.tooltip.shift"));
        } else if (this.getPoweredValue(stack)) {
            tooltip.add((ITextComponent)GuiLangKeys.translateToComponent("prefab.gui.tooltip.bulldozer_powered"));
        } else {
            tooltip.add((ITextComponent)GuiLangKeys.translateToComponent("prefab.gui.tooltip.bulldozer_unpowered"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.getPoweredValue(stack) || super.func_77636_d(stack);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        if (stack.func_77978_p() == null || stack.func_77978_p().isEmpty()) {
            stack.func_77982_d(stack.serializeNBT());
        }
        return stack.func_77978_p();
    }

    private boolean getPoweredValue(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        return this.getPoweredValue(stack);
    }

    private boolean getPoweredValue(ItemStack stack) {
        if (this.creativePowered) {
            return true;
        }
        if (stack.func_77973_b() == ModRegistry.Bulldozer.get()) {
            if (stack.func_77978_p() == null || stack.func_77978_p().isEmpty()) {
                stack.func_77982_d(stack.serializeNBT());
            } else {
                CompoundNBT prefabTag;
                CompoundNBT tag = stack.func_77978_p();
                if (tag.func_74764_b("prefab") && (prefabTag = tag.func_74775_l("prefab")).func_74764_b("powered")) {
                    return prefabTag.func_74767_n("powered");
                }
            }
        }
        return false;
    }

    public void setPoweredValue(ItemStack stack, boolean value) {
        if (stack.func_77978_p() == null || stack.func_77978_p().isEmpty()) {
            stack.func_77982_d(stack.serializeNBT());
        }
        CompoundNBT prefabTag = new CompoundNBT();
        prefabTag.func_74757_a("powered", value);
        stack.func_77978_p().func_218657_a("prefab", (INBT)prefabTag);
    }
}

