/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.messages;

import com.wuest.prefab.proxy.messages.TagMessage;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.config.BulldozerConfiguration;
import com.wuest.prefab.structures.config.HouseConfiguration;
import com.wuest.prefab.structures.config.InstantBridgeConfiguration;
import com.wuest.prefab.structures.config.ModerateHouseConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.config.StructurePartConfiguration;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public class StructureTagMessage
extends TagMessage {
    private EnumStructureConfiguration structureConfig;

    public StructureTagMessage() {
    }

    public StructureTagMessage(CompoundNBT tagMessage, EnumStructureConfiguration structureConfig) {
        super(tagMessage);
        this.structureConfig = structureConfig;
    }

    public static StructureTagMessage decode(PacketBuffer buf) {
        CompoundNBT tag = buf.func_150793_b();
        StructureTagMessage returnValue = new StructureTagMessage();
        returnValue.structureConfig = EnumStructureConfiguration.getFromIdentifier(tag.func_74762_e("config"));
        returnValue.tagMessage = tag.func_74775_l("dataTag");
        return returnValue;
    }

    public static void encode(StructureTagMessage message, PacketBuffer buf) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("config", message.structureConfig.identifier);
        tag.func_218657_a("dataTag", (INBT)message.tagMessage);
        buf.func_150786_a(tag);
    }

    EnumStructureConfiguration getStructureConfig() {
        return this.structureConfig;
    }

    public static enum EnumStructureConfiguration {
        Basic(0, new BasicStructureConfiguration()),
        StartHouse(1, new HouseConfiguration()),
        ModerateHouse(2, new ModerateHouseConfiguration()),
        Bulldozer(3, new BulldozerConfiguration()),
        InstantBridge(4, new InstantBridgeConfiguration()),
        Parts(5, new StructurePartConfiguration());

        public int identifier;
        public StructureConfiguration structureConfig;

        private <T extends StructureConfiguration> EnumStructureConfiguration(int identifier, T structureConfig) {
            this.identifier = identifier;
            this.structureConfig = structureConfig;
        }

        public static EnumStructureConfiguration getFromIdentifier(int identifier) {
            for (EnumStructureConfiguration config : EnumStructureConfiguration.values()) {
                if (config.identifier != identifier) continue;
                return config;
            }
            return Basic;
        }

        public static EnumStructureConfiguration getByConfigurationInstance(StructureConfiguration structureConfig) {
            for (EnumStructureConfiguration configuration : EnumStructureConfiguration.values()) {
                if (!configuration.structureConfig.getClass().equals(structureConfig.getClass())) continue;
                return configuration;
            }
            return null;
        }
    }
}

