/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.config.enums.BaseOption;
import com.wuest.prefab.structures.config.enums.ModerateFarmOptions;
import java.util.ArrayList;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HopperBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StructureBasic
extends Structure {
    private BlockPos customBlockPos = null;
    private ArrayList<Tuple<BlockPos, BlockPos>> bedPositions = new ArrayList();

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, Direction assumedNorth, Block foundBlock, BlockState blockState, PlayerEntity player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        String structureName = config.basicStructureName.getName();
        BaseOption chosenOption = config.chosenOption;
        if (foundBlock instanceof HopperBlock && structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.ModerateFarm.getName()) && chosenOption == ModerateFarmOptions.AutomatedChickenCoop) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof TrapDoorBlock && structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock == Blocks.field_150360_v && structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.WorkShop.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing).func_177984_a();
        } else {
            if (foundBlock instanceof BedBlock && chosenOption.getHasBedColor()) {
                BlockPos bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                BlockPos bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                this.bedPositions.add(new Tuple<BlockPos, BlockPos>(bedHeadPosition, bedFootPosition));
                return true;
            }
            if (foundBlock.getRegistryName().func_110624_b().equals(Blocks.field_196807_gj.getRegistryName().func_110624_b()) && foundBlock.getRegistryName().func_110623_a().endsWith("glass") && config.chosenOption.getHasGlassColor()) {
                blockState = this.getStainedGlassBlock(config.glassColor);
                block.setBlockState(blockState);
                this.priorityOneBlocks.add(block);
                return true;
            }
            if (foundBlock.getRegistryName().func_110624_b().equals(Blocks.field_196825_gz.getRegistryName().func_110624_b()) && foundBlock.getRegistryName().func_110623_a().endsWith("glass_pane") && config.chosenOption.getHasGlassColor()) {
                blockState = this.getStainedGlassPaneBlock(config.glassColor);
                BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState, this);
                this.priorityOneBlocks.add(block);
                return true;
            }
        }
        return false;
    }

    @Override
    protected Boolean BlockShouldBeClearedDuringConstruction(StructureConfiguration configuration, World world, BlockPos originalPos, Direction assumedNorth, BlockPos blockPos) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName()) || config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AdvancedAquaBase.getName())) {
            BlockState blockState = world.func_180495_p(blockPos);
            return blockState.func_185904_a() != Material.field_151586_h;
        }
        return true;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, ServerWorld world, BlockPos originalPos, Direction assumedNorth, PlayerEntity player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        String structureName = config.basicStructureName.getName();
        BaseOption chosenOption = config.chosenOption;
        if (this.customBlockPos != null) {
            if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.ModerateFarm.getName()) && chosenOption == ModerateFarmOptions.AutomatedChickenCoop) {
                for (int i = 0; i < 4; ++i) {
                    ChickenEntity entity = new ChickenEntity(EntityType.field_200795_i, (World)world);
                    entity.func_70107_b((double)this.customBlockPos.func_177958_n(), (double)this.customBlockPos.func_177984_a().func_177956_o(), (double)this.customBlockPos.func_177952_p());
                    world.func_217376_c((Entity)entity);
                }
            } else if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName()) || structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.WorkShop.getName())) {
                BuildingMethods.PlaceMineShaft(world, this.customBlockPos.func_177977_b(), configuration.houseFacing, true);
            }
            this.customBlockPos = null;
        }
        if (this.bedPositions.size() > 0) {
            for (Tuple<BlockPos, BlockPos> bedPosition : this.bedPositions) {
                BuildingMethods.PlaceColoredBed((World)world, bedPosition.getFirst(), bedPosition.getSecond(), config.bedColor);
            }
        }
        if (structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName()) || structureName.equals(BasicStructureConfiguration.EnumBasicStructureName.AdvancedAquaBase.getName())) {
            BlockPos airPos = originalPos.func_177981_b(4).func_177967_a(configuration.houseFacing.func_176734_d(), 1);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176746_e()), false);
            world.func_217377_a(airPos, false);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176735_f()), false);
            airPos = airPos.func_177977_b();
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176746_e()), false);
            world.func_217377_a(airPos, false);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176735_f()), false);
            airPos = airPos.func_177977_b();
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176746_e()), false);
            world.func_217377_a(airPos, false);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176735_f()), false);
            airPos = airPos.func_177977_b();
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176746_e()), false);
            world.func_217377_a(airPos, false);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176735_f()), false);
            airPos = airPos.func_177972_a(configuration.houseFacing.func_176734_d()).func_177984_a();
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176746_e()), false);
            world.func_217377_a(airPos, false);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176735_f()), false);
            airPos = airPos.func_177984_a();
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176746_e()), false);
            world.func_217377_a(airPos, false);
            world.func_217377_a(airPos.func_177972_a(configuration.houseFacing.func_176735_f()), false);
            airPos = airPos.func_177984_a();
            world.func_217377_a(airPos, false);
        }
    }
}

