/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.BulldozerConfiguration;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class StructureBulldozer
extends Structure {
    public StructureBulldozer() {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(15);
        clearedSpace.getShape().setLength(16);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(1);
        this.setClearSpace(clearedSpace);
        this.setBlocks(new ArrayList<BuildBlock>());
    }

    @Override
    public void BeforeClearSpaceBlockReplaced(BlockPos pos) {
        BlockState state = this.world.func_180495_p(pos);
        BulldozerConfiguration configuration = (BulldozerConfiguration)this.configuration;
        if (!configuration.creativeMode && Prefab.proxy.getServerConfiguration().allowBulldozerToCreateDrops && state.func_177230_c().getHarvestLevel(state) < 4 && state.func_185887_b((IBlockReader)this.world, pos) >= 0.0f) {
            Block.func_220075_c((BlockState)state, (World)this.world, (BlockPos)pos);
        }
        if (configuration.creativeMode && state.func_177230_c() instanceof FlowingFluidBlock) {
            BuildingMethods.ReplaceBlock((World)this.world, pos, Blocks.field_150348_b);
        }
    }

    @Override
    public void BeforeHangingEntityRemoved(HangingEntity hangingEntity) {
        if (Prefab.proxy.getServerConfiguration().allowBulldozerToCreateDrops) {
            hangingEntity.func_110128_b(null);
        }
    }
}

