/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.config.StructurePartConfiguration;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StructurePart
extends Structure {
    public static StructurePart CreateInstance() {
        StructurePart structure = new StructurePart();
        return structure;
    }

    @Override
    public boolean BuildStructure(StructureConfiguration configuration, ServerWorld world, BlockPos originalPos, Direction assumedNorth, PlayerEntity player) {
        StructurePartConfiguration specificConfig = (StructurePartConfiguration)configuration;
        this.setClearSpace(new BuildClear());
        this.setupStructure((World)world, specificConfig, originalPos);
        return super.BuildStructure(specificConfig, world, originalPos, assumedNorth, player);
    }

    public void setupStructure(World world, StructurePartConfiguration configuration, BlockPos originalPos) {
        ArrayList<BuildBlock> buildingBlocks = new ArrayList<BuildBlock>();
        BlockState materialState = configuration.partMaterial.getBlockType();
        Direction facing = Direction.SOUTH;
        switch (configuration.style) {
            case Frame: {
                buildingBlocks = this.setupFrame(configuration, originalPos, materialState, facing);
                break;
            }
            case Gate: {
                buildingBlocks = this.setupGate(configuration, originalPos, materialState, facing);
                break;
            }
            case Stairs: {
                buildingBlocks = this.setupStairs(configuration, originalPos, configuration.stairsMaterial.stairsState, facing);
                break;
            }
            case Wall: {
                buildingBlocks = this.setupWall(configuration, originalPos, materialState, facing);
                break;
            }
            case DoorWay: {
                buildingBlocks = this.setupDoorway(configuration, originalPos, materialState, facing);
                break;
            }
            case Floor: {
                buildingBlocks = this.setupFloor(configuration, originalPos, materialState, facing);
                break;
            }
            case Roof: {
                buildingBlocks = this.setupRoof(configuration, originalPos, configuration.stairsMaterial.stairsState, facing);
                break;
            }
        }
        this.setBlocks(buildingBlocks);
    }

    private ArrayList<BuildBlock> setupFrame(StructurePartConfiguration configuration, BlockPos originalPos, BlockState materialState, Direction facing) {
        ArrayList<BuildBlock> buildingBlocks = new ArrayList<BuildBlock>();
        int width = configuration.generalWidth - 1;
        int height = configuration.generalHeight - 1;
        BlockPos lowerNearLeft = originalPos.func_177985_f(configuration.generalWidth / 2);
        BlockPos upperNearLeft = lowerNearLeft.func_177981_b(height);
        BlockPos lowerFarLeft = lowerNearLeft.func_177964_d(width);
        BlockPos upperFarLeft = lowerNearLeft.func_177964_d(width).func_177981_b(height);
        BlockPos lowerNearRight = lowerNearLeft.func_177965_g(width);
        BlockPos upperNearRight = lowerNearRight.func_177981_b(height);
        BlockPos lowerFarRight = lowerNearRight.func_177964_d(width);
        BlockPos upperFarRight = lowerNearRight.func_177964_d(width).func_177981_b(height);
        this.makeBlockListForPositions(buildingBlocks, configuration, originalPos, materialState, facing, lowerNearLeft, lowerFarLeft);
        this.makeBlockListForPositions(buildingBlocks, configuration, originalPos, materialState, facing, lowerNearLeft, lowerNearRight);
        this.makeBlockListForPositions(buildingBlocks, configuration, originalPos, materialState, facing, lowerNearLeft, upperNearLeft);
        this.makeBlockListForPositions(buildingBlocks, configuration, originalPos, materialState, facing, lowerFarLeft, lowerFarRight);
        this.makeBlockListForPositions(buildingBlocks, configuration, originalPos, materialState, facing, lowerFarLeft, upperFarLeft);
        this.makeBlockListForPositions(buildingBlocks, configuration, originalPos, materialState, facing, lowerNearRight, lowerFarRight);
        this.makeBlockListForPositions(buildingBlocks, configuration, originalPos, materialState, facing, lowerNearRight, upperNearRight);
        this.makeBlockListForPositions(buildingBlocks, configuration, originalPos, materialState, facing, lowerFarRight, upperFarRight);
        this.makeBlockListForPositions(buildingBlocks, configuration, originalPos, materialState, facing, upperNearLeft, upperNearRight);
        this.makeBlockListForPositions(buildingBlocks, configuration, originalPos, materialState, facing, upperNearLeft, upperFarLeft);
        this.makeBlockListForPositions(buildingBlocks, configuration, originalPos, materialState, facing, upperFarRight, upperFarLeft);
        this.makeBlockListForPositions(buildingBlocks, configuration, originalPos, materialState, facing, upperFarRight, upperNearRight);
        return buildingBlocks;
    }

    private void makeBlockListForPositions(ArrayList<BuildBlock> buildingBlocks, StructurePartConfiguration configuration, BlockPos originalPos, BlockState materialState, Direction facing, BlockPos position1, BlockPos position2) {
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)position1, (BlockPos)position2)) {
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), pos, originalPos));
        }
    }

    private ArrayList<BuildBlock> setupGate(StructurePartConfiguration configuration, BlockPos originalPos, BlockState materialState, Direction facing) {
        ArrayList<BuildBlock> buildingBlocks = new ArrayList<BuildBlock>();
        BlockPos gatePos = null;
        BlockPos gateOriginalPos = originalPos.func_177985_f(configuration.generalWidth / 2).func_177984_a();
        ArrayList<Long> ignoredPositions = new ArrayList<Long>();
        ignoredPositions.add(originalPos.func_177984_a().func_218275_a());
        ignoredPositions.add(originalPos.func_177981_b(2).func_218275_a());
        if (configuration.generalWidth > 3 && configuration.generalHeight > 3) {
            ignoredPositions.add(originalPos.func_177981_b(3).func_218275_a());
            ignoredPositions.add(originalPos.func_177984_a().func_177976_e().func_218275_a());
            ignoredPositions.add(originalPos.func_177981_b(2).func_177976_e().func_218275_a());
            ignoredPositions.add(originalPos.func_177981_b(3).func_177976_e().func_218275_a());
            ignoredPositions.add(originalPos.func_177984_a().func_177974_f().func_218275_a());
            ignoredPositions.add(originalPos.func_177981_b(2).func_177974_f().func_218275_a());
            ignoredPositions.add(originalPos.func_177981_b(3).func_177974_f().func_218275_a());
        }
        for (int i = 0; i < configuration.generalHeight; ++i) {
            gatePos = gateOriginalPos.func_177981_b(i);
            for (int j = 0; j < configuration.generalWidth; ++j) {
                if (ignoredPositions.contains(gatePos.func_218275_a())) {
                    gatePos = gatePos.func_177972_a(facing.func_176735_f());
                    continue;
                }
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), gatePos, originalPos));
                gatePos = gatePos.func_177972_a(facing.func_176735_f());
            }
        }
        return buildingBlocks;
    }

    private ArrayList<BuildBlock> setupDoorway(StructurePartConfiguration configuration, BlockPos originalPos, BlockState materialState, Direction facing) {
        ArrayList<BuildBlock> buildingBlocks = new ArrayList<BuildBlock>();
        BlockPos gatePos = null;
        BlockPos gateOriginalPos = originalPos.func_177985_f(configuration.generalWidth / 2).func_177984_a();
        for (int i = 0; i < configuration.generalHeight; ++i) {
            gatePos = gateOriginalPos.func_177981_b(i);
            for (int j = 0; j < configuration.generalWidth; ++j) {
                if (gatePos.func_218275_a() == originalPos.func_177984_a().func_218275_a() || gatePos.func_218275_a() == originalPos.func_177981_b(2).func_218275_a()) {
                    gatePos = gatePos.func_177972_a(facing.func_176735_f());
                    continue;
                }
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), gatePos, originalPos));
                gatePos = gatePos.func_177972_a(facing.func_176735_f());
            }
        }
        DoorBlock door = (DoorBlock)Blocks.field_180413_ao;
        BuildBlock doorBlockBottom = Structure.createBuildBlockFromBlockState(door.func_176223_P(), (Block)door, originalPos.func_177984_a(), originalPos);
        BuildBlock doorBlockTop = Structure.createBuildBlockFromBlockState((BlockState)door.func_176223_P().func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), (Block)door, originalPos.func_177981_b(2), originalPos);
        doorBlockBottom.setSubBlock(doorBlockTop);
        buildingBlocks.add(doorBlockBottom);
        return buildingBlocks;
    }

    private ArrayList<BuildBlock> setupStairs(StructurePartConfiguration configuration, BlockPos originalPos, BlockState materialState, Direction facing) {
        ArrayList<BuildBlock> buildingBlocks = new ArrayList<BuildBlock>();
        BlockPos stepPos = null;
        BlockPos stepOriginalPos = originalPos.func_177985_f((int)((double)configuration.stairWidth - 0.2) / 2).func_177984_a();
        for (int i = 0; i < configuration.stairHeight; ++i) {
            stepPos = stepOriginalPos.func_177981_b(i).func_177964_d(i);
            for (int j = 0; j < configuration.stairWidth; ++j) {
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), stepPos, originalPos));
                stepPos = stepPos.func_177972_a(facing.func_176735_f());
            }
        }
        return buildingBlocks;
    }

    private ArrayList<BuildBlock> setupWall(StructurePartConfiguration configuration, BlockPos originalPos, BlockState materialState, Direction facing) {
        ArrayList<BuildBlock> buildingBlocks = new ArrayList<BuildBlock>();
        BlockPos wallPos = null;
        BlockPos wallOriginalPos = originalPos.func_177985_f(configuration.generalWidth / 2).func_177984_a();
        for (int i = 0; i < configuration.generalHeight; ++i) {
            wallPos = wallOriginalPos.func_177981_b(i);
            for (int j = 0; j < configuration.generalWidth; ++j) {
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), wallPos, originalPos));
                wallPos = wallPos.func_177972_a(facing.func_176735_f());
            }
        }
        return buildingBlocks;
    }

    private ArrayList<BuildBlock> setupFloor(StructurePartConfiguration configuration, BlockPos originalPos, BlockState materialState, Direction facing) {
        ArrayList<BuildBlock> buildingBlocks = new ArrayList<BuildBlock>();
        BlockPos floorPos = null;
        BlockPos floorOriginalPos = originalPos.func_177985_f(configuration.generalWidth / 2);
        for (int i = 0; i < configuration.generalHeight; ++i) {
            floorPos = floorOriginalPos.func_177964_d(i);
            for (int j = 0; j < configuration.generalWidth; ++j) {
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), floorPos, originalPos));
                floorPos = floorPos.func_177972_a(facing.func_176735_f());
            }
        }
        return buildingBlocks;
    }

    private ArrayList<BuildBlock> setupRoof(StructurePartConfiguration configuration, BlockPos originalPos, BlockState materialState, Direction facing) {
        ArrayList<BuildBlock> buildingBlocks = new ArrayList<BuildBlock>();
        BlockPos wallPos = null;
        BlockPos wallOriginalPos = originalPos.func_177985_f(configuration.stairWidth / 2).func_177984_a();
        BlockState stateWithoutFacing = (BlockState)((BlockState)materialState.func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.BOTTOM)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.STRAIGHT);
        int wallWidth = configuration.stairWidth;
        int wallDepth = configuration.stairWidth;
        int height = wallWidth / 2;
        boolean isWider = false;
        if (wallWidth > wallDepth) {
            height = wallDepth / 2;
            isWider = true;
        }
        wallPos = wallOriginalPos;
        for (int i = 0; i <= height; ++i) {
            for (int j = 0; j < 4; ++j) {
                Direction tempFacing = facing.func_176735_f();
                Direction flowDirection = facing.func_176734_d();
                int wallSize = wallDepth;
                switch (j) {
                    case 1: {
                        tempFacing = facing;
                        flowDirection = facing.func_176735_f();
                        wallSize = wallWidth;
                        break;
                    }
                    case 2: {
                        tempFacing = facing.func_176746_e();
                        flowDirection = facing;
                        wallSize = wallDepth;
                        break;
                    }
                    case 3: {
                        tempFacing = facing.func_176734_d();
                        flowDirection = facing.func_176746_e();
                        wallSize = wallWidth;
                    }
                }
                for (int k = 0; k <= wallSize; ++k) {
                    buildingBlocks.add(Structure.createBuildBlockFromBlockState((BlockState)stateWithoutFacing.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)tempFacing), materialState.func_177230_c(), wallPos, originalPos));
                    wallPos = wallPos.func_177972_a(flowDirection);
                }
            }
            wallPos = wallPos.func_177972_a(facing.func_176735_f()).func_177972_a(facing.func_176734_d()).func_177984_a();
            wallWidth -= 2;
            wallDepth -= 2;
        }
        long wallPosLong = wallPos.func_177977_b().func_218275_a();
        if (buildingBlocks.stream().noneMatch(x -> x.blockPos.func_218275_a() == wallPosLong)) {
            int finalStoneCount = wallDepth;
            if (isWider) {
                finalStoneCount = wallWidth;
            }
            finalStoneCount = finalStoneCount < 1 ? 1 : (finalStoneCount += 2);
            for (int i = 0; i < finalStoneCount; ++i) {
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(configuration.stairsMaterial.getFullBlock(), configuration.stairsMaterial.getFullBlock().func_177230_c(), wallPos, originalPos));
                wallPos = isWider ? wallPos.func_177972_a(facing.func_176735_f()) : wallPos.func_177972_a(facing.func_176734_d());
            }
        }
        return buildingBlocks;
    }
}

