/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.blocks.BlockStructureScanner;
import com.wuest.prefab.config.StructureScannerConfig;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.render.ShaderHelper;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class StructureRenderHandler {
    public static StructureConfiguration currentConfiguration;
    public static Structure currentStructure;
    public static Direction assumedNorth;
    public static boolean rendering;
    public static boolean showedMessage;
    private static int dimension;
    private static int overlay;

    public static void setStructure(Structure structure, Direction assumedNorth, StructureConfiguration configuration) {
        currentStructure = structure;
        StructureRenderHandler.assumedNorth = assumedNorth;
        currentConfiguration = configuration;
        showedMessage = false;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            dimension = mc.field_71441_e.func_230315_m_().func_241513_m_();
        }
    }

    public static void renderPlayerLook(PlayerEntity player, RayTraceResult src, MatrixStack matrixStack) {
        if (currentStructure != null && dimension == player.field_70170_p.func_230315_m_().func_241513_m_() && currentConfiguration != null && CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            TranslationTextComponent message;
            rendering = true;
            boolean didAny = false;
            IRenderTypeBuffer.Impl entityVertexConsumer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            ArrayList<Tuple<BlockState, BlockPos>> entityModels = new ArrayList<Tuple<BlockState, BlockPos>>();
            for (BuildBlock buildBlock : currentStructure.getBlocks()) {
                Block foundBlock = (Block)Registry.field_212618_g.func_82594_a(buildBlock.getResourceLocation());
                if (foundBlock == null) continue;
                BlockState blockState = foundBlock.func_176223_P();
                BuildBlock buildBlock2 = BuildBlock.SetBlockState(currentConfiguration, player.field_70170_p, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock, foundBlock, blockState, currentStructure);
                BlockPos pos = buildBlock2.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
                BlockRenderType blockRenderType = blockState.func_185901_i();
                if (blockRenderType == BlockRenderType.ENTITYBLOCK_ANIMATED) {
                    if (!ShaderHelper.hasIncompatibleMods) continue;
                    entityModels.add(new Tuple<BlockState, BlockPos>(buildBlock2.getBlockState(), pos));
                    continue;
                }
                if (!StructureRenderHandler.renderComponentInWorld(player.field_70170_p, buildBlock2, (IRenderTypeBuffer)entityVertexConsumer, matrixStack, pos, blockRenderType)) continue;
                didAny = true;
            }
            ShaderHelper.useShader(ShaderHelper.alphaShader, shader -> {
                int alpha = GlStateManager.func_227680_b_((int)shader, (CharSequence)"alpha");
                ShaderHelper.FLOAT_BUF.position(0);
                ShaderHelper.FLOAT_BUF.put(0, 0.4f);
                GlStateManager.func_227681_b_((int)alpha, (FloatBuffer)ShaderHelper.FLOAT_BUF);
            });
            entityVertexConsumer.func_228462_a_(Atlases.func_239280_i_());
            ShaderHelper.releaseShader();
            for (Tuple tuple : entityModels) {
                BlockPos blockPos = (BlockPos)tuple.getSecond();
                StructureRenderHandler.renderBlock(matrixStack, new Vector3d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()), (BlockState)tuple.getFirst(), (IRenderTypeBuffer)entityVertexConsumer, BlockRenderType.ENTITYBLOCK_ANIMATED);
            }
            if (!didAny) {
                StructureRenderHandler.setStructure(null, Direction.NORTH, null);
                message = new TranslationTextComponent("prefab.gui.preview.complete");
                message.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN));
                player.func_145747_a((ITextComponent)message, player.func_110124_au());
            } else if (!showedMessage) {
                message = new TranslationTextComponent("prefab.gui.preview.notice");
                message.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN));
                player.func_145747_a((ITextComponent)message, player.func_110124_au());
                showedMessage = true;
            }
        }
    }

    private static boolean renderComponentInWorld(World world, BuildBlock buildBlock, IRenderTypeBuffer entityVertexConsumer, MatrixStack matrixStack, BlockPos pos, BlockRenderType blockRenderType) {
        BlockState targetBlock = world.func_180495_p(pos);
        if (targetBlock.func_185904_a() != Material.field_151579_a && targetBlock.func_185904_a() != Material.field_151586_h) {
            return false;
        }
        StructureRenderHandler.doRenderComponent(buildBlock, pos, entityVertexConsumer, matrixStack, blockRenderType);
        if (buildBlock.getSubBlock() != null) {
            Block foundBlock = (Block)Registry.field_212618_g.func_82594_a(buildBlock.getSubBlock().getResourceLocation());
            BlockState blockState = foundBlock.func_176223_P();
            BuildBlock subBlock = BuildBlock.SetBlockState(currentConfiguration, world, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock.getSubBlock(), foundBlock, blockState, currentStructure);
            BlockPos subBlockPos = subBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
            BlockRenderType subBlockRenderType = subBlock.getBlockState().func_185901_i();
            return StructureRenderHandler.renderComponentInWorld(world, subBlock, entityVertexConsumer, matrixStack, subBlockPos, subBlockRenderType);
        }
        return true;
    }

    private static void doRenderComponent(BuildBlock buildBlock, BlockPos pos, IRenderTypeBuffer entityVertexConsumer, MatrixStack matrixStack, BlockRenderType blockRenderType) {
        BlockState state = buildBlock.getBlockState();
        StructureRenderHandler.renderBlock(matrixStack, new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), state, entityVertexConsumer, blockRenderType);
    }

    private static void renderBlock(MatrixStack matrixStack, Vector3d pos, BlockState state, IRenderTypeBuffer entityVertexConsumer, BlockRenderType blockRenderType) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Vector3d projectedView = minecraft.func_175598_ae().field_217783_c.func_216785_c();
        double renderPosX = projectedView.func_82615_a();
        double renderPosY = projectedView.func_82617_b();
        double renderPosZ = projectedView.func_82616_c();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-renderPosX, -renderPosY, -renderPosZ);
        BlockRendererDispatcher renderer = minecraft.func_175602_ab();
        matrixStack.func_227861_a_(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        IBakedModel bakedModel = renderer.func_184389_a(state);
        if (blockRenderType == BlockRenderType.MODEL) {
            int color = minecraft.func_184125_al().func_228054_a_(state, null, null, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            renderer.func_175019_b().func_228804_a_(matrixStack.func_227866_c_(), entityVertexConsumer.getBuffer(Atlases.func_239280_i_()), state, bakedModel, r, g, b, 0xF000F0, OverlayTexture.field_229196_a_);
        } else if (blockRenderType == BlockRenderType.ENTITYBLOCK_ANIMATED) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            IModelData modelData = ModelDataManager.getModelData((World)world, (BlockPos)new BlockPos(pos));
            if (modelData == null) {
                modelData = EmptyModelData.INSTANCE;
            }
            IModelData model = renderer.func_184389_a(state).getModelData((IBlockDisplayReader)world, new BlockPos(pos), state, modelData);
            renderer.renderBlock(state, matrixStack, entityVertexConsumer, 0xF000F0, overlay, model);
        }
        matrixStack.func_227865_b_();
    }

    public static void renderClickedBlock(World worldIn, MatrixStack matrixStack, double cameraX, double cameraY, double cameraZ) {
        if (currentStructure != null && dimension == Minecraft.func_71410_x().field_71439_g.field_70170_p.func_230315_m_().func_241513_m_() && currentConfiguration != null && CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            BlockPos originalPos = StructureRenderHandler.currentConfiguration.pos.func_177984_a();
            double blockXOffset = originalPos.func_177958_n();
            double blockZOffset = originalPos.func_177952_p();
            double blockStartYOffset = originalPos.func_177956_o();
            StructureRenderHandler.drawBox(matrixStack, blockXOffset, blockZOffset, blockStartYOffset, cameraX, cameraY, cameraZ, 1, 1, 1);
        }
    }

    private static void drawBox(MatrixStack matrixStack, double blockXOffset, double blockZOffset, double blockStartYOffset, double cameraX, double cameraY, double cameraZ, int xLength, int zLength, int height) {
        RenderSystem.enableDepthTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        RenderSystem.disableTexture();
        RenderSystem.disableBlend();
        double translatedX = blockXOffset - cameraX;
        double translatedY = blockStartYOffset - cameraY + 0.02;
        double translatedYEnd = translatedY + (double)height - 0.02;
        double translatedZ = blockZOffset - cameraZ;
        RenderSystem.lineWidth((float)2.0f);
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_225582_a_(translatedX, translatedY, translatedZ).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX, translatedYEnd, translatedZ).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_225582_a_(translatedX + (double)xLength, translatedY, translatedZ).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX + (double)xLength, translatedYEnd, translatedZ).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_225582_a_(translatedX, translatedY, translatedZ + (double)zLength).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX, translatedYEnd, translatedZ + (double)zLength).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_225582_a_(translatedX + (double)xLength, translatedY, translatedZ + (double)zLength).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX + (double)xLength, translatedYEnd, translatedZ + (double)zLength).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_225582_a_(translatedX, translatedY, translatedZ).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX, translatedY, translatedZ + (double)zLength).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX + (double)xLength, translatedY, translatedZ + (double)zLength).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX + (double)xLength, translatedY, translatedZ).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX, translatedY, translatedZ).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX + (double)xLength, translatedY, translatedZ).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX + (double)xLength, translatedY, translatedZ + (double)zLength).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX, translatedY, translatedZ + (double)zLength).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_225582_a_(translatedX, translatedYEnd, translatedZ).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX, translatedYEnd, translatedZ + (double)zLength).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX + (double)xLength, translatedYEnd, translatedZ + (double)zLength).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX + (double)xLength, translatedYEnd, translatedZ).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX, translatedYEnd, translatedZ).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX + (double)xLength, translatedYEnd, translatedZ).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX + (double)xLength, translatedYEnd, translatedZ + (double)zLength).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        bufferBuilder.func_225582_a_(translatedX, translatedYEnd, translatedZ + (double)zLength).func_227885_a_(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
    }

    public static void renderScanningBoxes(MatrixStack matrixStack, double cameraX, double cameraY, double cameraZ) {
        for (int i = 0; i < Prefab.proxy.structureScanners.size(); ++i) {
            StructureScannerConfig config = Prefab.proxy.structureScanners.get(i);
            BlockPos pos = config.blockPos;
            boolean removeConfig = false;
            boolean bl = removeConfig = pos == null;
            if (pos != null) {
                boolean bl2 = removeConfig = !(Minecraft.func_71410_x().field_71441_e.func_180495_p(pos).func_177230_c() instanceof BlockStructureScanner);
            }
            if (removeConfig) {
                Prefab.proxy.structureScanners.remove(i);
                --i;
                continue;
            }
            Direction leftDirection = config.direction.func_176735_f();
            BlockPos startingPosition = config.blockPos.func_177967_a(leftDirection, config.blocksToTheLeft).func_177967_a(Direction.DOWN, config.blocksDown).func_177967_a(config.direction, config.blocksParallel);
            int xLength = config.blocksWide;
            int zLength = config.blocksLong;
            switch (config.direction) {
                case NORTH: {
                    zLength = -zLength;
                    startingPosition = startingPosition.func_177972_a(config.direction.func_176734_d());
                    break;
                }
                case EAST: {
                    int tempWidth = xLength;
                    xLength = zLength;
                    zLength = tempWidth;
                    break;
                }
                case SOUTH: {
                    xLength = -xLength;
                    startingPosition = startingPosition.func_177972_a(config.direction.func_176735_f());
                    break;
                }
                case WEST: {
                    int tempLength = zLength;
                    zLength = -xLength;
                    xLength = -tempLength;
                    startingPosition = startingPosition.func_177972_a(config.direction.func_176734_d());
                    startingPosition = startingPosition.func_177972_a(config.direction.func_176735_f());
                    break;
                }
            }
            StructureRenderHandler.drawBox(matrixStack, startingPosition.func_177958_n(), startingPosition.func_177952_p(), startingPosition.func_177956_o(), cameraX, cameraY, cameraZ, xLength, zLength, config.blocksTall);
        }
    }

    static {
        rendering = false;
        showedMessage = false;
        overlay = OverlayTexture.func_229201_a_((int)5, (int)10);
    }
}

